/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.context;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.grpc.GlobalInterceptor;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Prioritized;
import org.jboss.logging.Logger;

@ApplicationScoped
@GlobalInterceptor
public class GrpcRequestContextGrpcInterceptor
implements ServerInterceptor,
Prioritized {
    private static final Logger log = Logger.getLogger((String)GrpcRequestContextGrpcInterceptor.class.getName());
    private final ManagedContext reqContext = Arc.container().requestContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context capturedVertxContext = Vertx.currentContext();
        if (capturedVertxContext != null) {
            InjectableContext.ContextState state;
            if (!this.reqContext.isActive()) {
                this.reqContext.activate();
                state = this.reqContext.getState();
            } else {
                state = null;
                log.warn((Object)"Request context already active when gRPC request started");
            }
            try {
                ForwardingServerCallListener.SimpleForwardingServerCallListener simpleForwardingServerCallListener = new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

                    public void onMessage(ReqT message) {
                        boolean activated = this.activateContext();
                        try {
                            super.onMessage(message);
                        }
                        finally {
                            if (activated) {
                                this.deactivateContext();
                            }
                        }
                    }

                    public void onReady() {
                        boolean activated = this.activateContext();
                        try {
                            super.onReady();
                        }
                        finally {
                            if (activated) {
                                this.deactivateContext();
                            }
                        }
                    }

                    public void onHalfClose() {
                        boolean activated = this.activateContext();
                        try {
                            super.onHalfClose();
                        }
                        finally {
                            if (activated) {
                                this.deactivateContext();
                            }
                        }
                    }

                    public void onCancel() {
                        boolean activated = this.activateContext();
                        try {
                            super.onCancel();
                        }
                        finally {
                            if (activated) {
                                this.deactivateContext();
                            }
                            if (state != null) {
                                GrpcRequestContextGrpcInterceptor.this.reqContext.destroy(state);
                            }
                        }
                    }

                    public void onComplete() {
                        boolean activated = this.activateContext();
                        try {
                            super.onComplete();
                        }
                        finally {
                            if (activated) {
                                this.deactivateContext();
                            }
                            if (state != null) {
                                GrpcRequestContextGrpcInterceptor.this.reqContext.destroy(state);
                            }
                        }
                    }

                    private void deactivateContext() {
                        GrpcRequestContextGrpcInterceptor.this.reqContext.deactivate();
                    }

                    private boolean activateContext() {
                        if (state != null && !GrpcRequestContextGrpcInterceptor.this.reqContext.isActive()) {
                            GrpcRequestContextGrpcInterceptor.this.reqContext.activate(state);
                            return true;
                        }
                        return false;
                    }
                };
                return simpleForwardingServerCallListener;
            }
            finally {
                this.reqContext.deactivate();
            }
        }
        log.warn((Object)"Unable to activate the request scope - interceptor not called on the Vert.x event loop");
        return next.startCall(call, headers);
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

