/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.devmode;

import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.runtime.ServerCalls;
import io.quarkus.grpc.runtime.StreamCollector;
import io.quarkus.grpc.runtime.devmode.CollectStreams;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@CollectStreams
@Priority(value=1)
@Interceptor
public class StreamCollectorInterceptor {
    private final StreamCollector streamCollector = ServerCalls.getStreamCollector();

    @AroundInvoke
    Object collect(InvocationContext context) throws Exception {
        Object[] params = context.getParameters();
        int streamIndex = 0;
        StreamObserver stream = null;
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null || !StreamObserver.class.isAssignableFrom(param.getClass())) continue;
            stream = (StreamObserver)param;
            streamIndex = i;
            break;
        }
        if (stream == null) {
            return context.proceed();
        }
        this.streamCollector.add(stream);
        Object[] newParams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            newParams[i] = i == streamIndex ? new StreamObserverWrapper(stream) : params[i];
        }
        context.setParameters(newParams);
        return context.proceed();
    }

    private final class StreamObserverWrapper<T>
    implements StreamObserver<T> {
        private final StreamObserver<T> delegate;

        public StreamObserverWrapper(StreamObserver<T> delegate) {
            this.delegate = delegate;
        }

        public void onNext(T value) {
            this.delegate.onNext(value);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
            StreamCollectorInterceptor.this.streamCollector.remove(this.delegate);
        }

        public void onCompleted() {
            this.delegate.onCompleted();
            StreamCollectorInterceptor.this.streamCollector.remove(this.delegate);
        }
    }
}

