/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.auth;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.quarkus.security.AuthenticationFailedException;
import javax.enterprise.inject.spi.Prioritized;

public class AuthExceptionHandler<ReqT, RespT>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>
implements Prioritized {
    private final ServerCall<ReqT, RespT> serverCall;
    private final Metadata metadata;

    public AuthExceptionHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
        super(listener);
        this.metadata = metadata;
        this.serverCall = serverCall;
    }

    public void onMessage(ReqT message) {
        try {
            super.onMessage(message);
        }
        catch (RuntimeException e) {
            this.handleException(e, this.serverCall, this.metadata);
        }
    }

    public void onHalfClose() {
        try {
            super.onHalfClose();
        }
        catch (RuntimeException e) {
            this.handleException(e, this.serverCall, this.metadata);
        }
    }

    public void onReady() {
        try {
            super.onReady();
        }
        catch (RuntimeException e) {
            this.handleException(e, this.serverCall, this.metadata);
        }
    }

    protected void handleException(RuntimeException exception, ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
        if (exception instanceof AuthenticationFailedException) {
            serverCall.close(Status.UNAUTHENTICATED.withDescription(exception.getMessage()), metadata);
        } else if (exception instanceof SecurityException) {
            serverCall.close(Status.PERMISSION_DENIED.withDescription(exception.getMessage()), metadata);
        } else {
            throw exception;
        }
    }

    public int getPriority() {
        return 0;
    }
}

