/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.blocking;

import io.vertx.core.Handler;
import io.vertx.core.Promise;

class DevModeBlockingExecutionHandler
implements Handler<Promise<Object>> {
    final ClassLoader tccl;
    final Handler<Promise<Object>> delegate;

    public DevModeBlockingExecutionHandler(ClassLoader tccl, Handler<Promise<Object>> delegate) {
        this.tccl = tccl;
        this.delegate = delegate;
    }

    public void handle(Promise<Object> event) {
        ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.tccl);
        try {
            this.delegate.handle(event);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTccl);
        }
    }
}

