/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime;

import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.config.SslServerConfig;
import io.quarkus.runtime.util.ClassPathUtils;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.jboss.logging.Logger;

public class GrpcSslUtils {
    private static final Logger LOGGER = Logger.getLogger((String)GrpcSslUtils.class.getName());

    static boolean applySslOptions(GrpcServerConfiguration config, HttpServerOptions options) throws IOException {
        if ((config.ssl.certificate.isPresent() || config.ssl.keyStore.isPresent()) && config.plainText) {
            LOGGER.info((Object)"Disabling gRPC plain-text as the SSL certificate is configured");
            config.plainText = false;
        }
        if (config.plainText) {
            options.setSsl(false);
            return true;
        }
        options.setSsl(true);
        SslServerConfig sslConfig = config.ssl;
        Optional<Path> certFile = sslConfig.certificate;
        Optional<Path> keyFile = sslConfig.key;
        Optional<Path> keyStoreFile = sslConfig.keyStore;
        Optional<Path> trustStoreFile = sslConfig.trustStore;
        Optional<String> trustStorePassword = sslConfig.trustStorePassword;
        options.setUseAlpn(config.alpn);
        if (config.alpn) {
            options.setAlpnVersions(Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1));
        }
        if (certFile.isPresent() && keyFile.isPresent()) {
            GrpcSslUtils.createPemKeyCertOptions(certFile.get(), keyFile.get(), options);
        } else if (keyStoreFile.isPresent()) {
            Path keyStorePath = keyStoreFile.get();
            Optional<String> keyStoreFileType = sslConfig.keyStoreType;
            String type = keyStoreFileType.isPresent() ? keyStoreFileType.get().toLowerCase() : GrpcSslUtils.findKeystoreFileType(keyStorePath);
            byte[] data = GrpcSslUtils.getFileContent(keyStorePath);
            switch (type) {
                case "pkcs12": {
                    PfxOptions o = new PfxOptions().setValue(Buffer.buffer((byte[])data));
                    if (sslConfig.keyStorePassword.isPresent()) {
                        o.setPassword(sslConfig.keyStorePassword.get());
                    }
                    options.setPfxKeyCertOptions(o);
                    break;
                }
                case "jks": {
                    PfxOptions o = new JksOptions().setValue(Buffer.buffer((byte[])data));
                    if (sslConfig.keyStorePassword.isPresent()) {
                        o.setPassword(sslConfig.keyStorePassword.get());
                    }
                    options.setKeyStoreOptions((JksOptions)o);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown keystore type: " + type + " valid types are jks or pkcs12");
                }
            }
        }
        if (trustStoreFile.isPresent()) {
            if (trustStorePassword.isEmpty()) {
                throw new IllegalArgumentException("No trust store password provided");
            }
            Optional<String> trustStoreFileType = sslConfig.trustStoreType;
            Path trustStoreFilePath = trustStoreFile.get();
            String type = trustStoreFileType.isPresent() ? trustStoreFileType.get() : GrpcSslUtils.findKeystoreFileType(trustStoreFilePath);
            GrpcSslUtils.createTrustStoreOptions(trustStoreFilePath, trustStorePassword.get(), type, options);
        }
        for (String cipher : sslConfig.cipherSuites.orElse(Collections.emptyList())) {
            options.addEnabledCipherSuite(cipher);
        }
        for (String protocol : sslConfig.protocols) {
            if (protocol.isEmpty()) continue;
            options.addEnabledSecureTransportProtocol(protocol);
        }
        options.setClientAuth(sslConfig.clientAuth);
        return false;
    }

    private static byte[] getFileContent(Path path) throws IOException {
        byte[] data;
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)path));
        if (resource != null) {
            try (InputStream is = resource;){
                data = GrpcSslUtils.doRead(is);
            }
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            data = GrpcSslUtils.doRead(is);
        }
        return data;
    }

    private static void createPemKeyCertOptions(Path certFile, Path keyFile, HttpServerOptions serverOptions) throws IOException {
        byte[] cert = GrpcSslUtils.getFileContent(certFile);
        byte[] key = GrpcSslUtils.getFileContent(keyFile);
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions().setCertValue(Buffer.buffer((byte[])cert)).setKeyValue(Buffer.buffer((byte[])key));
        serverOptions.setPemKeyCertOptions(pemKeyCertOptions);
    }

    private static void createTrustStoreOptions(Path trustStoreFile, String trustStorePassword, String trustStoreFileType, HttpServerOptions serverOptions) throws IOException {
        byte[] data = GrpcSslUtils.getFileContent(trustStoreFile);
        switch (trustStoreFileType) {
            case "pkcs12": {
                PfxOptions options = new PfxOptions().setPassword(trustStorePassword).setValue(Buffer.buffer((byte[])data));
                serverOptions.setPfxTrustOptions(options);
                break;
            }
            case "jks": {
                JksOptions options = new JksOptions().setPassword(trustStorePassword).setValue(Buffer.buffer((byte[])data));
                serverOptions.setTrustStoreOptions(options);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown truststore type: " + trustStoreFileType + " valid types are jks or pkcs12");
            }
        }
    }

    private static String findKeystoreFileType(Path storePath) {
        String pathName = storePath.toString();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return "pkcs12";
        }
        return "jks";
    }

    private static byte[] doRead(InputStream is) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((r = is.read(buf)) > 0) {
            out.write(buf, 0, r);
        }
        return out.toByteArray();
    }

    private GrpcSslUtils() {
    }
}

