/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.override;

import io.grpc.Context;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Vertx;

public class ContextStorageOverride
extends Context.Storage {
    private static final ThreadLocal<Context> fallback = new ThreadLocal();
    private static final String GRPC_CONTEXT = "GRPC_CONTEXT";

    public Context doAttach(Context toAttach) {
        Context current = this.current();
        io.vertx.core.Context dc = Vertx.currentContext();
        if (dc != null && VertxContext.isDuplicatedContext((io.vertx.core.Context)dc)) {
            dc.putLocal((Object)GRPC_CONTEXT, (Object)toAttach);
        } else {
            fallback.set(toAttach);
        }
        return current;
    }

    public void detach(Context context, Context toRestore) {
        io.vertx.core.Context dc = Vertx.currentContext();
        if (toRestore != Context.ROOT) {
            if (dc != null && VertxContext.isDuplicatedContext((io.vertx.core.Context)dc)) {
                dc.putLocal((Object)GRPC_CONTEXT, (Object)toRestore);
            } else {
                fallback.set(toRestore);
            }
        } else if (dc == null || !VertxContext.isDuplicatedContext((io.vertx.core.Context)dc)) {
            fallback.set(null);
        }
    }

    public Context current() {
        if (VertxContext.isOnDuplicatedContext()) {
            Context current = (Context)Vertx.currentContext().getLocal((Object)GRPC_CONTEXT);
            if (current == null) {
                return Context.ROOT;
            }
            return current;
        }
        Context current = fallback.get();
        if (current == null) {
            return Context.ROOT;
        }
        return current;
    }
}

