/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Prioritized;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public final class Interceptors {
    public static final int DUPLICATE_CONTEXT = 0x7FFFFFFA;
    public static final int REQUEST_CONTEXT = 2147483597;
    public static final int BLOCKING_HANDLER = 2147483587;
    public static final int EXCEPTION_HANDLER = 2147483577;
    static final Comparator<Object> INTERCEPTOR_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object i1, Object i2) {
            int p1 = 0;
            int p2 = 0;
            if (i1 instanceof Prioritized) {
                p1 = ((Prioritized)i1).getPriority();
            }
            if (i2 instanceof Prioritized) {
                p2 = ((Prioritized)i2).getPriority();
            }
            if (i1.equals(i2)) {
                return 0;
            }
            return Integer.compare(p1, p2);
        }
    };

    static <T> List<T> getSortedPerServiceInterceptors(String name, Set<Class<?>> interceptorClasses) {
        if (interceptorClasses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> interceptors = new ArrayList<Object>();
        for (Class<?> interceptorClass : interceptorClasses) {
            InstanceHandle interceptorInstance = Arc.container().instance(interceptorClass, new Annotation[]{Any.Literal.INSTANCE});
            Object interceptor = interceptorInstance.get();
            if (interceptor == null) {
                throw new IllegalArgumentException("Interceptor class " + String.valueOf(interceptorClass) + " is not a CDI bean. Only CDI beans can be used as gRPC server/client interceptors. Add one of the scope-defining annotations (@Singleton, @ApplicationScoped, @RequestScoped) on the interceptor class.");
            }
            interceptors.add(interceptor);
        }
        interceptors.sort(INTERCEPTOR_COMPARATOR);
        return interceptors;
    }

    static <T> List<T> getSortedPerServiceInterceptors(Set<Class<?>> interceptorClasses) {
        if (interceptorClasses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> interceptors = new ArrayList<Object>();
        for (Class<?> interceptorClass : interceptorClasses) {
            InstanceHandle interceptorInstance = Arc.container().instance(interceptorClass, new Annotation[]{Any.Literal.INSTANCE});
            Object interceptor = interceptorInstance.get();
            if (interceptor == null) {
                throw new IllegalArgumentException("Interceptor class " + String.valueOf(interceptorClass) + " is not a CDI bean. Only CDI beans can be used as gRPC server/client interceptors. Add one of the scope-defining annotations (@Singleton, @ApplicationScoped, @RequestScoped) on the interceptor class.");
            }
            interceptors.add(interceptor);
        }
        interceptors.sort(INTERCEPTOR_COMPARATOR);
        return interceptors;
    }

    static <T> List<T> getSortedGlobalInterceptors(Set<Class<?>> globalInterceptors) {
        if (globalInterceptors.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> interceptors = new ArrayList<Object>();
        for (Class<?> interceptorClass : globalInterceptors) {
            InstanceHandle interceptorInstance = Arc.container().instance(interceptorClass, new Annotation[]{Any.Literal.INSTANCE});
            Object serverInterceptor = interceptorInstance.get();
            if (serverInterceptor == null) {
                throw new IllegalArgumentException("Interceptor class " + String.valueOf(interceptorClass) + " is not a CDI bean. Only CDI beans can be used as gRPC server/client interceptors. Add one of the scope-defining annotations (@Singleton, @ApplicationScoped, @RequestScoped) on the interceptor class.");
            }
            interceptors.add(serverInterceptor);
        }
        interceptors.sort(INTERCEPTOR_COMPARATOR);
        return interceptors;
    }
}

