/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.auth;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.quarkus.grpc.GlobalInterceptor;
import io.quarkus.grpc.auth.AuthExceptionHandlerProvider;
import io.quarkus.grpc.auth.GrpcSecurityMechanism;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;

@GlobalInterceptor
@Singleton
public final class GrpcSecurityInterceptor
implements ServerInterceptor,
Prioritized {
    private static final Logger log = Logger.getLogger(GrpcSecurityInterceptor.class);
    private final IdentityProviderManager identityProviderManager;
    private final CurrentIdentityAssociation identityAssociation;
    private final AuthExceptionHandlerProvider exceptionHandlerProvider;
    private final List<GrpcSecurityMechanism> securityMechanisms;
    private final Map<String, List<String>> serviceToBlockingMethods = new HashMap<String, List<String>>();
    private boolean hasBlockingMethods = false;

    @Inject
    public GrpcSecurityInterceptor(CurrentIdentityAssociation identityAssociation, IdentityProviderManager identityProviderManager, Instance<GrpcSecurityMechanism> securityMechanisms, Instance<AuthExceptionHandlerProvider> exceptionHandlers) {
        this.identityAssociation = identityAssociation;
        this.identityProviderManager = identityProviderManager;
        AuthExceptionHandlerProvider maxPrioHandlerProvider = null;
        for (AuthExceptionHandlerProvider handler : exceptionHandlers) {
            if (maxPrioHandlerProvider != null && maxPrioHandlerProvider.getPriority() >= handler.getPriority()) continue;
            maxPrioHandlerProvider = handler;
        }
        this.exceptionHandlerProvider = maxPrioHandlerProvider;
        ArrayList<GrpcSecurityMechanism> mechanisms = new ArrayList<GrpcSecurityMechanism>();
        for (GrpcSecurityMechanism securityMechanism : securityMechanisms) {
            mechanisms.add(securityMechanism);
        }
        mechanisms.sort(Comparator.comparing(GrpcSecurityMechanism::getPriority));
        this.securityMechanisms = mechanisms;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        Exception error = null;
        for (GrpcSecurityMechanism securityMechanism : this.securityMechanisms) {
            if (!securityMechanism.handles(metadata)) continue;
            try {
                List<String> methods;
                AuthenticationRequest authenticationRequest = securityMechanism.createAuthenticationRequest(metadata);
                final Context context = Vertx.currentContext();
                final boolean onEventLoopThread = Context.isOnEventLoopThread();
                final boolean isBlockingMethod = this.hasBlockingMethods ? ((methods = this.serviceToBlockingMethods.get(serverCall.getMethodDescriptor().getServiceName())) != null ? methods.contains(serverCall.getMethodDescriptor().getFullMethodName()) : false) : false;
                if (authenticationRequest == null) continue;
                Uni auth = this.identityProviderManager.authenticate(authenticationRequest).emitOn(new Executor(){

                    @Override
                    public void execute(final Runnable command) {
                        if (onEventLoopThread && !isBlockingMethod) {
                            context.runOnContext((Handler)new Handler<Void>(){

                                public void handle(Void event) {
                                    command.run();
                                }
                            });
                        } else {
                            command.run();
                        }
                    }
                });
                this.identityAssociation.setIdentity(auth);
                error = null;
                break;
            }
            catch (Exception e) {
                error = e;
                log.warn((Object)"Failed to prepare AuthenticationRequest for a gRPC call", (Throwable)e);
            }
        }
        if (error != null) {
            this.identityAssociation.setIdentity(Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Failed to parse authentication data", error)));
        }
        ServerCall.Listener listener = serverCallHandler.startCall(serverCall, metadata);
        return this.exceptionHandlerProvider.createHandler(listener, serverCall, metadata);
    }

    public int getPriority() {
        return 2147483547;
    }

    void init(Map<String, List<String>> serviceToBlockingMethods) {
        this.serviceToBlockingMethods.putAll(serviceToBlockingMethods);
        this.hasBlockingMethods = true;
    }
}

