/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.context;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.StatusException;
import io.quarkus.grpc.ExceptionHandlerProvider;
import io.quarkus.grpc.GlobalInterceptor;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@ApplicationScoped
@GlobalInterceptor
public class GrpcDuplicatedContextGrpcInterceptor
implements ServerInterceptor,
Prioritized {
    private static final Logger log = Logger.getLogger((String)GrpcDuplicatedContextGrpcInterceptor.class.getName());
    @Inject
    ExceptionHandlerProvider ehp;

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context capturedVertxContext = Vertx.currentContext();
        if (capturedVertxContext != null) {
            Context local = VertxContext.getOrCreateDuplicatedContext((Context)capturedVertxContext);
            VertxContextSafetyToggle.setContextSafe((Context)local, (boolean)true);
            return new ListenedOnDuplicatedContext<ReqT, RespT>(this.ehp, call, () -> next.startCall(call, headers), local);
        }
        log.warn((Object)"Unable to run on a duplicated context - interceptor not called on the Vert.x event loop");
        return next.startCall(call, headers);
    }

    public int getPriority() {
        return 0x7FFFFFFA;
    }

    static class ListenedOnDuplicatedContext<ReqT, RespT>
    extends ServerCall.Listener<ReqT> {
        private final Context context;
        private final Supplier<ServerCall.Listener<ReqT>> supplier;
        private final ExceptionHandlerProvider ehp;
        private final ServerCall<ReqT, RespT> call;
        private ServerCall.Listener<ReqT> delegate;
        private final AtomicBoolean closed = new AtomicBoolean();

        public ListenedOnDuplicatedContext(ExceptionHandlerProvider ehp, ServerCall<ReqT, RespT> call, Supplier<ServerCall.Listener<ReqT>> supplier, Context context) {
            this.ehp = ehp;
            this.context = context;
            this.supplier = supplier;
            this.call = call;
        }

        private synchronized ServerCall.Listener<ReqT> getDelegate() {
            if (this.delegate == null) {
                try {
                    this.delegate = this.supplier.get();
                }
                catch (Throwable t) {
                    log.warn((Object)"Unable to retrieve gRPC Server call listener, see the cause below.");
                    this.close(t);
                    return null;
                }
            }
            return this.delegate;
        }

        private void close(Throwable t) {
            if (this.closed.compareAndSet(false, true) && this.call.isReady()) {
                Throwable nt = this.ehp.transform(t);
                StatusException sre = (StatusException)ExceptionHandlerProvider.toStatusException((Throwable)nt, (boolean)false);
                Optional metadata = ExceptionHandlerProvider.toTrailers((Throwable)nt);
                log.warn((Object)"Closing gRPC call due to an error ...", t);
                this.call.close(sre.getStatus(), metadata.orElse(new Metadata()));
            }
        }

        private void invoke(Consumer<ServerCall.Listener<ReqT>> invocation) {
            if (Vertx.currentContext() == this.context) {
                ServerCall.Listener<ReqT> listener = this.getDelegate();
                if (listener == null) {
                    return;
                }
                try {
                    invocation.accept(listener);
                }
                catch (Throwable t) {
                    this.close(t);
                }
            } else {
                this.context.runOnContext(v -> {
                    ServerCall.Listener<ReqT> listener = this.getDelegate();
                    if (listener == null) {
                        return;
                    }
                    try {
                        invocation.accept(listener);
                    }
                    catch (Throwable t) {
                        this.close(t);
                    }
                });
            }
        }

        public void onMessage(ReqT message) {
            this.invoke(listener -> listener.onMessage(message));
        }

        public void onReady() {
            this.invoke(ServerCall.Listener::onReady);
        }

        public void onHalfClose() {
            this.invoke(ServerCall.Listener::onHalfClose);
        }

        public void onCancel() {
            this.invoke(ServerCall.Listener::onCancel);
        }

        public void onComplete() {
            this.invoke(ServerCall.Listener::onComplete);
        }
    }
}

