/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.devui;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.StreamObserver;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.devmode.GrpcServices;
import io.quarkus.vertx.http.runtime.CertificateConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;

public class GrpcJsonRPCService {
    private static final Logger LOG = Logger.getLogger(GrpcJsonRPCService.class);
    private Map<String, GrpcServiceClassInfo> grpcServiceClassInfos;
    private Map<String, StreamObserver<Message>> callsInProgress;
    @Inject
    VertxHttpConfig httpConfig;
    @Inject
    GrpcConfiguration grpcConfiguration;
    @Inject
    GrpcServices grpcServices;
    private String host;
    private int port;
    private boolean ssl;

    @PostConstruct
    public void init() {
        GrpcServerConfiguration serverConfig = this.grpcConfiguration.server();
        if (serverConfig.useSeparateServer()) {
            this.host = serverConfig.host();
            this.port = serverConfig.port();
            this.ssl = serverConfig.ssl().certificate().isPresent() || serverConfig.ssl().keyStore().isPresent();
        } else {
            this.host = this.httpConfig.host();
            this.port = this.httpConfig.port();
            this.ssl = this.isTLSConfigured(this.httpConfig.ssl().certificate());
        }
        this.grpcServiceClassInfos = this.getGrpcServiceClassInfos();
        this.callsInProgress = new HashMap<String, StreamObserver<Message>>();
    }

    private boolean isTLSConfigured(CertificateConfig certificate) {
        return certificate.files().isPresent() || certificate.keyFiles().isPresent() || certificate.keyStoreFile().isPresent();
    }

    public JsonArray getServices() {
        JsonArray services = new JsonArray();
        List<GrpcServices.ServiceDefinitionAndStatus> infos = this.grpcServices.getInfos();
        for (GrpcServices.ServiceDefinitionAndStatus info : infos) {
            JsonObject service = new JsonObject();
            service.put("status", (Object)info.status);
            service.put("name", (Object)info.getName());
            service.put("serviceClass", (Object)info.getServiceClass());
            service.put("hasTestableMethod", (Object)info.hasTestableMethod());
            JsonArray methods = new JsonArray();
            for (GrpcServices.MethodAndPrototype methodAndPrototype : info.getMethodsWithPrototypes()) {
                JsonObject method = new JsonObject();
                method.put("bareMethodName", (Object)methodAndPrototype.getBareMethodName());
                method.put("type", (Object)methodAndPrototype.getType());
                method.put("prototype", (Object)methodAndPrototype.getPrototype());
                method.put("isTestable", (Object)methodAndPrototype.isTestable());
                methods.add((Object)method);
            }
            service.put("methods", (Object)methods);
            services.add((Object)service);
        }
        return services;
    }

    public Uni<String> testService(String id, String serviceName, String methodName, String content) {
        try {
            return this.streamService(id, serviceName, methodName, false, content).toUni();
        }
        catch (Throwable t) {
            return Uni.createFrom().item((Object)this.error(t.getMessage()).encodePrettily());
        }
    }

    public Multi<String> streamService(String id, String serviceName, String methodName, boolean isRunning, String content) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InvalidProtocolBufferException {
        if (content == null) {
            return Multi.createFrom().item((Object)this.error("Invalid message").encodePrettily());
        }
        BroadcastProcessor streamEvent = BroadcastProcessor.create();
        GrpcServiceClassInfo info = this.grpcServiceClassInfos.get(serviceName);
        ManagedChannel channel = this.getChannel(this.host, this.port);
        Object grpcStub = this.createStub(info.grpcServiceClass, (Channel)channel);
        ServiceDescriptor serviceDescriptor = info.serviceDescriptor;
        MethodDescriptor methodDescriptor = this.getMethodDescriptor(serviceDescriptor, methodName);
        MethodDescriptor.Marshaller requestMarshaller = methodDescriptor.getRequestMarshaller();
        MethodDescriptor.PrototypeMarshaller protoMarshaller = (MethodDescriptor.PrototypeMarshaller)requestMarshaller;
        Class<?> requestType = protoMarshaller.getMessagePrototype().getClass();
        Message message = GrpcJsonRPCService.createMessage(content, requestType);
        if (isRunning) {
            this.callsInProgress.get(id).onNext((Object)message);
        } else {
            TestObserver responseObserver = new TestObserver((BroadcastProcessor<String>)streamEvent);
            Method stubMethod = this.getStubMethod(grpcStub, methodDescriptor.getBareMethodName());
            if (stubMethod.getParameterCount() == 1 && stubMethod.getReturnType() == StreamObserver.class) {
                StreamObserver incomingStream = (StreamObserver)stubMethod.invoke(grpcStub, responseObserver);
                this.callsInProgress.put(id, (StreamObserver<Message>)incomingStream);
                incomingStream.onNext((Object)message);
            } else {
                stubMethod.invoke(grpcStub, message, responseObserver);
            }
        }
        channel.shutdown();
        return streamEvent;
    }

    private static Message createMessage(String content, Class<?> requestType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InvalidProtocolBufferException {
        Method newBuilderMethod = requestType.getDeclaredMethod("newBuilder", new Class[0]);
        Message.Builder builder = (Message.Builder)newBuilderMethod.invoke(null, new Object[0]);
        JsonFormat.parser().merge(content, builder);
        return builder.build();
    }

    public Uni<Void> disconnectService(String id) {
        this.callsInProgress.get(id).onCompleted();
        this.callsInProgress.remove(id);
        return Uni.createFrom().voidItem();
    }

    private Map<String, GrpcServiceClassInfo> getGrpcServiceClassInfos() {
        Set serviceClassNames = (Set)DevConsoleManager.getGlobal((String)"io.quarkus.grpc.serviceClassNames");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        HashMap<String, GrpcServiceClassInfo> m = new HashMap<String, GrpcServiceClassInfo>();
        for (String className : serviceClassNames) {
            try {
                Class<?> grpcServiceClass = tccl.loadClass(className);
                ServiceDescriptor serviceDescriptor = this.createServiceDescriptor(grpcServiceClass);
                GrpcServiceClassInfo s = new GrpcServiceClassInfo(serviceDescriptor, grpcServiceClass);
                m.put(serviceDescriptor.getName(), s);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        return m;
    }

    private ServiceDescriptor createServiceDescriptor(Class<?> grpcServiceClass) {
        try {
            Method method = grpcServiceClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
            return (ServiceDescriptor)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.warnf("Could not create stub for %s - " + e.getMessage(), grpcServiceClass);
            return null;
        }
    }

    private JsonObject error(String message) {
        LOG.error((Object)message);
        JsonObject error = new JsonObject();
        error.put("status", (Object)"ERROR");
        error.put("message", (Object)message);
        return error;
    }

    private Method getStubMethod(Object grpcStub, String bareMethodName) {
        String realMethodName = this.decapitalize(bareMethodName);
        for (Method method : grpcStub.getClass().getDeclaredMethods()) {
            if (!method.getName().equals(realMethodName)) continue;
            return method;
        }
        return null;
    }

    private String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private MethodDescriptor getMethodDescriptor(ServiceDescriptor serviceDescriptor, String methodName) {
        for (MethodDescriptor method : serviceDescriptor.getMethods()) {
            if (method.getBareMethodName() == null || !method.getBareMethodName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    private Object createStub(Class<?> grpcServiceClass, Channel channel) {
        try {
            Method stubFactoryMethod = grpcServiceClass.getDeclaredMethod("newStub", Channel.class);
            return stubFactoryMethod.invoke(null, channel);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warnf("Could not create stub for %s - " + e.getMessage(), grpcServiceClass);
            return null;
        }
    }

    private ManagedChannel getChannel(String host, int port) {
        return NettyChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
    }

    public static final class GrpcServiceClassInfo {
        public ServiceDescriptor serviceDescriptor;
        public Class<?> grpcServiceClass;

        public GrpcServiceClassInfo(ServiceDescriptor serviceDescriptor, Class<?> grpcServiceClass) {
            this.serviceDescriptor = serviceDescriptor;
            this.grpcServiceClass = grpcServiceClass;
        }
    }

    private class TestObserver<Object>
    implements StreamObserver<Object> {
        private BroadcastProcessor<String> broadcaster;

        public TestObserver(BroadcastProcessor<String> broadcaster) {
            this.broadcaster = broadcaster;
        }

        public void onNext(Object value) {
            try {
                String body = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)value);
                this.broadcaster.onNext((Object)body);
            }
            catch (InvalidProtocolBufferException e) {
                this.broadcaster.onError((Throwable)e);
            }
        }

        public void onError(Throwable t) {
            this.broadcaster.onError(t);
        }

        public void onCompleted() {
            this.broadcaster.onComplete();
        }
    }
}

