/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.auth;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.quarkus.grpc.ExceptionHandler;
import io.quarkus.grpc.auth.DefaultAuthExceptionHandlerProvider;
import io.quarkus.security.AuthenticationException;
import jakarta.enterprise.inject.spi.Prioritized;

public class AuthExceptionHandler<ReqT, RespT>
extends ExceptionHandler<ReqT, RespT>
implements Prioritized {
    private final boolean addStatusDescription;

    public AuthExceptionHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> serverCall, Metadata metadata, boolean addStatusDescription) {
        super(listener, serverCall, metadata);
        this.addStatusDescription = addStatusDescription;
    }

    public AuthExceptionHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
        this(listener, serverCall, metadata, false);
    }

    protected void handleException(Throwable exception, ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
        if (!(exception instanceof AuthenticationException) && !(exception instanceof SecurityException)) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
        serverCall.close(DefaultAuthExceptionHandlerProvider.transformToStatusException(this.addStatusDescription, exception), metadata);
    }

    public int getPriority() {
        return 0;
    }
}

