/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.quarkus.hal.HalCollectionWrapper;
import io.quarkus.hal.HalEntityWrapper;
import java.io.IOException;

public class HalCollectionWrapperJacksonSerializer
extends JsonSerializer<HalCollectionWrapper> {
    public void serialize(HalCollectionWrapper wrapper, JsonGenerator generator, SerializerProvider serializers) throws IOException {
        generator.writeStartObject();
        this.writeEmbedded(wrapper, generator, serializers);
        this.writeLinks(wrapper, generator);
        generator.writeEndObject();
    }

    private void writeEmbedded(HalCollectionWrapper wrapper, JsonGenerator generator, SerializerProvider serializers) throws IOException {
        JsonSerializer entitySerializer = serializers.findValueSerializer(HalEntityWrapper.class);
        generator.writeFieldName("_embedded");
        generator.writeStartObject();
        generator.writeFieldName(wrapper.getCollectionName());
        generator.writeStartArray();
        for (HalEntityWrapper entity : wrapper.getCollection()) {
            entitySerializer.serialize((Object)entity, generator, serializers);
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    private void writeLinks(HalCollectionWrapper wrapper, JsonGenerator generator) throws IOException {
        generator.writeFieldName("_links");
        generator.writeObject(wrapper.getLinks());
    }
}

