/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.envers.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfig;
import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.envers.HibernateEnversRecorder;
import io.quarkus.hibernate.envers.deployment.HibernateEnversEnabled;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.List;
import java.util.Map;
import java.util.Set;

@BuildSteps(onlyIfNot={HibernateEnversEnabled.class})
public final class HibernateEnversDisabledProcessor {
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void disableHibernateEnversStaticInit(HibernateEnversRecorder recorder, HibernateEnversBuildTimeConfig buildTimeConfig, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> integrationProducer) {
        this.checkNoExplicitActiveTrue(buildTimeConfig);
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            integrationProducer.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem("Hibernate Envers", puDescriptor.getPersistenceUnitName()).setInitListener(recorder.createStaticInitInactiveListener()).setXmlMappingRequired(false));
        }
    }

    public void checkNoExplicitActiveTrue(HibernateEnversBuildTimeConfig buildTimeConfig) {
        for (Map.Entry entry : buildTimeConfig.getAllPersistenceUnitConfigsAsMap().entrySet()) {
            HibernateEnversBuildTimeConfigPersistenceUnit config = (HibernateEnversBuildTimeConfigPersistenceUnit)entry.getValue();
            if (!config.active.isPresent() || !((Boolean)config.active.get()).booleanValue()) continue;
            String puName = (String)entry.getKey();
            String enabledPropertyKey = HibernateEnversBuildTimeConfig.extensionPropertyKey((String)"enabled");
            String activePropertyKey = HibernateEnversBuildTimeConfig.persistenceUnitPropertyKey((String)puName, (String)"active");
            throw new ConfigurationException("Hibernate Envers activated explicitly for persistence unit '" + puName + "', but the Hibernate Envers extension was disabled at build time. If you want Hibernate Envers to be active for this persistence unit, you must set '" + enabledPropertyKey + "' to 'true' at build time. If you don't want Hibernate Envers to be active for this persistence unit, you must leave '" + activePropertyKey + "' unset or set it to 'false'.", Set.of(enabledPropertyKey, activePropertyKey));
        }
    }
}

