/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.envers.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfig;
import io.quarkus.hibernate.envers.HibernateEnversRecorder;
import io.quarkus.hibernate.envers.deployment.HibernateEnversEnabled;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import java.util.Arrays;
import java.util.List;

@BuildSteps(onlyIf={HibernateEnversEnabled.class})
public final class HibernateEnversProcessor {
    static final String HIBERNATE_ENVERS = "Hibernate Envers";

    @BuildStep
    List<AdditionalJpaModelBuildItem> addJpaModelClasses() {
        return Arrays.asList(new AdditionalJpaModelBuildItem("org.hibernate.envers.DefaultRevisionEntity"), new AdditionalJpaModelBuildItem("org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity"));
    }

    @BuildStep
    public void registerEnversReflections(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, HibernateEnversBuildTimeConfig buildTimeConfig) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.hibernate.envers.DefaultRevisionEntity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.hibernate.envers.DefaultTrackingModifiedEntitiesRevisionEntity"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.hibernate.tuple.entity.DynamicMapEntityTuplizer"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{"org.hibernate.tuple.component.DynamicMapComponentTuplizer"}));
        buildTimeConfig.revisionListener.ifPresent(s -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{s})));
        buildTimeConfig.auditStrategy.ifPresent(s -> reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{s})));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void applyStaticConfig(HibernateEnversRecorder recorder, HibernateEnversBuildTimeConfig buildTimeConfig, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> integrationProducer) {
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            String puName = puDescriptor.getPersistenceUnitName();
            integrationProducer.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(HIBERNATE_ENVERS, puName).setInitListener(recorder.createStaticInitListener(buildTimeConfig, puName)).setXmlMappingRequired(true));
        }
    }
}

