/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.envers;

import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public class HibernateEnversBuildTimeConfig {
    @ConfigItem(defaultValue="true")
    public boolean enabled;
    @ConfigItem(name="<<parent>>")
    public HibernateEnversBuildTimeConfigPersistenceUnit defaultPersistenceUnit;
    @ConfigItem(name="<<parent>>")
    public Map<String, HibernateEnversBuildTimeConfigPersistenceUnit> persistenceUnits;
    @ConfigItem(defaultValue="false")
    public boolean storeDataAtDelete;
    @ConfigItem(defaultValue="_AUD")
    public Optional<String> auditTableSuffix;
    @ConfigItem(defaultValue="")
    public Optional<String> auditTablePrefix;
    @ConfigItem(defaultValue="REV")
    public Optional<String> revisionFieldName;
    @ConfigItem(defaultValue="REVTYPE")
    public Optional<String> revisionTypeFieldName;
    @ConfigItem(defaultValue="true")
    public boolean revisionOnCollectionChange;
    @ConfigItem(defaultValue="true")
    public boolean doNotAuditOptimisticLockingField;
    @ConfigItem(defaultValue="")
    public Optional<String> defaultSchema;
    @ConfigItem(defaultValue="")
    public Optional<String> defaultCatalog;
    @ConfigItem(defaultValue="false")
    public boolean trackEntitiesChangedInRevision;
    @ConfigItem(defaultValue="true")
    public boolean useRevisionEntityWithNativeId;
    @ConfigItem(defaultValue="false")
    public boolean globalWithModifiedFlag;
    @ConfigItem(defaultValue="_MOD")
    public Optional<String> modifiedFlagSuffix;
    @ConfigItem
    public Optional<String> revisionListener;
    @ConfigItem(defaultValue="org.hibernate.envers.strategy.DefaultAuditStrategy")
    public Optional<String> auditStrategy;
    @ConfigItem(defaultValue="originalId")
    public Optional<String> originalIdPropName;
    @ConfigItem(defaultValue="REVEND")
    public Optional<String> auditStrategyValidityEndRevFieldName;
    @ConfigItem(defaultValue="false")
    public boolean auditStrategyValidityStoreRevendTimestamp;
    @ConfigItem(defaultValue="REVEND_TSTMP")
    public Optional<String> auditStrategyValidityRevendTimestampFieldName;
    @ConfigItem(defaultValue="SETORDINAL")
    public Optional<String> embeddableSetOrdinalFieldName;
    @ConfigItem(defaultValue="false")
    public boolean allowIdentifierReuse;
    @ConfigItem(defaultValue="org.hibernate.envers.boot.internal.LegacyModifiedColumnNamingStrategy")
    public Optional<String> modifiedColumnNamingStrategy;

    public Map<String, HibernateEnversBuildTimeConfigPersistenceUnit> getAllPersistenceUnitConfigsAsMap() {
        TreeMap<String, HibernateEnversBuildTimeConfigPersistenceUnit> map = new TreeMap<String, HibernateEnversBuildTimeConfigPersistenceUnit>();
        if (this.defaultPersistenceUnit != null) {
            map.put("<default>", this.defaultPersistenceUnit);
        }
        map.putAll(this.persistenceUnits);
        return map;
    }

    public static String extensionPropertyKey(String radical) {
        return "quarkus.hibernate-envers." + radical;
    }

    public static String persistenceUnitPropertyKey(String persistenceUnitName, String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-envers.");
        if (!PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
            keyBuilder.append("\"").append(persistenceUnitName).append("\".");
        }
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }
}

