/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.envers;

import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfig;
import io.quarkus.hibernate.envers.HibernateEnversBuildTimeConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticInitListener;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;

@Recorder
public class HibernateEnversRecorder {
    public HibernateOrmIntegrationStaticInitListener createStaticInitListener(HibernateEnversBuildTimeConfig buildTimeConfig, String puName) {
        return new HibernateEnversIntegrationStaticInitListener(buildTimeConfig, puName);
    }

    public HibernateOrmIntegrationStaticInitListener createStaticInitInactiveListener() {
        return new HibernateEnversIntegrationStaticInitInactiveListener();
    }

    private static final class HibernateEnversIntegrationStaticInitInactiveListener
    implements HibernateOrmIntegrationStaticInitListener {
        private HibernateEnversIntegrationStaticInitInactiveListener() {
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            propertyCollector.accept("hibernate.integration.envers.enabled", "false");
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
        }
    }

    private static final class HibernateEnversIntegrationStaticInitListener
    implements HibernateOrmIntegrationStaticInitListener {
        private final HibernateEnversBuildTimeConfig buildTimeConfig;
        private final String puName;

        private HibernateEnversIntegrationStaticInitListener(HibernateEnversBuildTimeConfig buildTimeConfig, String puName) {
            this.buildTimeConfig = buildTimeConfig;
            this.puName = puName;
        }

        public void contributeBootProperties(BiConsumer<String, Object> propertyCollector) {
            HibernateEnversBuildTimeConfigPersistenceUnit puConfig = this.buildTimeConfig.getAllPersistenceUnitConfigsAsMap().get(this.puName);
            if (puConfig != null && puConfig.active.isPresent() && !puConfig.active.get().booleanValue()) {
                propertyCollector.accept("hibernate.integration.envers.enabled", "false");
                return;
            }
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.store_data_at_delete", this.buildTimeConfig.storeDataAtDelete);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.audit_table_suffix", this.buildTimeConfig.auditTableSuffix);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.audit_table_prefix", this.buildTimeConfig.auditTablePrefix);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.revision_field_name", this.buildTimeConfig.revisionFieldName);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.revision_type_field_name", this.buildTimeConfig.revisionTypeFieldName);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.revision_on_collection_change", this.buildTimeConfig.revisionOnCollectionChange);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.do_not_audit_optimistic_locking_field", this.buildTimeConfig.doNotAuditOptimisticLockingField);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.default_schema", this.buildTimeConfig.defaultSchema);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.default_catalog", this.buildTimeConfig.defaultCatalog);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.track_entities_changed_in_revision", this.buildTimeConfig.trackEntitiesChangedInRevision);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.use_revision_entity_with_native_id", this.buildTimeConfig.useRevisionEntityWithNativeId);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.global_with_modified_flag", this.buildTimeConfig.globalWithModifiedFlag);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.modified_flag_suffix", this.buildTimeConfig.modifiedFlagSuffix);
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.revision_listener", this.buildTimeConfig.revisionListener);
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.audit_strategy", this.buildTimeConfig.auditStrategy);
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.original_id_prop_name", this.buildTimeConfig.originalIdPropName);
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.audit_strategy_validity_end_rev_field_name", this.buildTimeConfig.auditStrategyValidityEndRevFieldName);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.audit_strategy_validity_store_revend_timestamp", this.buildTimeConfig.auditStrategyValidityStoreRevendTimestamp);
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.audit_strategy_validity_revend_timestamp_field_name", this.buildTimeConfig.auditStrategyValidityRevendTimestampFieldName);
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.embeddable_set_ordinal_field_name", this.buildTimeConfig.embeddableSetOrdinalFieldName);
            HibernateEnversIntegrationStaticInitListener.addConfig(propertyCollector, "org.hibernate.envers.allow_identifier_reuse", this.buildTimeConfig.allowIdentifierReuse);
            HibernateEnversIntegrationStaticInitListener.addConfigIfPresent(propertyCollector, "org.hibernate.envers.modified_column_naming_strategy", this.buildTimeConfig.modifiedColumnNamingStrategy);
        }

        public static <T> void addConfig(BiConsumer<String, Object> propertyCollector, String configPath, T value) {
            propertyCollector.accept(configPath, value);
        }

        public static <T> void addConfig(BiConsumer<String, Object> propertyCollector, String configPath, Optional<T> value) {
            if (value.isPresent()) {
                propertyCollector.accept(configPath, value.get());
            } else {
                propertyCollector.accept(configPath, "");
            }
        }

        public static <T> void addConfigIfPresent(BiConsumer<String, Object> propertyCollector, String configPath, Optional<T> value) {
            value.ifPresent(t -> propertyCollector.accept(configPath, t));
        }

        public void onMetadataInitialized(Metadata metadata, BootstrapContext bootstrapContext, BiConsumer<String, Object> propertyCollector) {
        }
    }
}

