/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.hibernate.orm.deployment.JpaEntitiesBuildItem;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;

final class JpaJandexScavenger {
    private static final DotName JPA_ENTITY = DotName.createSimple((String)Entity.class.getName());
    private static final DotName EMBEDDABLE = DotName.createSimple((String)Embeddable.class.getName());
    private static final DotName EMBEDDED = DotName.createSimple((String)Embedded.class.getName());
    private static final DotName MAPPED_SUPERCLASS = DotName.createSimple((String)MappedSuperclass.class.getName());
    private static final DotName ENUM = DotName.createSimple((String)Enum.class.getName());
    private final List<ParsedPersistenceXmlDescriptor> explicitDescriptors;
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    private final IndexView indexView;
    private final Set<String> nonJpaModelClasses;

    JpaJandexScavenger(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<ParsedPersistenceXmlDescriptor> explicitDescriptors, IndexView indexView, Set<String> nonJpaModelClasses) {
        this.reflectiveClass = reflectiveClass;
        this.explicitDescriptors = explicitDescriptors;
        this.indexView = indexView;
        this.nonJpaModelClasses = nonJpaModelClasses;
    }

    public JpaEntitiesBuildItem discoverModelAndRegisterForReflection() throws IOException {
        JpaEntitiesBuildItem domainObjectCollector = new JpaEntitiesBuildItem();
        HashSet<String> enumTypeCollector = new HashSet<String>();
        TreeSet<DotName> unindexedClasses = new TreeSet<DotName>();
        this.enlistJPAModelClasses(this.indexView, domainObjectCollector, enumTypeCollector, JPA_ENTITY, unindexedClasses);
        this.enlistJPAModelClasses(this.indexView, domainObjectCollector, enumTypeCollector, EMBEDDABLE, unindexedClasses);
        this.enlistJPAModelClasses(this.indexView, domainObjectCollector, enumTypeCollector, MAPPED_SUPERCLASS, unindexedClasses);
        JpaJandexScavenger.enlistReturnType(this.indexView, domainObjectCollector, enumTypeCollector, unindexedClasses);
        for (PersistenceUnitDescriptor persistenceUnitDescriptor : this.explicitDescriptors) {
            JpaJandexScavenger.enlistExplicitClasses(this.indexView, domainObjectCollector, enumTypeCollector, persistenceUnitDescriptor.getManagedClassNames(), unindexedClasses);
        }
        domainObjectCollector.registerAllForReflection(this.reflectiveClass);
        if (!enumTypeCollector.isEmpty()) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{Enum.class.getName()}));
            for (String string : enumTypeCollector) {
                this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{string}));
            }
        }
        if (!unindexedClasses.isEmpty()) {
            String unindexedClassesErrorMessage = unindexedClasses.stream().map(d -> "\t- " + d + "\n").collect(Collectors.joining());
            throw new ConfigurationError("Unable to properly register the hierarchy of the following JPA classes as they are not in the Jandex index:\n" + unindexedClassesErrorMessage + "Consider adding them to the index either by creating a Jandex index for your dependency via the Maven plugin, an empty META-INF/beans.xml or quarkus.index-dependency properties.");
        }
        return domainObjectCollector;
    }

    private static void enlistExplicitClasses(IndexView index, JpaEntitiesBuildItem domainObjectCollector, Set<String> enumTypeCollector, List<String> managedClassNames, Set<DotName> unindexedClasses) {
        for (String className : managedClassNames) {
            boolean isInIndex;
            DotName dotName = DotName.createSimple((String)className);
            boolean bl = isInIndex = index.getClassByName(dotName) != null;
            if (!isInIndex) {
                unindexedClasses.add(dotName);
            }
            JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, dotName, unindexedClasses);
        }
    }

    private static void enlistReturnType(IndexView index, JpaEntitiesBuildItem domainObjectCollector, Set<String> enumTypeCollector, Set<DotName> unindexedClasses) {
        Collection annotations = index.getAnnotations(EMBEDDED);
        if (annotations == null) {
            return;
        }
        for (AnnotationInstance annotation : annotations) {
            DotName jpaClassName;
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case FIELD: {
                    jpaClassName = target.asField().type().name();
                    break;
                }
                case METHOD: {
                    jpaClassName = target.asMethod().returnType().name();
                    break;
                }
                default: {
                    throw new IllegalStateException("[internal error] @Embedded placed on a unknown element: " + target);
                }
            }
            JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, jpaClassName, unindexedClasses);
        }
    }

    private void enlistJPAModelClasses(IndexView index, JpaEntitiesBuildItem domainObjectCollector, Set<String> enumTypeCollector, DotName dotName, Set<DotName> unindexedClasses) {
        Collection jpaAnnotations = index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            ClassInfo klass = annotation.target().asClass();
            DotName targetDotName = klass.name();
            if (this.nonJpaModelClasses.contains(targetDotName.toString())) continue;
            JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, targetDotName, unindexedClasses);
            JpaJandexScavenger.collectDomainObject(domainObjectCollector, klass);
        }
    }

    private static void addClassHierarchyToReflectiveList(IndexView index, JpaEntitiesBuildItem domainObjectCollector, Set<String> enumTypeCollector, DotName className, Set<DotName> unindexedClasses) {
        if (className == null || className.toString().startsWith("java.")) {
            return;
        }
        ClassInfo classInfo = index.getClassByName(className);
        if (classInfo == null) {
            unindexedClasses.add(className);
            return;
        }
        for (FieldInfo fieldInfo : classInfo.fields()) {
            DotName fieldType = fieldInfo.type().name();
            ClassInfo fieldTypeClassInfo = index.getClassByName(fieldType);
            if (fieldTypeClassInfo == null || !ENUM.equals((Object)fieldTypeClassInfo.superName())) continue;
            enumTypeCollector.add(fieldType.toString());
        }
        JpaJandexScavenger.collectDomainObject(domainObjectCollector, classInfo);
        JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, classInfo.superName(), unindexedClasses);
        for (DotName interfaceDotName : classInfo.interfaceNames()) {
            JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, interfaceDotName, unindexedClasses);
        }
    }

    private static void collectDomainObject(JpaEntitiesBuildItem domainObjectCollector, ClassInfo modelClass) {
        if (modelClass.classAnnotation(JPA_ENTITY) != null) {
            domainObjectCollector.addEntityClass(modelClass.name().toString());
        } else {
            domainObjectCollector.addModelClass(modelClass.name().toString());
        }
    }
}

