/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.agroal.deployment.DataSourceDriverBuildItem;
import io.quarkus.agroal.deployment.DataSourceInitializedBuildItem;
import io.quarkus.agroal.deployment.DataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.ResourceAnnotationBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateConfigUtil;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEntityEnhancer;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.IgnorableNonIndexedClasses;
import io.quarkus.hibernate.orm.deployment.JpaEntitiesBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaJandexScavenger;
import io.quarkus.hibernate.orm.deployment.NonJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.runtime.DefaultEntityManagerFactoryProducer;
import io.quarkus.hibernate.orm.runtime.DefaultEntityManagerProducer;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.JPAResourceReferenceProvider;
import io.quarkus.hibernate.orm.runtime.RequestScopedEntityManagerHolder;
import io.quarkus.hibernate.orm.runtime.TransactionEntityManagers;
import io.quarkus.hibernate.orm.runtime.boot.scan.QuarkusScanner;
import io.quarkus.hibernate.orm.runtime.dialect.QuarkusH2Dialect;
import io.quarkus.hibernate.orm.runtime.dialect.QuarkusPostgreSQL95Dialect;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.enterprise.inject.Produces;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.dialect.DerbyTenSevenDialect;
import org.hibernate.dialect.MariaDB103Dialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.tool.hbm2ddl.MultipleLinesSqlCommandExtractor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public final class HibernateOrmProcessor {
    private static final String HIBERNATE_ORM_CONFIG_PREFIX = "quarkus.hibernate-orm.";
    private static final String NO_SQL_LOAD_SCRIPT_FILE = "no-file";
    private static final DotName PERSISTENCE_CONTEXT = DotName.createSimple((String)PersistenceContext.class.getName());
    private static final DotName PERSISTENCE_UNIT = DotName.createSimple((String)PersistenceUnit.class.getName());
    private static final DotName PRODUCES = DotName.createSimple((String)Produces.class.getName());
    HibernateOrmConfig hibernateConfig;

    @BuildStep
    public SystemPropertyBuildItem enforceDisableRuntimeEnhancer() {
        return new SystemPropertyBuildItem("hibernate.bytecode.provider", "none");
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles(LaunchModeBuildItem launchMode) {
        ArrayList<HotDeploymentWatchedFileBuildItem> watchedFiles = new ArrayList<HotDeploymentWatchedFileBuildItem>();
        watchedFiles.add(new HotDeploymentWatchedFileBuildItem("META-INF/persistence.xml"));
        this.getSqlLoadScript(launchMode.getLaunchMode()).ifPresent(script -> watchedFiles.add(new HotDeploymentWatchedFileBuildItem(script)));
        return watchedFiles;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateOrmRecorder recorder, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, List<NonJpaModelBuildItem> nonJpaModelBuildItems, List<IgnorableNonIndexedClasses> ignorableNonIndexedClassesBuildItems, CombinedIndexBuildItem index, ArchiveRootBuildItem archiveRoot, ApplicationArchivesBuildItem applicationArchivesBuildItem, Optional<DataSourceDriverBuildItem> driverBuildItem, BuildProducer<FeatureBuildItem> feature, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorProducer, BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<SystemPropertyBuildItem> systemPropertyProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<JpaEntitiesBuildItem> domainObjectsProducer, BuildProducer<BeanContainerListenerBuildItem> beanContainerListener, List<HibernateOrmIntegrationBuildItem> integrations, LaunchModeBuildItem launchMode) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("hibernate-orm"));
        List<ParsedPersistenceXmlDescriptor> explicitDescriptors = HibernateOrmProcessor.loadOriginalXMLParsedDescriptors();
        Indexer indexer = new Indexer();
        HashSet additionalIndex = new HashSet();
        for (AdditionalJpaModelBuildItem jpaModel : additionalJpaModelBuildItems) {
            IndexingUtil.indexClass((String)jpaModel.getClassName(), (Indexer)indexer, (IndexView)index.getIndex(), additionalIndex, (ClassLoader)HibernateOrmProcessor.class.getClassLoader());
        }
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{index.getIndex(), indexer.complete()});
        Set<String> nonJpaModelClasses = nonJpaModelBuildItems.stream().map(NonJpaModelBuildItem::getClassName).collect(Collectors.toSet());
        Set<String> ignorableNonIndexedClasses = Collections.emptySet();
        if (!ignorableNonIndexedClassesBuildItems.isEmpty()) {
            ignorableNonIndexedClasses = new HashSet();
            for (IgnorableNonIndexedClasses buildItem : ignorableNonIndexedClassesBuildItems) {
                ignorableNonIndexedClasses.addAll(buildItem.getClasses());
            }
        }
        JpaJandexScavenger scavenger = new JpaJandexScavenger(reflectiveClass, explicitDescriptors, (IndexView)compositeIndex, nonJpaModelClasses, ignorableNonIndexedClasses);
        JpaEntitiesBuildItem domainObjects = scavenger.discoverModelAndRegisterForReflection();
        domainObjectsProducer.produce((BuildItem)domainObjects);
        boolean enableORM = this.hasEntities(domainObjects, nonJpaModelBuildItems);
        recorder.callHibernateFeatureInit(enableORM);
        if (!enableORM) {
            return;
        }
        ArrayList<ParsedPersistenceXmlDescriptor> allDescriptors = new ArrayList<ParsedPersistenceXmlDescriptor>(explicitDescriptors.size() + 1);
        allDescriptors.addAll(explicitDescriptors);
        this.handleHibernateORMWithNoPersistenceXml(allDescriptors, resourceProducer, systemPropertyProducer, archiveRoot, driverBuildItem, applicationArchivesBuildItem, launchMode.getLaunchMode());
        for (ParsedPersistenceXmlDescriptor descriptor : allDescriptors) {
            persistenceUnitDescriptorProducer.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(descriptor));
        }
        for (String className : domainObjects.getEntityClassNames()) {
            recorder.addEntity(className);
        }
        recorder.enlistPersistenceUnit();
        QuarkusScanner scanner = new QuarkusScanner();
        HashSet<QuarkusScanner.ClassDescriptorImpl> classDescriptors = new HashSet<QuarkusScanner.ClassDescriptorImpl>();
        for (String string : domainObjects.getAllModelClassNames()) {
            QuarkusScanner.ClassDescriptorImpl desc = new QuarkusScanner.ClassDescriptorImpl(string, ClassDescriptor.Categorization.MODEL);
            classDescriptors.add(desc);
        }
        scanner.setClassDescriptors(classDescriptors);
        recorderContext.registerNonDefaultConstructor(ParsedPersistenceXmlDescriptor.class.getDeclaredConstructor(URL.class), i -> Collections.singletonList(i.getPersistenceUnitRootUrl()));
        LinkedHashSet<Class> integratorClasses = new LinkedHashSet<Class>();
        for (String integratorClassName : ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)"META-INF/services/org.hibernate.integrator.spi.Integrator")) {
            integratorClasses.add(recorderContext.classProxy(integratorClassName));
        }
        LinkedHashSet<Class> linkedHashSet = new LinkedHashSet<Class>();
        for (String serviceContributorClassName : ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)"META-INF/services/org.hibernate.service.spi.ServiceContributor")) {
            linkedHashSet.add(recorderContext.classProxy(serviceContributorClassName));
        }
        beanContainerListener.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initMetadata(allDescriptors, (Scanner)scanner, integratorClasses, linkedHashSet)));
    }

    @BuildStep
    void handleNativeImageImportSql(BuildProducer<NativeImageResourceBuildItem> resources, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels, LaunchModeBuildItem launchMode) {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        for (PersistenceUnitDescriptorBuildItem i : descriptors) {
            if (i.getDescriptor().getProperties().containsKey("javax.persistence.sql-load-script-source")) {
                resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{(String)i.getDescriptor().getProperties().get("javax.persistence.sql-load-script-source")}));
                continue;
            }
            this.getSqlLoadScript(launchMode.getLaunchMode()).ifPresent(script -> resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{script})));
        }
    }

    @BuildStep
    void setupResourceInjection(BuildProducer<ResourceAnnotationBuildItem> resourceAnnotations, BuildProducer<GeneratedResourceBuildItem> resources, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) throws UnsupportedEncodingException {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        resources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/services/io.quarkus.arc.ResourceReferenceProvider", JPAResourceReferenceProvider.class.getName().getBytes("UTF-8")));
        resourceAnnotations.produce((BuildItem)new ResourceAnnotationBuildItem(PERSISTENCE_CONTEXT));
        resourceAnnotations.produce((BuildItem)new ResourceAnnotationBuildItem(PERSISTENCE_UNIT));
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, CombinedIndexBuildItem combinedIndex, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{JPAConfig.class, TransactionEntityManagers.class, RequestScopedEntityManagerHolder.class}).build());
        if (descriptors.size() == 1) {
            if (this.isUserDefinedProducerMissing(combinedIndex.getIndex(), PERSISTENCE_UNIT)) {
                additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultEntityManagerFactoryProducer.class}));
            }
            if (this.isUserDefinedProducerMissing(combinedIndex.getIndex(), PERSISTENCE_CONTEXT)) {
                additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultEntityManagerProducer.class}));
            }
        }
    }

    @BuildStep
    public HibernateEnhancersRegisteredBuildItem enhancerDomainObjects(JpaEntitiesBuildItem domainObjects, BuildProducer<BytecodeTransformerBuildItem> transformers, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        this.enhanceEntities(domainObjects, transformers, additionalJpaModelBuildItems, additionalClasses);
        return new HibernateEnhancersRegisteredBuildItem();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateOrmRecorder recorder, Capabilities capabilities, BuildProducer<BeanContainerListenerBuildItem> buildProducer, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) throws Exception {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        buildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initializeJpa(capabilities.isCapabilityPresent("io.quarkus.transactions"))));
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : descriptors) {
            buildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.registerPersistenceUnit(persistenceUnitDescriptor.getDescriptor().getName())));
        }
        buildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initDefaultPersistenceUnit()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void startPersistenceUnits(HibernateOrmRecorder recorder, BeanContainerBuildItem beanContainer, Optional<DataSourceInitializedBuildItem> dataSourceInitialized, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationsRuntimeConfigured, Optional<DataSourceSchemaReadyBuildItem> schemaReadyBuildItem) throws Exception {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        recorder.startAllPersistenceUnits(beanContainer.getValue());
    }

    private Optional<String> getSqlLoadScript(LaunchMode launchMode) {
        if (this.hibernateConfig.sqlLoadScript.isPresent()) {
            if (NO_SQL_LOAD_SCRIPT_FILE.equalsIgnoreCase(this.hibernateConfig.sqlLoadScript.get())) {
                return Optional.empty();
            }
            return Optional.of(this.hibernateConfig.sqlLoadScript.get());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Optional.empty();
        }
        return Optional.of("import.sql");
    }

    private boolean hasEntities(JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        return !jpaEntities.getEntityClassNames().isEmpty() || !nonJpaModels.isEmpty();
    }

    private boolean isUserDefinedProducerMissing(IndexView index, DotName annotationName) {
        for (AnnotationInstance annotationInstance : index.getAnnotations(annotationName)) {
            if (annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD) {
                if (!annotationInstance.target().asMethod().hasAnnotation(PRODUCES)) continue;
                return false;
            }
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.FIELD) continue;
            for (AnnotationInstance i : annotationInstance.target().asField().annotations()) {
                if (!i.name().equals((Object)PRODUCES)) continue;
                return false;
            }
        }
        return true;
    }

    private void handleHibernateORMWithNoPersistenceXml(List<ParsedPersistenceXmlDescriptor> descriptors, BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<SystemPropertyBuildItem> systemProperty, ArchiveRootBuildItem root, Optional<DataSourceDriverBuildItem> driverBuildItem, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode) {
        if (descriptors.isEmpty()) {
            Optional<String> dialect = this.hibernateConfig.dialect;
            if (!dialect.isPresent()) {
                dialect = this.guessDialect(driverBuildItem.map(DataSourceDriverBuildItem::getDriver));
            }
            dialect.ifPresent(s -> {
                Optional<String> importFile;
                ParsedPersistenceXmlDescriptor desc = new ParsedPersistenceXmlDescriptor(null);
                desc.setName("default");
                desc.setTransactionType(PersistenceUnitTransactionType.JTA);
                desc.getProperties().setProperty("hibernate.dialect", (String)s);
                if (this.hibernateConfig.dialectStorageEngine.isPresent()) {
                    systemProperty.produce((BuildItem)new SystemPropertyBuildItem("hibernate.dialect.storage_engine", this.hibernateConfig.dialectStorageEngine.get()));
                }
                desc.getProperties().setProperty("javax.persistence.schema-generation.database.action", this.hibernateConfig.database.generation);
                if (this.hibernateConfig.database.generationHaltOnError) {
                    desc.getProperties().setProperty("hibernate.hbm2ddl.halt_on_error", "true");
                }
                this.hibernateConfig.database.charset.ifPresent(charset -> desc.getProperties().setProperty("hibernate.hbm2ddl.charset_name", (String)charset));
                this.hibernateConfig.database.defaultCatalog.ifPresent(catalog -> desc.getProperties().setProperty("hibernate.default_catalog", (String)catalog));
                this.hibernateConfig.database.defaultSchema.ifPresent(schema -> desc.getProperties().setProperty("hibernate.default_schema", (String)schema));
                if (this.hibernateConfig.batchFetchSize > 0) {
                    desc.getProperties().setProperty("hibernate.default_batch_fetch_size", Integer.toString(this.hibernateConfig.batchFetchSize));
                    desc.getProperties().setProperty("hibernate.batch_fetch_style", BatchFetchStyle.PADDED.toString());
                }
                this.hibernateConfig.query.queryPlanCacheMaxSize.ifPresent(maxSize -> desc.getProperties().setProperty("hibernate.query.plan_cache_max_size", (String)maxSize));
                this.hibernateConfig.query.defaultNullOrdering.ifPresent(defaultNullOrdering -> desc.getProperties().setProperty("hibernate.order_by.default_null_ordering", (String)defaultNullOrdering));
                this.hibernateConfig.jdbc.timezone.ifPresent(timezone -> desc.getProperties().setProperty("hibernate.jdbc.time_zone", (String)timezone));
                this.hibernateConfig.jdbc.statementFetchSize.ifPresent(fetchSize -> desc.getProperties().setProperty("hibernate.jdbc.fetch_size", fetchSize.toString()));
                this.hibernateConfig.jdbc.statementBatchSize.ifPresent(fetchSize -> desc.getProperties().setProperty("hibernate.jdbc.batch_size", fetchSize.toString()));
                if (this.hibernateConfig.log.sql) {
                    desc.getProperties().setProperty("hibernate.show_sql", "true");
                    desc.getProperties().setProperty("hibernate.format_sql", "true");
                }
                if (this.hibernateConfig.log.jdbcWarnings.isPresent()) {
                    desc.getProperties().setProperty("hibernate.jdbc.log.warnings", this.hibernateConfig.log.jdbcWarnings.get().toString());
                }
                if (this.hibernateConfig.statistics) {
                    desc.getProperties().setProperty("hibernate.generate_statistics", "true");
                }
                if (!(importFile = this.getSqlLoadScript(launchMode)).isPresent()) {
                    desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", NO_SQL_LOAD_SCRIPT_FILE);
                } else {
                    Path loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile.get());
                    if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                        String resourceAsString = root.getArchiveRoot().relativize(loadScriptPath).toString();
                        resourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{resourceAsString}));
                        desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", importFile.get());
                        desc.getProperties().setProperty("hibernate.hbm2ddl.import_files_sql_extractor", MultipleLinesSqlCommandExtractor.class.getName());
                    } else if (this.hibernateConfig.sqlLoadScript.isPresent()) {
                        throw new ConfigurationError("Unable to find file referenced in 'quarkus.hibernate-orm.sql-load-script=" + this.hibernateConfig.sqlLoadScript.get() + "'. Remove property or add file to your path.");
                    }
                }
                Map<String, String> cacheConfigEntries = HibernateConfigUtil.getCacheConfigEntries(this.hibernateConfig);
                for (Map.Entry<String, String> entry : cacheConfigEntries.entrySet()) {
                    desc.getProperties().setProperty(entry.getKey(), entry.getValue());
                }
                descriptors.add(desc);
            });
        } else if (this.hibernateConfig.isAnyPropertySet()) {
            throw new ConfigurationError("Hibernate ORM configuration present in persistence.xml and Quarkus config file at the same time\nIf you use persistence.xml remove all quarkus.hibernate-orm.* properties from the Quarkus config file.");
        }
    }

    private Optional<String> guessDialect(Optional<String> driver) {
        String resolvedDriver = driver.orElse("NODRIVER");
        if (resolvedDriver.contains("postgresql")) {
            return Optional.of(QuarkusPostgreSQL95Dialect.class.getName());
        }
        if (resolvedDriver.contains("org.h2.Driver")) {
            return Optional.of(QuarkusH2Dialect.class.getName());
        }
        if (resolvedDriver.contains("org.mariadb.jdbc.Driver")) {
            return Optional.of(MariaDB103Dialect.class.getName());
        }
        if (resolvedDriver.contains("com.mysql.cj.jdbc.Driver")) {
            return Optional.of(MySQL8Dialect.class.getName());
        }
        if (resolvedDriver.contains("org.apache.derby.jdbc.ClientDriver")) {
            return Optional.of(DerbyTenSevenDialect.class.getName());
        }
        String error = driver.isPresent() ? "Hibernate extension could not guess the dialect from the driver '" + resolvedDriver + "'. Add an explicit '" + HIBERNATE_ORM_CONFIG_PREFIX + "dialect' property." : "Hibernate extension cannot guess the dialect as no JDBC driver is specified by 'quarkus.datasource.driver'";
        throw new ConfigurationError(error);
    }

    private void enhanceEntities(JpaEntitiesBuildItem domainObjects, BuildProducer<BytecodeTransformerBuildItem> transformers, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        HibernateEntityEnhancer hibernateEntityEnhancer = new HibernateEntityEnhancer();
        for (String i : domainObjects.getAllModelClassNames()) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(i, (BiFunction)hibernateEntityEnhancer));
        }
        for (AdditionalJpaModelBuildItem additionalJpaModel : additionalJpaModelBuildItems) {
            String className = additionalJpaModel.getClassName();
            try {
                byte[] bytes = IoUtil.readClassAsBytes((ClassLoader)HibernateOrmProcessor.class.getClassLoader(), (String)className);
                byte[] enhanced = hibernateEntityEnhancer.enhance(className, bytes);
                additionalClasses.produce((BuildItem)new GeneratedClassBuildItem(true, className, enhanced != null ? enhanced : bytes));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read Model class", e);
            }
        }
    }

    private static List<ParsedPersistenceXmlDescriptor> loadOriginalXMLParsedDescriptors() {
        Map configurationOverrides = Collections.emptyMap();
        return PersistenceXmlParser.locatePersistenceUnits(configurationOverrides);
    }
}

