/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodsTransformersRegisteredBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateConfigUtil;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEntityEnhancer;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.deployment.IgnorableNonIndexedClasses;
import io.quarkus.hibernate.orm.deployment.ImpliedBlockingPersistenceUnitTypeBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaEntitiesBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaJandexScavenger;
import io.quarkus.hibernate.orm.deployment.JpaModelIndexBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitMappingBuildItem;
import io.quarkus.hibernate.orm.deployment.NonJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceProviderSetUpBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.ProxyBuildingHelper;
import io.quarkus.hibernate.orm.deployment.ProxyDefinitionsBuildItem;
import io.quarkus.hibernate.orm.deployment.QuarkusPersistenceXmlParser;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRuntimeConfig;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.JPAConfigSupport;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.RequestScopedSessionHolder;
import io.quarkus.hibernate.orm.runtime.TransactionSessions;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.boot.scan.QuarkusScanner;
import io.quarkus.hibernate.orm.runtime.cdi.QuarkusArcBeanContainer;
import io.quarkus.hibernate.orm.runtime.dialect.QuarkusH2Dialect;
import io.quarkus.hibernate.orm.runtime.dialect.QuarkusPostgreSQL10Dialect;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticDescriptor;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.hibernate.orm.runtime.tenant.DataSourceTenantConnectionResolver;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import io.quarkus.hibernate.orm.runtime.tenant.TenantResolver;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.inject.Singleton;
import javax.persistence.AttributeConverter;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.metamodel.StaticMetamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.TransactionManager;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.Proxy;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.dialect.DB297Dialect;
import org.hibernate.dialect.DerbyTenSevenDialect;
import org.hibernate.dialect.MariaDB103Dialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.proxy.HibernateProxy;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public final class HibernateOrmProcessor {
    public static final String HIBERNATE_ORM_CONFIG_PREFIX = "quarkus.hibernate-orm.";
    public static final String NO_SQL_LOAD_SCRIPT_FILE = "no-file";
    private static final Logger LOG = Logger.getLogger(HibernateOrmProcessor.class);
    private static final DotName TENANT_CONNECTION_RESOLVER = DotName.createSimple((String)TenantConnectionResolver.class.getName());
    private static final DotName TENANT_RESOLVER = DotName.createSimple((String)TenantResolver.class.getName());
    private static final DotName STATIC_METAMODEL = DotName.createSimple((String)StaticMetamodel.class.getName());
    private static final DotName PERSISTENCE_UNIT = DotName.createSimple((String)PersistenceUnit.class.getName());
    private static final DotName PERSISTENCE_UNIT_REPEATABLE_CONTAINER = DotName.createSimple((String)PersistenceUnit.List.class.getName());
    private static final DotName JPA_ENTITY = DotName.createSimple((String)Entity.class.getName());
    private static final DotName MAPPED_SUPERCLASS = DotName.createSimple((String)MappedSuperclass.class.getName());
    private static final String INTEGRATOR_SERVICE_FILE = "META-INF/services/org.hibernate.integrator.spi.Integrator";
    private static final String PROXY_CACHE = HibernateOrmProcessor.class.getName() + ".proxyCache";

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.HIBERNATE_ORM);
    }

    @BuildStep
    void checkTransactionsSupport(Capabilities capabilities) {
        if (capabilities.isMissing(Capability.TRANSACTIONS) && capabilities.isMissing(Capability.HIBERNATE_REACTIVE)) {
            throw new ConfigurationException("The Hibernate ORM extension is only functional in a JTA environment.");
        }
    }

    @BuildStep
    void includeArchivesHostingEntityPackagesInIndex(HibernateOrmConfig hibernateOrmConfig, BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> additionalApplicationArchiveMarkers) {
        if (hibernateOrmConfig.defaultPersistenceUnit.packages.isPresent()) {
            for (String pakkage : hibernateOrmConfig.defaultPersistenceUnit.packages.get()) {
                additionalApplicationArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(pakkage.replace('.', '/')));
            }
        }
        for (HibernateOrmConfigPersistenceUnit persistenceUnit : hibernateOrmConfig.persistenceUnits.values()) {
            if (!persistenceUnit.packages.isPresent()) continue;
            for (String pakkage : persistenceUnit.packages.get()) {
                additionalApplicationArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem(pakkage.replace('.', '/')));
            }
        }
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem addPersistenceUnitAnnotationToIndex() {
        return new AdditionalIndexedClassesBuildItem(new String[]{PersistenceUnit.class.getName()});
    }

    @BuildStep
    public SystemPropertyBuildItem enforceDisableRuntimeEnhancer() {
        return new SystemPropertyBuildItem("hibernate.bytecode.provider", "none");
    }

    @BuildStep
    public void enrollBeanValidationTypeSafeActivatorForReflection(Capabilities capabilities, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        if (capabilities.isPresent(Capability.HIBERNATE_VALIDATOR)) {
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.hibernate.cfg.beanvalidation.TypeSafeActivator"}));
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(false, false, false, new String[]{"javax.validation.ConstraintViolation"}));
        }
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles(LaunchModeBuildItem launchMode) {
        ArrayList<HotDeploymentWatchedFileBuildItem> watchedFiles = new ArrayList<HotDeploymentWatchedFileBuildItem>();
        if (this.shouldIgnorePersistenceXmlResources()) {
            watchedFiles.add(new HotDeploymentWatchedFileBuildItem("META-INF/persistence.xml"));
        }
        watchedFiles.add(new HotDeploymentWatchedFileBuildItem(INTEGRATOR_SERVICE_FILE));
        return watchedFiles;
    }

    @BuildStep
    public void parsePersistenceXmlDescriptors(BuildProducer<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptorBuildItemBuildProducer) {
        if (!this.shouldIgnorePersistenceXmlResources()) {
            List<ParsedPersistenceXmlDescriptor> explicitDescriptors = QuarkusPersistenceXmlParser.locatePersistenceUnits();
            for (ParsedPersistenceXmlDescriptor desc : explicitDescriptors) {
                persistenceXmlDescriptorBuildItemBuildProducer.produce((BuildItem)new PersistenceXmlDescriptorBuildItem(desc));
            }
        }
    }

    @BuildStep
    public ImpliedBlockingPersistenceUnitTypeBuildItem defineTypeOfImpliedPU(List<JdbcDataSourceBuildItem> jdbcDataSourcesBuildItem, List<PersistenceXmlDescriptorBuildItem> actualXmlDescriptors, Capabilities capabilities) {
        if (!actualXmlDescriptors.isEmpty()) {
            return ImpliedBlockingPersistenceUnitTypeBuildItem.none();
        }
        if (jdbcDataSourcesBuildItem.size() == 0 && capabilities.isPresent(Capability.HIBERNATE_REACTIVE)) {
            return ImpliedBlockingPersistenceUnitTypeBuildItem.none();
        }
        return ImpliedBlockingPersistenceUnitTypeBuildItem.generateImpliedPersistenceUnit();
    }

    @BuildStep
    public void configurationDescriptorBuilding(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, ImpliedBlockingPersistenceUnitTypeBuildItem impliedPU, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchModeBuildItem launchMode, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModelBuildItems, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors) {
        if (!this.hasEntities(jpaEntities, nonJpaModelBuildItems)) {
            return;
        }
        for (PersistenceXmlDescriptorBuildItem persistenceXmlDescriptorBuildItem : persistenceXmlDescriptors) {
            persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(persistenceXmlDescriptorBuildItem.getDescriptor(), "<default>", HibernateOrmProcessor.getMultiTenancyStrategy(Optional.ofNullable(persistenceXmlDescriptorBuildItem.getDescriptor().getProperties().getProperty("hibernate.multiTenancy"))), null, false, true));
        }
        if (impliedPU.shouldGenerateImpliedBlockingPersistenceUnit()) {
            this.handleHibernateORMWithNoPersistenceXml(hibernateOrmConfig, index, persistenceXmlDescriptors, jdbcDataSources, applicationArchivesBuildItem, launchMode.getLaunchMode(), jpaEntities, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors);
        }
    }

    @BuildStep
    public JpaModelIndexBuildItem jpaEntitiesIndexer(CombinedIndexBuildItem index, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems) {
        Indexer indexer = new Indexer();
        HashSet additionalIndex = new HashSet();
        for (AdditionalJpaModelBuildItem jpaModel : additionalJpaModelBuildItems) {
            IndexingUtil.indexClass((String)jpaModel.getClassName(), (Indexer)indexer, (IndexView)index.getIndex(), additionalIndex, (ClassLoader)HibernateOrmProcessor.class.getClassLoader());
        }
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{index.getIndex(), indexer.complete()});
        return new JpaModelIndexBuildItem(compositeIndex);
    }

    @BuildStep
    public void defineJpaEntities(JpaModelIndexBuildItem indexBuildItem, BuildProducer<JpaEntitiesBuildItem> domainObjectsProducer, List<IgnorableNonIndexedClasses> ignorableNonIndexedClassesBuildItems, List<NonJpaModelBuildItem> nonJpaModelBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<UnremovableBeanBuildItem> unremovableBean, List<PersistenceXmlDescriptorBuildItem> persistenceXmlDescriptors) throws Exception {
        Set<String> nonJpaModelClasses = nonJpaModelBuildItems.stream().map(NonJpaModelBuildItem::getClassName).collect(Collectors.toSet());
        Set<String> ignorableNonIndexedClasses = Collections.emptySet();
        if (!ignorableNonIndexedClassesBuildItems.isEmpty()) {
            ignorableNonIndexedClasses = new HashSet();
            for (IgnorableNonIndexedClasses buildItem : ignorableNonIndexedClassesBuildItems) {
                ignorableNonIndexedClasses.addAll(buildItem.getClasses());
            }
        }
        JpaJandexScavenger scavenger = new JpaJandexScavenger(reflectiveClass, persistenceXmlDescriptors, (IndexView)indexBuildItem.getIndex(), nonJpaModelClasses, ignorableNonIndexedClasses);
        JpaEntitiesBuildItem domainObjects = scavenger.discoverModelAndRegisterForReflection();
        domainObjectsProducer.produce((BuildItem)domainObjects);
    }

    @BuildStep
    public ProxyDefinitionsBuildItem pregenProxies(JpaEntitiesBuildItem domainObjects, JpaModelIndexBuildItem indexBuildItem, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem) {
        HashSet<String> managedClassAndPackageNames = new HashSet<String>(domainObjects.getEntityClassNames());
        for (PersistenceUnitDescriptorBuildItem pud : persistenceUnitDescriptorBuildItems) {
            managedClassAndPackageNames.addAll(pud.getManagedClassNames());
        }
        PreGeneratedProxies proxyDefinitions = this.generatedProxies(managedClassAndPackageNames, (IndexView)indexBuildItem.getIndex(), generatedClassBuildItemBuildProducer, liveReloadBuildItem);
        return new ProxyDefinitionsBuildItem(proxyDefinitions);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateOrmRecorder recorder, Capabilities capabilities, JpaEntitiesBuildItem domainObjects, List<NonJpaModelBuildItem> nonJpaModelBuildItems, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, List<HibernateOrmIntegrationStaticConfiguredBuildItem> integrationBuildItems, ProxyDefinitionsBuildItem proxyDefinitions, BuildProducer<FeatureBuildItem> feature, BuildProducer<BeanContainerListenerBuildItem> beanContainerListener) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.HIBERNATE_ORM));
        boolean enableORM = this.hasEntities(domainObjects, nonJpaModelBuildItems);
        boolean hibernateReactivePresent = capabilities.isPresent(Capability.HIBERNATE_REACTIVE);
        if (!hibernateReactivePresent) {
            recorder.callHibernateFeatureInit(enableORM);
        }
        if (!enableORM) {
            return;
        }
        recorder.enlistPersistenceUnit(domainObjects.getEntityClassNames());
        QuarkusScanner scanner = HibernateOrmProcessor.buildQuarkusScanner(domainObjects);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<Class> integratorClasses = new LinkedHashSet<Class>();
        for (String integratorClassName : ServiceUtil.classNamesNamedIn((ClassLoader)classLoader, (String)INTEGRATOR_SERVICE_FILE)) {
            integratorClasses.add(recorderContext.classProxy(integratorClassName));
        }
        Map<String, List<HibernateOrmIntegrationStaticDescriptor>> integrationStaticDescriptors = HibernateOrmIntegrationStaticConfiguredBuildItem.collectDescriptors(integrationBuildItems);
        ArrayList<QuarkusPersistenceUnitDefinition> finalStagePUDescriptors = new ArrayList<QuarkusPersistenceUnitDefinition>();
        for (PersistenceUnitDescriptorBuildItem pud : persistenceUnitDescriptorBuildItems) {
            finalStagePUDescriptors.add(pud.asOutputPersistenceUnitDefinition(integrationStaticDescriptors.getOrDefault(pud.getPersistenceUnitName(), Collections.emptyList())));
        }
        recorderContext.registerSubstitution(QuarkusPersistenceUnitDefinition.class, QuarkusPersistenceUnitDefinition.Serialized.class, QuarkusPersistenceUnitDefinition.Substitution.class);
        beanContainerListener.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initMetadata(finalStagePUDescriptors, (Scanner)scanner, integratorClasses, proxyDefinitions.getProxies())));
    }

    @BuildStep
    void handleNativeImageImportSql(BuildProducer<NativeImageResourceBuildItem> resources, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels, LaunchModeBuildItem launchMode) {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        for (PersistenceUnitDescriptorBuildItem i : descriptors) {
            String resourceName = i.getExplicitSqlImportScriptResourceName();
            if (resourceName == null) continue;
            resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{resourceName}));
        }
    }

    @BuildStep
    void registerBeans(HibernateOrmConfig hibernateOrmConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Capabilities capabilities, CombinedIndexBuildItem combinedIndex, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        ArrayList<Class<QuarkusArcBeanContainer>> unremovableClasses = new ArrayList<Class<QuarkusArcBeanContainer>>();
        unremovableClasses.add(JPAConfig.class);
        if (capabilities.isPresent(Capability.TRANSACTIONS)) {
            unremovableClasses.add(TransactionManager.class);
            unremovableClasses.add(TransactionSessions.class);
        }
        unremovableClasses.add(RequestScopedSessionHolder.class);
        unremovableClasses.add(QuarkusArcBeanContainer.class);
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(unremovableClasses.toArray(new Class[unremovableClasses.size()])).build());
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{AttributeConverter.class}));
    }

    @Consume(value=InterceptedStaticMethodsTransformersRegisteredBuildItem.class)
    @BuildStep
    public HibernateEnhancersRegisteredBuildItem enhancerDomainObjects(JpaEntitiesBuildItem domainObjects, BuildProducer<BytecodeTransformerBuildItem> transformers, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        this.enhanceEntities(domainObjects, transformers, additionalJpaModelBuildItems, additionalClasses);
        return new HibernateEnhancersRegisteredBuildItem();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateOrmRecorder recorder, HibernateOrmConfig hibernateOrmConfig, BuildProducer<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, BuildProducer<BeanContainerListenerBuildItem> buildProducer, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) throws Exception {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        HashSet<String> persistenceUnitNames = new HashSet<String>();
        HashMap<String, Set<String>> entityPersistenceUnitMapping = new HashMap<String, Set<String>>();
        for (PersistenceUnitDescriptorBuildItem descriptor : descriptors) {
            persistenceUnitNames.add(descriptor.getPersistenceUnitName());
            for (String entityClass : descriptor.getManagedClassNames()) {
                entityPersistenceUnitMapping.putIfAbsent(entityClass, new HashSet());
                ((Set)entityPersistenceUnitMapping.get(entityClass)).add(descriptor.getPersistenceUnitName());
            }
        }
        jpaModelPersistenceUnitMapping.produce((BuildItem)new JpaModelPersistenceUnitMappingBuildItem(entityPersistenceUnitMapping));
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(JPAConfigSupport.class).scope(Singleton.class)).unremovable()).supplier(recorder.jpaConfigSupportSupplier(new JPAConfigSupport(persistenceUnitNames, entityPersistenceUnitMapping))).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public PersistenceProviderSetUpBuildItem setupPersistenceProvider(HibernateOrmRecorder recorder, Capabilities capabilities, HibernateOrmRuntimeConfig hibernateOrmRuntimeConfig, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationBuildItems) {
        if (capabilities.isMissing(Capability.HIBERNATE_REACTIVE)) {
            recorder.setupPersistenceProvider(hibernateOrmRuntimeConfig, HibernateOrmIntegrationRuntimeConfiguredBuildItem.collectDescriptors(integrationBuildItems));
        }
        return new PersistenceProviderSetUpBuildItem();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public ServiceStartBuildItem startPersistenceUnits(HibernateOrmRecorder recorder, BeanContainerBuildItem beanContainer, List<JdbcDataSourceBuildItem> dataSourcesConfigured, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels, List<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem, List<PersistenceProviderSetUpBuildItem> persistenceProviderSetUp) throws Exception {
        if (this.hasEntities(jpaEntities, nonJpaModels)) {
            recorder.startAllPersistenceUnits(beanContainer.getValue());
        }
        return new ServiceStartBuildItem("Hibernate ORM");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void multitenancy(HibernateOrmRecorder recorder, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        boolean multitenancyEnabled = false;
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : persistenceUnitDescriptors) {
            if (persistenceUnitDescriptor.getMultiTenancyStrategy() == MultiTenancyStrategy.NONE) continue;
            multitenancyEnabled = true;
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(DataSourceTenantConnectionResolver.class).scope(ApplicationScoped.class)).types(new Class[]{TenantConnectionResolver.class})).setRuntimeInit().defaultBean()).unremovable()).supplier(recorder.dataSourceTenantConnectionResolver(persistenceUnitDescriptor.getPersistenceUnitName(), persistenceUnitDescriptor.getDataSource(), persistenceUnitDescriptor.getMultiTenancyStrategy(), persistenceUnitDescriptor.getMultiTenancySchemaDataSource()));
            if (PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitDescriptor.getPersistenceUnitName())) {
                configurator.addQualifier(Default.class);
            } else {
                configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)persistenceUnitDescriptor.getPersistenceUnitName()).done();
                configurator.addQualifier().annotation(PersistenceUnit.class).addValue("value", (Object)persistenceUnitDescriptor.getPersistenceUnitName()).done();
            }
            syntheticBeans.produce((BuildItem)configurator.done());
        }
        if (multitenancyEnabled) {
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(TENANT_CONNECTION_RESOLVER)));
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(TENANT_RESOLVER)));
        }
    }

    @BuildStep
    public void produceLoggingCategories(HibernateOrmConfig hibernateOrmConfig, BuildProducer<LogCategoryBuildItem> categories) {
        if (hibernateOrmConfig.log.bindParam || hibernateOrmConfig.log.bindParameters) {
            categories.produce((BuildItem)new LogCategoryBuildItem("org.hibernate.type.descriptor.sql.BasicBinder", (Level)org.jboss.logmanager.Level.TRACE));
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    public void registerStaticMetamodelClassesForReflection(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflective) {
        Collection annotationInstances = index.getIndex().getAnnotations(STATIC_METAMODEL);
        if (!annotationInstances.isEmpty()) {
            String[] metamodel = (String[])annotationInstances.stream().map(a -> a.target().asClass().name().toString()).toArray(String[]::new);
            reflective.produce((BuildItem)new ReflectiveClassBuildItem(false, false, true, metamodel));
        }
    }

    private static Optional<String> getSqlLoadScript(Optional<String> sqlLoadScript, LaunchMode launchMode) {
        if (sqlLoadScript.isPresent()) {
            if (NO_SQL_LOAD_SCRIPT_FILE.equalsIgnoreCase(sqlLoadScript.get())) {
                return Optional.empty();
            }
            return Optional.of(sqlLoadScript.get());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Optional.empty();
        }
        return Optional.of("import.sql");
    }

    private boolean hasEntities(JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        return !jpaEntities.getEntityClassNames().isEmpty() || !nonJpaModels.isEmpty();
    }

    private void handleHibernateORMWithNoPersistenceXml(HibernateOrmConfig hibernateOrmConfig, CombinedIndexBuildItem index, List<PersistenceXmlDescriptorBuildItem> descriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, JpaEntitiesBuildItem jpaEntities, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors) {
        if (!descriptors.isEmpty()) {
            if (hibernateOrmConfig.isAnyPropertySet() || !hibernateOrmConfig.persistenceUnits.isEmpty()) {
                throw new ConfigurationError("Hibernate ORM configuration present in persistence.xml and Quarkus config file at the same time\nIf you use persistence.xml remove all quarkus.hibernate-orm.* properties from the Quarkus config file.");
            }
            return;
        }
        Optional<JdbcDataSourceBuildItem> defaultJdbcDataSource = jdbcDataSources.stream().filter(i -> i.isDefault()).findFirst();
        boolean enableDefaultPersistenceUnit = defaultJdbcDataSource.isPresent() && hibernateOrmConfig.persistenceUnits.isEmpty() || hibernateOrmConfig.defaultPersistenceUnit.isAnyPropertySet();
        Map<String, Set<String>> modelClassesAndPackagesPerPersistencesUnits = HibernateOrmProcessor.getModelClassesAndPackagesPerPersistenceUnits(hibernateOrmConfig, jpaEntities, index.getIndex(), enableDefaultPersistenceUnit);
        Set<String> modelClassesAndPackagesForDefaultPersistenceUnit = modelClassesAndPackagesPerPersistencesUnits.getOrDefault("<default>", Collections.emptySet());
        HashSet<String> storageEngineCollector = new HashSet<String>();
        if (enableDefaultPersistenceUnit) {
            HibernateOrmProcessor.producePersistenceUnitDescriptorFromConfig(hibernateOrmConfig, "<default>", hibernateOrmConfig.defaultPersistenceUnit, modelClassesAndPackagesForDefaultPersistenceUnit, jdbcDataSources, applicationArchivesBuildItem, launchMode, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, storageEngineCollector);
        } else if (!(modelClassesAndPackagesForDefaultPersistenceUnit.isEmpty() || hibernateOrmConfig.defaultPersistenceUnit.datasource.isPresent() && !DataSourceUtil.isDefault((String)hibernateOrmConfig.defaultPersistenceUnit.datasource.get()) || defaultJdbcDataSource.isPresent())) {
            throw new ConfigurationException("Model classes are defined for the default persistence unit but no default datasource found: the default EntityManagerFactory will not be created.");
        }
        for (Map.Entry<String, HibernateOrmConfigPersistenceUnit> persistenceUnitEntry : hibernateOrmConfig.persistenceUnits.entrySet()) {
            HibernateOrmProcessor.producePersistenceUnitDescriptorFromConfig(hibernateOrmConfig, persistenceUnitEntry.getKey(), persistenceUnitEntry.getValue(), modelClassesAndPackagesPerPersistencesUnits.getOrDefault(persistenceUnitEntry.getKey(), Collections.emptySet()), jdbcDataSources, applicationArchivesBuildItem, launchMode, capabilities, systemProperties, nativeImageResources, hotDeploymentWatchedFiles, persistenceUnitDescriptors, storageEngineCollector);
        }
        if (storageEngineCollector.size() > 1) {
            throw new ConfigurationException("The dialect storage engine is a global configuration property: it must be consistent across all persistence units.");
        }
    }

    private static void producePersistenceUnitDescriptorFromConfig(HibernateOrmConfig hibernateOrmConfig, String persistenceUnitName, HibernateOrmConfigPersistenceUnit persistenceUnitConfig, Set<String> modelClassesAndPackages, List<JdbcDataSourceBuildItem> jdbcDataSources, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode, Capabilities capabilities, BuildProducer<SystemPropertyBuildItem> systemProperties, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, Set<String> storageEngineCollector) {
        Properties p;
        Optional<String> importFile;
        String dataSource;
        JdbcDataSourceBuildItem jdbcDataSource;
        if (persistenceUnitConfig.datasource.isPresent()) {
            jdbcDataSource = jdbcDataSources.stream().filter(i -> persistenceUnitConfig.datasource.get().equals(i.getName())).findFirst().orElseThrow(() -> new ConfigurationException(String.format("The datasource '%1$s' is not configured but the persistence unit '%2$s' uses it.", persistenceUnitConfig.datasource.get(), persistenceUnitName)));
            dataSource = persistenceUnitConfig.datasource.get();
        } else {
            if (!PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName)) {
                throw new ConfigurationException(String.format("Datasource must be defined for persistence unit '%s'.", persistenceUnitName));
            }
            jdbcDataSource = jdbcDataSources.stream().filter(i -> i.isDefault()).findFirst().orElseThrow(() -> new ConfigurationException(String.format("The default datasource is not configured but the persistence unit '%s' uses it.", persistenceUnitName)));
            dataSource = "<default>";
        }
        Optional<String> dialect = persistenceUnitConfig.dialect.dialect;
        if (!dialect.isPresent()) {
            dialect = HibernateOrmProcessor.guessDialect(jdbcDataSource.getDbKind());
        }
        if (!dialect.isPresent()) {
            return;
        }
        ParsedPersistenceXmlDescriptor descriptor = new ParsedPersistenceXmlDescriptor(null);
        descriptor.setName(persistenceUnitName);
        descriptor.setExcludeUnlistedClasses(true);
        if (modelClassesAndPackages.isEmpty()) {
            LOG.warnf("Could not find any entities affected to the persistence unit '%s'.", (Object)persistenceUnitName);
        } else {
            descriptor.addClasses(new ArrayList<String>(modelClassesAndPackages));
        }
        descriptor.setTransactionType(PersistenceUnitTransactionType.JTA);
        descriptor.getProperties().setProperty("hibernate.dialect", dialect.get());
        if (persistenceUnitConfig.dialect.storageEngine.isPresent()) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hibernate.dialect.storage_engine", persistenceUnitConfig.dialect.storageEngine.get()));
        }
        persistenceUnitConfig.physicalNamingStrategy.ifPresent(namingStrategy -> descriptor.getProperties().setProperty("hibernate.physical_naming_strategy", (String)namingStrategy));
        persistenceUnitConfig.implicitNamingStrategy.ifPresent(namingStrategy -> descriptor.getProperties().setProperty("hibernate.implicit_naming_strategy", (String)namingStrategy));
        descriptor.getProperties().setProperty("hibernate.hbm2ddl.charset_name", persistenceUnitConfig.database.charset.name());
        persistenceUnitConfig.database.defaultCatalog.ifPresent(catalog -> descriptor.getProperties().setProperty("hibernate.default_catalog", (String)catalog));
        persistenceUnitConfig.database.defaultSchema.ifPresent(schema -> descriptor.getProperties().setProperty("hibernate.default_schema", (String)schema));
        if (persistenceUnitConfig.database.globallyQuotedIdentifiers) {
            descriptor.getProperties().setProperty("hibernate.globally_quoted_identifiers", "true");
        }
        if (persistenceUnitConfig.fetch.batchSize > 0) {
            HibernateOrmProcessor.setBatchFetchSize(descriptor, persistenceUnitConfig.fetch.batchSize);
        } else if (persistenceUnitConfig.batchFetchSize > 0) {
            HibernateOrmProcessor.setBatchFetchSize(descriptor, persistenceUnitConfig.batchFetchSize);
        }
        if (persistenceUnitConfig.fetch.maxDepth.isPresent()) {
            HibernateOrmProcessor.setMaxFetchDepth(descriptor, persistenceUnitConfig.fetch.maxDepth);
        } else if (persistenceUnitConfig.maxFetchDepth.isPresent()) {
            HibernateOrmProcessor.setMaxFetchDepth(descriptor, persistenceUnitConfig.maxFetchDepth);
        }
        descriptor.getProperties().setProperty("hibernate.query.plan_cache_max_size", Integer.toString(persistenceUnitConfig.query.queryPlanCacheMaxSize));
        descriptor.getProperties().setProperty("hibernate.order_by.default_null_ordering", persistenceUnitConfig.query.defaultNullOrdering.name().toLowerCase());
        persistenceUnitConfig.jdbc.timezone.ifPresent(timezone -> descriptor.getProperties().setProperty("hibernate.jdbc.time_zone", (String)timezone));
        persistenceUnitConfig.jdbc.statementFetchSize.ifPresent(fetchSize -> descriptor.getProperties().setProperty("hibernate.jdbc.fetch_size", String.valueOf(fetchSize)));
        persistenceUnitConfig.jdbc.statementBatchSize.ifPresent(fetchSize -> descriptor.getProperties().setProperty("hibernate.jdbc.batch_size", String.valueOf(fetchSize)));
        if (hibernateOrmConfig.metricsEnabled || hibernateOrmConfig.statistics.isPresent() && hibernateOrmConfig.statistics.get().booleanValue()) {
            descriptor.getProperties().setProperty("hibernate.generate_statistics", "true");
        }
        if ((importFile = HibernateOrmProcessor.getSqlLoadScript(persistenceUnitConfig.sqlLoadScript, launchMode)).isPresent()) {
            Path loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile.get());
            if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{importFile.get()}));
                descriptor.getProperties().setProperty("hibernate.hbm2ddl.import_files", importFile.get());
            } else if (persistenceUnitConfig.sqlLoadScript.isPresent()) {
                throw new ConfigurationError("Unable to find file referenced in 'quarkus.hibernate-orm.sql-load-script=" + persistenceUnitConfig.sqlLoadScript.get() + "'. Remove property or add file to your path.");
            }
            if (launchMode == LaunchMode.DEVELOPMENT) {
                hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(importFile.get()));
            }
        } else {
            descriptor.getProperties().setProperty("hibernate.hbm2ddl.import_files", "");
        }
        if (persistenceUnitConfig.secondLevelCachingEnabled) {
            p = descriptor.getProperties();
            p.putIfAbsent("hibernate.cache.use_reference_entries", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_second_level_cache", Boolean.TRUE);
            p.putIfAbsent("hibernate.cache.use_query_cache", Boolean.TRUE);
            p.putIfAbsent("javax.persistence.sharedCache.mode", SharedCacheMode.ENABLE_SELECTIVE);
            Map<String, String> cacheConfigEntries = HibernateConfigUtil.getCacheConfigEntries(persistenceUnitConfig);
            for (Map.Entry<String, String> entry : cacheConfigEntries.entrySet()) {
                descriptor.getProperties().setProperty(entry.getKey(), entry.getValue());
            }
        } else {
            p = descriptor.getProperties();
            p.put("hibernate.cache.use_reference_entries", Boolean.FALSE);
            p.put("hibernate.cache.use_second_level_cache", Boolean.FALSE);
            p.put("hibernate.cache.use_query_cache", Boolean.FALSE);
            p.put("javax.persistence.sharedCache.mode", SharedCacheMode.NONE);
        }
        if (capabilities.isPresent(Capability.HIBERNATE_VALIDATOR)) {
            descriptor.getProperties().setProperty("javax.persistence.validation.mode", ValidationMode.CALLBACK.name());
        }
        if (HibernateOrmProcessor.isMySQLOrMariaDB(dialect.get()) && persistenceUnitConfig.dialect.storageEngine.isPresent()) {
            storageEngineCollector.add(persistenceUnitConfig.dialect.storageEngine.get());
        }
        persistenceUnitDescriptors.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(descriptor, dataSource, HibernateOrmProcessor.getMultiTenancyStrategy(persistenceUnitConfig.multitenant), persistenceUnitConfig.multitenantSchemaDatasource.orElse(null), false, false));
    }

    public static Optional<String> guessDialect(String resolvedDbKind) {
        if (DatabaseKind.isDB2((String)resolvedDbKind)) {
            return Optional.of(DB297Dialect.class.getName());
        }
        if (DatabaseKind.isPostgreSQL((String)resolvedDbKind)) {
            return Optional.of(QuarkusPostgreSQL10Dialect.class.getName());
        }
        if (DatabaseKind.isH2((String)resolvedDbKind)) {
            return Optional.of(QuarkusH2Dialect.class.getName());
        }
        if (DatabaseKind.isMariaDB((String)resolvedDbKind)) {
            return Optional.of(MariaDB103Dialect.class.getName());
        }
        if (DatabaseKind.isMySQL((String)resolvedDbKind)) {
            return Optional.of(MySQL8Dialect.class.getName());
        }
        if (DatabaseKind.isDerby((String)resolvedDbKind)) {
            return Optional.of(DerbyTenSevenDialect.class.getName());
        }
        if (DatabaseKind.isMsSQL((String)resolvedDbKind)) {
            return Optional.of(SQLServer2012Dialect.class.getName());
        }
        String error = "Hibernate extension could not guess the dialect from the database kind '" + resolvedDbKind + "'. Add an explicit '" + HIBERNATE_ORM_CONFIG_PREFIX + "dialect' property.";
        throw new ConfigurationError(error);
    }

    private static void setMaxFetchDepth(ParsedPersistenceXmlDescriptor descriptor, OptionalInt maxFetchDepth) {
        descriptor.getProperties().setProperty("hibernate.max_fetch_depth", String.valueOf(maxFetchDepth.getAsInt()));
    }

    private static void setBatchFetchSize(ParsedPersistenceXmlDescriptor descriptor, int batchFetchSize) {
        descriptor.getProperties().setProperty("hibernate.default_batch_fetch_size", Integer.toString(batchFetchSize));
        descriptor.getProperties().setProperty("hibernate.batch_fetch_style", BatchFetchStyle.PADDED.toString());
    }

    private void enhanceEntities(JpaEntitiesBuildItem domainObjects, BuildProducer<BytecodeTransformerBuildItem> transformers, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        HibernateEntityEnhancer hibernateEntityEnhancer = new HibernateEntityEnhancer();
        for (String i : domainObjects.getAllModelClassNames()) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, i, (BiFunction)hibernateEntityEnhancer, true));
        }
        for (AdditionalJpaModelBuildItem additionalJpaModel : additionalJpaModelBuildItems) {
            String className = additionalJpaModel.getClassName();
            try {
                byte[] bytes = IoUtil.readClassAsBytes((ClassLoader)HibernateOrmProcessor.class.getClassLoader(), (String)className);
                byte[] enhanced = hibernateEntityEnhancer.enhance(className, bytes);
                additionalClasses.produce((BuildItem)new GeneratedClassBuildItem(false, className, enhanced != null ? enhanced : bytes));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read Model class", e);
            }
        }
    }

    private static Map<String, Set<String>> getModelClassesAndPackagesPerPersistenceUnits(HibernateOrmConfig hibernateOrmConfig, JpaEntitiesBuildItem jpaEntities, IndexView index, boolean enableDefaultPersistenceUnit) {
        if (hibernateOrmConfig.persistenceUnits.isEmpty()) {
            HashSet<String> allModelClassesAndPackages = new HashSet<String>(jpaEntities.getAllModelClassNames());
            allModelClassesAndPackages.addAll(jpaEntities.getAllModelPackageNames());
            return Collections.singletonMap("<default>", allModelClassesAndPackages);
        }
        HashMap<String, Set<String>> modelClassesAndPackagesPerPersistenceUnits = new HashMap<String, Set<String>>();
        boolean hasPackagesInQuarkusConfig = HibernateOrmProcessor.hasPackagesInQuarkusConfig(hibernateOrmConfig);
        Collection<AnnotationInstance> packageLevelPersistenceUnitAnnotations = HibernateOrmProcessor.getPackageLevelPersistenceUnitAnnotations(index);
        HashMap<String, Set> packageRules = new HashMap<String, Set>();
        if (hasPackagesInQuarkusConfig) {
            if (!packageLevelPersistenceUnitAnnotations.isEmpty()) {
                LOG.warn((Object)"Mixing Quarkus configuration and @PersistenceUnit annotations to define the persistence units is not supported. Ignoring the annotations.");
            }
            if (enableDefaultPersistenceUnit) {
                if (!hibernateOrmConfig.defaultPersistenceUnit.packages.isPresent()) {
                    throw new ConfigurationException("Packages must be configured for the default persistence unit.");
                }
                for (String string : hibernateOrmConfig.defaultPersistenceUnit.packages.get()) {
                    packageRules.computeIfAbsent(HibernateOrmProcessor.normalizePackage(string), p -> new HashSet()).add("<default>");
                }
            }
            for (Map.Entry entry : hibernateOrmConfig.persistenceUnits.entrySet()) {
                String candidatePersistenceUnitName = (String)entry.getKey();
                Set<String> candidatePersistenceUnitPackages = ((HibernateOrmConfigPersistenceUnit)entry.getValue()).packages.orElseThrow(() -> new ConfigurationException(String.format("Packages must be configured for persistence unit '%s'.", candidatePersistenceUnitName)));
                for (String string : candidatePersistenceUnitPackages) {
                    packageRules.computeIfAbsent(HibernateOrmProcessor.normalizePackage(string), p -> new HashSet()).add(candidatePersistenceUnitName);
                }
            }
        } else if (!packageLevelPersistenceUnitAnnotations.isEmpty()) {
            for (AnnotationInstance annotationInstance : packageLevelPersistenceUnitAnnotations) {
                String className = annotationInstance.target().asClass().name().toString();
                String packageName = className == null || className.isEmpty() || className.indexOf(46) == -1 ? "" : HibernateOrmProcessor.normalizePackage(className.substring(0, className.lastIndexOf(46)));
                String persistenceUnitName = annotationInstance.value().asString();
                if (persistenceUnitName == null || persistenceUnitName.isEmpty()) continue;
                packageRules.computeIfAbsent(packageName, p -> new HashSet()).add(persistenceUnitName);
            }
        } else {
            throw new ConfigurationException("Multiple persistence units are defined but the entities are not mapped to them. You should either use the .packages Quarkus configuration property or package-level @PersistenceUnit annotations.");
        }
        TreeSet<String> modelClassesWithPersistenceUnitAnnotations = new TreeSet<String>();
        for (String modelClassName : jpaEntities.getAllModelClassNames()) {
            ClassInfo modelClassInfo = index.getClassByName(DotName.createSimple((String)modelClassName));
            Set<String> relatedModelClassNames = HibernateOrmProcessor.getRelatedModelClassNames(index, jpaEntities.getAllModelClassNames(), modelClassInfo);
            if (modelClassInfo != null && (modelClassInfo.classAnnotation(PERSISTENCE_UNIT) != null || modelClassInfo.classAnnotation(PERSISTENCE_UNIT_REPEATABLE_CONTAINER) != null)) {
                modelClassesWithPersistenceUnitAnnotations.add(modelClassInfo.name().toString());
            }
            for (Map.Entry entry : packageRules.entrySet()) {
                if (!modelClassName.startsWith((String)entry.getKey())) continue;
                for (String persistenceUnitName : (Set)entry.getValue()) {
                    modelClassesAndPackagesPerPersistenceUnits.putIfAbsent(persistenceUnitName, new HashSet());
                    ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(modelClassName);
                    for (String relatedModelClassName : relatedModelClassNames) {
                        ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(relatedModelClassName);
                    }
                }
            }
        }
        if (!modelClassesWithPersistenceUnitAnnotations.isEmpty()) {
            throw new IllegalStateException(String.format("@PersistenceUnit annotations are not supported at the class level on model classes:\n\t- %s\nUse the `.packages` configuration property or package-level annotations instead.", String.join((CharSequence)"\n\t- ", modelClassesWithPersistenceUnitAnnotations)));
        }
        Set set = modelClassesAndPackagesPerPersistenceUnits.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set unaffectedModelClasses = jpaEntities.getAllModelClassNames().stream().filter(c -> !affectedModelClasses.contains(c)).collect(Collectors.toCollection(TreeSet::new));
        if (!unaffectedModelClasses.isEmpty()) {
            LOG.warnf("Could not find a suitable persistence unit for model classes:\n\t- %s", (Object)String.join((CharSequence)"\n\t- ", unaffectedModelClasses));
        }
        for (String modelPackageName : jpaEntities.getAllModelPackageNames()) {
            Set set2 = (Set)packageRules.get(modelPackageName);
            if (set2 == null) continue;
            for (String persistenceUnitName : set2) {
                modelClassesAndPackagesPerPersistenceUnits.putIfAbsent(persistenceUnitName, new HashSet());
                ((Set)modelClassesAndPackagesPerPersistenceUnits.get(persistenceUnitName)).add(modelPackageName);
            }
        }
        return modelClassesAndPackagesPerPersistenceUnits;
    }

    private static Set<String> getRelatedModelClassNames(IndexView index, Set<String> knownModelClassNames, ClassInfo modelClassInfo) {
        if (modelClassInfo == null) {
            return Collections.emptySet();
        }
        HashSet<String> relatedModelClassNames = new HashSet<String>();
        if (modelClassInfo.classAnnotation(JPA_ENTITY) == null && modelClassInfo.classAnnotation(MAPPED_SUPERCLASS) == null) {
            return Collections.emptySet();
        }
        modelClassInfo = index.getClassByName(modelClassInfo.superName());
        while (modelClassInfo != null && !modelClassInfo.name().equals((Object)DotNames.OBJECT)) {
            String modelSuperClassName = modelClassInfo.name().toString();
            if (knownModelClassNames.contains(modelSuperClassName)) {
                relatedModelClassNames.add(modelSuperClassName);
            }
            modelClassInfo = index.getClassByName(modelClassInfo.superName());
        }
        return relatedModelClassNames;
    }

    private static String normalizePackage(String pakkage) {
        if (pakkage.endsWith(".")) {
            return pakkage;
        }
        return pakkage + ".";
    }

    private static boolean hasPackagesInQuarkusConfig(HibernateOrmConfig hibernateOrmConfig) {
        if (hibernateOrmConfig.defaultPersistenceUnit.packages.isPresent()) {
            return true;
        }
        for (HibernateOrmConfigPersistenceUnit persistenceUnitConfig : hibernateOrmConfig.persistenceUnits.values()) {
            if (!persistenceUnitConfig.packages.isPresent()) continue;
            return true;
        }
        return false;
    }

    private static Collection<AnnotationInstance> getPackageLevelPersistenceUnitAnnotations(IndexView index) {
        Collection persistenceUnitAnnotations = index.getAnnotationsWithRepeatable(PERSISTENCE_UNIT, index);
        ArrayList<AnnotationInstance> packageLevelPersistenceUnitAnnotations = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance persistenceUnitAnnotation : persistenceUnitAnnotations) {
            if (persistenceUnitAnnotation.target().kind() != AnnotationTarget.Kind.CLASS || !"package-info".equals(persistenceUnitAnnotation.target().asClass().simpleName())) continue;
            packageLevelPersistenceUnitAnnotations.add(persistenceUnitAnnotation);
        }
        return packageLevelPersistenceUnitAnnotations;
    }

    private boolean shouldIgnorePersistenceXmlResources() {
        return Boolean.getBoolean("SKIP_PARSE_PERSISTENCE_XML");
    }

    public static QuarkusScanner buildQuarkusScanner(JpaEntitiesBuildItem domainObjects) {
        QuarkusScanner scanner = new QuarkusScanner();
        HashSet<QuarkusScanner.PackageDescriptorImpl> packageDescriptors = new HashSet<QuarkusScanner.PackageDescriptorImpl>();
        for (String packageName : domainObjects.getAllModelPackageNames()) {
            QuarkusScanner.PackageDescriptorImpl desc = new QuarkusScanner.PackageDescriptorImpl(packageName);
            packageDescriptors.add(desc);
        }
        scanner.setPackageDescriptors(packageDescriptors);
        HashSet<QuarkusScanner.ClassDescriptorImpl> classDescriptors = new HashSet<QuarkusScanner.ClassDescriptorImpl>();
        for (String className : domainObjects.getAllModelClassNames()) {
            QuarkusScanner.ClassDescriptorImpl desc = new QuarkusScanner.ClassDescriptorImpl(className, ClassDescriptor.Categorization.MODEL);
            classDescriptors.add(desc);
        }
        scanner.setClassDescriptors(classDescriptors);
        return scanner;
    }

    private static MultiTenancyStrategy getMultiTenancyStrategy(Optional<String> multitenancyStrategy) {
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.valueOf((String)multitenancyStrategy.orElse(MultiTenancyStrategy.NONE.name()).toUpperCase(Locale.ROOT));
        if (multiTenancyStrategy == MultiTenancyStrategy.DISCRIMINATOR) {
            throw new ConfigurationError("The Hibernate ORM multitenancy strategy " + MultiTenancyStrategy.DISCRIMINATOR + " is currently not supported");
        }
        return multiTenancyStrategy;
    }

    private PreGeneratedProxies generatedProxies(Set<String> managedClassAndPackageNames, IndexView combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem) {
        ProxyCache proxyCache = (ProxyCache)liveReloadBuildItem.getContextObject(ProxyCache.class);
        if (proxyCache == null) {
            proxyCache = new ProxyCache();
            liveReloadBuildItem.setContextObject(ProxyCache.class, (Object)proxyCache);
        }
        Set changedClasses = Collections.emptySet();
        if (liveReloadBuildItem.getChangeInformation() != null) {
            changedClasses = liveReloadBuildItem.getChangeInformation().getChangedClasses();
        } else {
            proxyCache.cache.clear();
        }
        PreGeneratedProxies preGeneratedProxies = new PreGeneratedProxies();
        HashMap<String, String> proxyAnnotations = new HashMap<String, String>();
        for (AnnotationInstance i : combinedIndex.getAnnotations(DotName.createSimple((String)Proxy.class.getName()))) {
            AnnotationValue proxyClass = i.value("proxyClass");
            if (proxyClass == null) continue;
            proxyAnnotations.put(i.target().asClass().name().toString(), proxyClass.asClass().name().toString());
        }
        try (ProxyBuildingHelper proxyHelper = new ProxyBuildingHelper(Thread.currentThread().getContextClassLoader());){
            for (String managedClassOrPackageName : managedClassAndPackageNames) {
                CachedProxy result;
                if (proxyCache.cache.containsKey(managedClassOrPackageName) && !this.isModified(managedClassOrPackageName, changedClasses, combinedIndex)) {
                    result = proxyCache.cache.get(managedClassOrPackageName);
                } else {
                    HashSet proxyInterfaces = new HashSet();
                    proxyInterfaces.add(HibernateProxy.class);
                    String proxy = (String)proxyAnnotations.get(managedClassOrPackageName);
                    if (proxy == null) {
                        if (!proxyHelper.isProxiable(managedClassOrPackageName)) {
                            continue;
                        }
                    } else {
                        proxyInterfaces.add(proxyHelper.uninitializedClass(proxy));
                    }
                    Class<?> mappedClass = proxyHelper.uninitializedClass(managedClassOrPackageName);
                    for (ClassInfo subclass : combinedIndex.getAllKnownSubclasses(DotName.createSimple((String)managedClassOrPackageName))) {
                        String subclassName = subclass.name().toString();
                        if (!managedClassAndPackageNames.contains(subclassName) || (proxy = (String)proxyAnnotations.get(subclassName)) == null) continue;
                        proxyInterfaces.add(proxyHelper.uninitializedClass(proxy));
                    }
                    DynamicType.Unloaded<?> unloaded = proxyHelper.buildUnloadedProxy(mappedClass, HibernateOrmProcessor.toArray(proxyInterfaces));
                    result = new CachedProxy(unloaded, proxyInterfaces.stream().map(Class::getName).collect(Collectors.toSet()));
                    proxyCache.cache.put(managedClassOrPackageName, result);
                }
                for (Map.Entry i : result.proxyDef.getAllTypes().entrySet()) {
                    generatedClassBuildItemBuildProducer.produce((BuildItem)new GeneratedClassBuildItem(true, ((TypeDescription)i.getKey()).getName(), (byte[])i.getValue()));
                }
                preGeneratedProxies.getProxies().put(managedClassOrPackageName, new PreGeneratedProxies.ProxyClassDetailsHolder(result.proxyDef.getTypeDescription().getName(), result.interfaces));
            }
        }
        return preGeneratedProxies;
    }

    private boolean isModified(String entity, Set<String> changedClasses, IndexView index) {
        if (changedClasses.contains(entity)) {
            return true;
        }
        ClassInfo clazz = index.getClassByName(DotName.createSimple((String)entity));
        if (clazz == null) {
            return false;
        }
        for (DotName i : clazz.interfaceNames()) {
            if (!this.isModified(i.toString(), changedClasses, index)) continue;
            return true;
        }
        DotName superName = clazz.superName();
        if (superName != null) {
            return this.isModified(superName.toString(), changedClasses, index);
        }
        return false;
    }

    private static Class[] toArray(Set<Class<?>> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static boolean isMySQLOrMariaDB(String dialect) {
        String lowercaseDialect = dialect.toLowerCase(Locale.ROOT);
        return lowercaseDialect.contains("mysql") || lowercaseDialect.contains("mariadb");
    }

    static final class CachedProxy {
        final DynamicType.Unloaded<?> proxyDef;
        final Set<String> interfaces;

        CachedProxy(DynamicType.Unloaded<?> proxyDef, Set<String> interfaces) {
            this.proxyDef = proxyDef;
            this.interfaces = interfaces;
        }
    }

    private static final class ProxyCache {
        Map<String, CachedProxy> cache = new HashMap<String, CachedProxy>();

        private ProxyCache() {
        }
    }
}

