/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.agroal.deployment.JdbcDataSourceBuildItem;
import io.quarkus.agroal.deployment.JdbcDataSourceSchemaReadyBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.ResourceAnnotationBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateConfigUtil;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEntityEnhancer;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.IgnorableNonIndexedClasses;
import io.quarkus.hibernate.orm.deployment.JpaEntitiesBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaJandexScavenger;
import io.quarkus.hibernate.orm.deployment.NonJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.QuarkusPersistenceXmlParser;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.runtime.DefaultEntityManagerFactoryProducer;
import io.quarkus.hibernate.orm.runtime.DefaultEntityManagerProducer;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.JPAResourceReferenceProvider;
import io.quarkus.hibernate.orm.runtime.RequestScopedEntityManagerHolder;
import io.quarkus.hibernate.orm.runtime.TransactionEntityManagers;
import io.quarkus.hibernate.orm.runtime.boot.scan.QuarkusScanner;
import io.quarkus.hibernate.orm.runtime.dialect.QuarkusH2Dialect;
import io.quarkus.hibernate.orm.runtime.dialect.QuarkusPostgreSQL10Dialect;
import io.quarkus.hibernate.orm.runtime.metrics.HibernateCounter;
import io.quarkus.hibernate.orm.runtime.proxies.PreGeneratedProxies;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.smallrye.metrics.deployment.spi.MetricBuildItem;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.enterprise.inject.Produces;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.persistence.SharedCacheMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.hibernate.annotations.Proxy;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.dialect.DerbyTenSevenDialect;
import org.hibernate.dialect.MariaDB103Dialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.SQLServer2012Dialect;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;
import org.hibernate.tool.hbm2ddl.MultipleLinesSqlCommandExtractor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public final class HibernateOrmProcessor {
    private static final Logger LOG = Logger.getLogger(HibernateOrmProcessor.class);
    private static final String HIBERNATE_ORM_CONFIG_PREFIX = "quarkus.hibernate-orm.";
    private static final String NO_SQL_LOAD_SCRIPT_FILE = "no-file";
    private static final DotName PERSISTENCE_CONTEXT = DotName.createSimple((String)PersistenceContext.class.getName());
    private static final DotName PERSISTENCE_UNIT = DotName.createSimple((String)PersistenceUnit.class.getName());
    private static final DotName PRODUCES = DotName.createSimple((String)Produces.class.getName());
    private static final String INTEGRATOR_SERVICE_FILE = "META-INF/services/org.hibernate.integrator.spi.Integrator";
    private static final String SERVICE_CONTRIBUTOR_SERVICE_FILE = "META-INF/services/org.hibernate.service.spi.ServiceContributor";
    HibernateOrmConfig hibernateConfig;

    @BuildStep
    public SystemPropertyBuildItem enforceDisableRuntimeEnhancer() {
        return new SystemPropertyBuildItem("hibernate.bytecode.provider", "none");
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles(LaunchModeBuildItem launchMode) {
        ArrayList<HotDeploymentWatchedFileBuildItem> watchedFiles = new ArrayList<HotDeploymentWatchedFileBuildItem>();
        watchedFiles.add(new HotDeploymentWatchedFileBuildItem("META-INF/persistence.xml"));
        watchedFiles.add(new HotDeploymentWatchedFileBuildItem(INTEGRATOR_SERVICE_FILE));
        watchedFiles.add(new HotDeploymentWatchedFileBuildItem(SERVICE_CONTRIBUTOR_SERVICE_FILE));
        this.getSqlLoadScript(launchMode.getLaunchMode()).ifPresent(script -> watchedFiles.add(new HotDeploymentWatchedFileBuildItem(script)));
        return watchedFiles;
    }

    @BuildStep(loadsApplicationClasses=true)
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(RecorderContext recorderContext, HibernateOrmRecorder recorder, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, List<NonJpaModelBuildItem> nonJpaModelBuildItems, List<IgnorableNonIndexedClasses> ignorableNonIndexedClassesBuildItems, CombinedIndexBuildItem index, ArchiveRootBuildItem archiveRoot, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<JdbcDataSourceBuildItem> jdbcDataSourcesBuildItem, BuildProducer<FeatureBuildItem> feature, BuildProducer<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorProducer, BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<SystemPropertyBuildItem> systemPropertyProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<JpaEntitiesBuildItem> domainObjectsProducer, BuildProducer<BeanContainerListenerBuildItem> beanContainerListener, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, List<HibernateOrmIntegrationBuildItem> integrations, LaunchModeBuildItem launchMode) throws Exception {
        PreGeneratedProxies proxyDefinitions;
        feature.produce((BuildItem)new FeatureBuildItem("hibernate-orm"));
        List<ParsedPersistenceXmlDescriptor> explicitDescriptors = QuarkusPersistenceXmlParser.locatePersistenceUnits();
        Indexer indexer = new Indexer();
        HashSet additionalIndex = new HashSet();
        for (AdditionalJpaModelBuildItem jpaModel : additionalJpaModelBuildItems) {
            IndexingUtil.indexClass((String)jpaModel.getClassName(), (Indexer)indexer, (IndexView)index.getIndex(), additionalIndex, (ClassLoader)HibernateOrmProcessor.class.getClassLoader());
        }
        CompositeIndex compositeIndex = CompositeIndex.create((IndexView[])new IndexView[]{index.getIndex(), indexer.complete()});
        Set<String> nonJpaModelClasses = nonJpaModelBuildItems.stream().map(NonJpaModelBuildItem::getClassName).collect(Collectors.toSet());
        Set<String> ignorableNonIndexedClasses = Collections.emptySet();
        if (!ignorableNonIndexedClassesBuildItems.isEmpty()) {
            ignorableNonIndexedClasses = new HashSet();
            for (IgnorableNonIndexedClasses buildItem : ignorableNonIndexedClassesBuildItems) {
                ignorableNonIndexedClasses.addAll(buildItem.getClasses());
            }
        }
        JpaJandexScavenger scavenger = new JpaJandexScavenger(reflectiveClass, explicitDescriptors, (IndexView)compositeIndex, nonJpaModelClasses, ignorableNonIndexedClasses);
        JpaEntitiesBuildItem domainObjects = scavenger.discoverModelAndRegisterForReflection();
        domainObjectsProducer.produce((BuildItem)domainObjects);
        boolean enableORM = this.hasEntities(domainObjects, nonJpaModelBuildItems);
        recorder.callHibernateFeatureInit(enableORM);
        if (!enableORM) {
            return;
        }
        Optional<JdbcDataSourceBuildItem> defaultJdbcDataSourceBuildItem = jdbcDataSourcesBuildItem.stream().filter(i -> i.isDefault()).findFirst();
        ArrayList<ParsedPersistenceXmlDescriptor> allDescriptors = new ArrayList<ParsedPersistenceXmlDescriptor>(explicitDescriptors.size() + 1);
        allDescriptors.addAll(explicitDescriptors);
        this.handleHibernateORMWithNoPersistenceXml(allDescriptors, resourceProducer, systemPropertyProducer, archiveRoot, defaultJdbcDataSourceBuildItem, applicationArchivesBuildItem, launchMode.getLaunchMode());
        for (ParsedPersistenceXmlDescriptor descriptor : allDescriptors) {
            persistenceUnitDescriptorProducer.produce((BuildItem)new PersistenceUnitDescriptorBuildItem(descriptor));
        }
        for (String className : domainObjects.getEntityClassNames()) {
            recorder.addEntity(className);
        }
        recorder.enlistPersistenceUnit();
        QuarkusScanner scanner = new QuarkusScanner();
        HashSet<QuarkusScanner.ClassDescriptorImpl> classDescriptors = new HashSet<QuarkusScanner.ClassDescriptorImpl>();
        for (String i2 : domainObjects.getAllModelClassNames()) {
            QuarkusScanner.ClassDescriptorImpl desc = new QuarkusScanner.ClassDescriptorImpl(i2, ClassDescriptor.Categorization.MODEL);
            classDescriptors.add(desc);
        }
        scanner.setClassDescriptors(classDescriptors);
        recorderContext.registerNonDefaultConstructor(ParsedPersistenceXmlDescriptor.class.getDeclaredConstructor(URL.class), i -> Collections.singletonList(i.getPersistenceUnitRootUrl()));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<Class> integratorClasses = new LinkedHashSet<Class>();
        for (Object integratorClassName : ServiceUtil.classNamesNamedIn((ClassLoader)classLoader, (String)INTEGRATOR_SERVICE_FILE)) {
            integratorClasses.add(recorderContext.classProxy((String)integratorClassName));
        }
        LinkedHashSet<Class> serviceContributorClasses = new LinkedHashSet<Class>();
        for (Object serviceContributorClassName : ServiceUtil.classNamesNamedIn((ClassLoader)classLoader, (String)SERVICE_CONTRIBUTOR_SERVICE_FILE)) {
            serviceContributorClasses.add(recorderContext.classProxy((String)serviceContributorClassName));
        }
        HashSet<String> entitiesToGenerateProxiesFor = new HashSet<String>(domainObjects.getEntityClassNames());
        for (ParsedPersistenceXmlDescriptor unit : allDescriptors) {
            entitiesToGenerateProxiesFor.addAll(unit.getManagedClassNames());
        }
        try {
            proxyDefinitions = this.generatedProxies(entitiesToGenerateProxiesFor, (IndexView)compositeIndex, generatedClassBuildItemBuildProducer);
        }
        catch (Throwable t) {
            proxyDefinitions = new PreGeneratedProxies();
            LOG.error((Object)"Failed to generate build time Hibernate proxy definitions. This is a bug, please file an issue at https://github.com/quarkusio/quarkus/issues and this stack trace.", t);
        }
        beanContainerListener.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initMetadata(allDescriptors, (Scanner)scanner, integratorClasses, serviceContributorClasses, proxyDefinitions)));
    }

    private PreGeneratedProxies generatedProxies(Set<String> entityClassNames, IndexView combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
        PreGeneratedProxies preGeneratedProxies = new PreGeneratedProxies();
        HashMap<String, String> proxyAnnotations = new HashMap<String, String>();
        for (AnnotationInstance i : combinedIndex.getAnnotations(DotName.createSimple((String)Proxy.class.getName()))) {
            AnnotationValue proxyClass = i.value("proxyClass");
            if (proxyClass == null) continue;
            proxyAnnotations.put(i.target().asClass().name().toString(), proxyClass.asClass().name().toString());
        }
        try {
            BytecodeProviderImpl bytecodeProvider = new BytecodeProviderImpl();
            ByteBuddyProxyHelper byteBuddyProxyHelper = bytecodeProvider.getByteBuddyProxyHelper();
            for (String entity : entityClassNames) {
                HashSet proxyInterfaces = new HashSet();
                proxyInterfaces.add(HibernateProxy.class);
                Class<?> mappedClass = Class.forName(entity, false, Thread.currentThread().getContextClassLoader());
                String proxy = (String)proxyAnnotations.get(entity);
                if (proxy != null) {
                    proxyInterfaces.add(Class.forName(proxy, false, Thread.currentThread().getContextClassLoader()));
                } else if (!this.isProxiable(mappedClass)) continue;
                for (ClassInfo subclass : combinedIndex.getAllKnownSubclasses(DotName.createSimple((String)entity))) {
                    String subclassName = subclass.name().toString();
                    if (!entityClassNames.contains(subclassName) || (proxy = (String)proxyAnnotations.get(subclassName)) == null) continue;
                    proxyInterfaces.add(Class.forName(proxy, false, Thread.currentThread().getContextClassLoader()));
                }
                DynamicType.Unloaded proxyDef = byteBuddyProxyHelper.buildUnloadedProxy(mappedClass, HibernateOrmProcessor.toArray(proxyInterfaces));
                for (Map.Entry i : proxyDef.getAllTypes().entrySet()) {
                    generatedClassBuildItemBuildProducer.produce((BuildItem)new GeneratedClassBuildItem(true, ((TypeDescription)i.getKey()).getName(), (byte[])i.getValue()));
                }
                preGeneratedProxies.getProxies().put(entity, new PreGeneratedProxies.ProxyClassDetailsHolder(proxyDef.getTypeDescription().getName(), proxyInterfaces.stream().map(Class::getName).collect(Collectors.toSet())));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return preGeneratedProxies;
    }

    private boolean isProxiable(Class<?> mappedClass) {
        if (Modifier.isFinal(mappedClass.getModifiers())) {
            return false;
        }
        try {
            mappedClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    private static Class[] toArray(Set<Class<?>> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    @BuildStep
    void handleNativeImageImportSql(BuildProducer<NativeImageResourceBuildItem> resources, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels, LaunchModeBuildItem launchMode) {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        for (PersistenceUnitDescriptorBuildItem i : descriptors) {
            if (i.getDescriptor().getProperties().containsKey("javax.persistence.sql-load-script-source")) {
                resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{(String)i.getDescriptor().getProperties().get("javax.persistence.sql-load-script-source")}));
                continue;
            }
            this.getSqlLoadScript(launchMode.getLaunchMode()).ifPresent(script -> resources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{script})));
        }
    }

    @BuildStep
    void setupResourceInjection(BuildProducer<ResourceAnnotationBuildItem> resourceAnnotations, BuildProducer<GeneratedResourceBuildItem> resources, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        resources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/services/io.quarkus.arc.ResourceReferenceProvider", JPAResourceReferenceProvider.class.getName().getBytes(StandardCharsets.UTF_8)));
        resourceAnnotations.produce((BuildItem)new ResourceAnnotationBuildItem(PERSISTENCE_CONTEXT));
        resourceAnnotations.produce((BuildItem)new ResourceAnnotationBuildItem(PERSISTENCE_UNIT));
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, CombinedIndexBuildItem combinedIndex, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{JPAConfig.class, TransactionEntityManagers.class, RequestScopedEntityManagerHolder.class}).build());
        if (descriptors.size() == 1) {
            if (this.isUserDefinedProducerMissing(combinedIndex.getIndex(), PERSISTENCE_UNIT)) {
                additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultEntityManagerFactoryProducer.class}));
            }
            if (this.isUserDefinedProducerMissing(combinedIndex.getIndex(), PERSISTENCE_CONTEXT)) {
                additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultEntityManagerProducer.class}));
            }
        }
    }

    @BuildStep
    public HibernateEnhancersRegisteredBuildItem enhancerDomainObjects(JpaEntitiesBuildItem domainObjects, BuildProducer<BytecodeTransformerBuildItem> transformers, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        this.enhanceEntities(domainObjects, transformers, additionalJpaModelBuildItems, additionalClasses);
        return new HibernateEnhancersRegisteredBuildItem();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(HibernateOrmRecorder recorder, Capabilities capabilities, BuildProducer<BeanContainerListenerBuildItem> buildProducer, List<PersistenceUnitDescriptorBuildItem> descriptors, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) throws Exception {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        buildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initializeJpa(capabilities.isCapabilityPresent("io.quarkus.transactions"))));
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : descriptors) {
            buildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.registerPersistenceUnit(persistenceUnitDescriptor.getDescriptor().getName())));
        }
        buildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initDefaultPersistenceUnit()));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void startPersistenceUnits(HibernateOrmRecorder recorder, BeanContainerBuildItem beanContainer, List<JdbcDataSourceBuildItem> dataSourcesConfigured, JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels, List<HibernateOrmIntegrationRuntimeConfiguredBuildItem> integrationsRuntimeConfigured, List<JdbcDataSourceSchemaReadyBuildItem> schemaReadyBuildItem) throws Exception {
        if (!this.hasEntities(jpaEntities, nonJpaModels)) {
            return;
        }
        recorder.startAllPersistenceUnits(beanContainer.getValue());
    }

    @BuildStep
    public void metrics(HibernateOrmConfig config, BuildProducer<MetricBuildItem> metrics) {
        boolean metricsEnabled = config.metricsEnabled && config.statistics.orElse(true) != false;
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.sessions.open", "Global number of sessions opened", "sessionsOpened", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.sessions.closed", "Global number of sessions closed", "sessionsClosed", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.sessions.closed", "Global number of sessions closed", "sessionsClosed", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.transactions", "The number of transactions we know to have completed", "transactionCount", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.transactions.successful", "The number of transactions we know to have been successful", "successfulTransactions", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.optimistic.lock.failures", "The number of Hibernate StaleObjectStateExceptions or JPA OptimisticLockExceptions that occurred.", "optimisticLockFailures", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.flushes", "Global number of flush operations executed (either manual or automatic).", "flushes", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.connections.obtained", "Get the global number of connections asked by the sessions (the actual number of connections used may be much smaller depending whether you use a connection pool or not)", "connectionsObtained", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.statements.prepared", "The number of prepared statements that were acquired", "statementsPrepared", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.statements.closed", "The number of prepared statements that were released", "statementsClosed", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.second-level-cache.puts", "Global number of cacheable entities/collections put in the cache", "secondLevelCachePuts", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.second-level-cache.hits", "Global number of cacheable entities/collections successfully retrieved from the cache", "secondLevelCacheHits", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.second-level-cache.misses", "Global number of cacheable entities/collections not found in the cache and loaded from the database.", "secondLevelCacheMisses", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.entities.loaded", "Global number of entity loads", "entitiesLoaded", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.entities.updated", "Global number of entity updates", "entitiesUpdated", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.entities.inserted", "Global number of entity inserts", "entitiesInserted", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.entities.deleted", "Global number of entity deletes", "entitiesDeleted", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.entities.fetched", "Global number of entity fetches", "entitiesFetched", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.collections.loaded", "Global number of collections loaded", "collectionsLoaded", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.collections.updated", "Global number of collections updated", "collectionsUpdated", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.collections.removed", "Global number of collections removed", "collectionsRemoved", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.collections.recreated", "Global number of collections recreated", "collectionsRecreated", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.collections.fetched", "Global number of collections fetched", "collectionsFetched", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.natural-id.queries.executions", "Global number of natural id queries executed against the database", "naturalIdQueriesExecutedToDatabase", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.natural-id.cache.hits", "Global number of cached natural id lookups successfully retrieved from cache", "naturalIdCacheHits", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.natural-id.cache.puts", "Global number of cacheable natural id lookups put in cache", "naturalIdCachePuts", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.natural-id.cache.misses", "Global number of cached natural id lookups *not* found in cache", "naturalIdCacheMisses", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.queries.executed", "Global number of executed queries", "queriesExecutedToDatabase", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.query-cache.puts", "Global number of cacheable queries put in cache", "queryCachePuts", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.query-cache.hits", "Global number of cached queries successfully retrieved from cache", "queryCacheHits", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.query-cache.misses", "Global number of cached queries *not* found in cache", "queryCacheMisses", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.timestamps-cache.puts", "Global number of timestamps put in cache", "updateTimestampsCachePuts", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.timestamps-cache.hits", "Global number of timestamps successfully retrieved from cache", "updateTimestampsCacheHits", metricsEnabled));
        metrics.produce((BuildItem)this.createMetricBuildItem("hibernate-orm.timestamps-cache.misses", "Global number of timestamp requests that were not found in the cache", "updateTimestampsCacheMisses", metricsEnabled));
    }

    private MetricBuildItem createMetricBuildItem(String metricName, String description, String metric, boolean metricsEnabled) {
        return new MetricBuildItem(Metadata.builder().withName(metricName).withDescription(description).withType(MetricType.COUNTER).build(), (Object)new HibernateCounter("default", metric), metricsEnabled, "hibernate-orm", new Tag[0]);
    }

    private Optional<String> getSqlLoadScript(LaunchMode launchMode) {
        if (this.hibernateConfig.sqlLoadScript.isPresent()) {
            if (NO_SQL_LOAD_SCRIPT_FILE.equalsIgnoreCase(this.hibernateConfig.sqlLoadScript.get())) {
                return Optional.empty();
            }
            return Optional.of(this.hibernateConfig.sqlLoadScript.get());
        }
        if (launchMode == LaunchMode.NORMAL) {
            return Optional.empty();
        }
        return Optional.of("import.sql");
    }

    private boolean hasEntities(JpaEntitiesBuildItem jpaEntities, List<NonJpaModelBuildItem> nonJpaModels) {
        return !jpaEntities.getEntityClassNames().isEmpty() || !nonJpaModels.isEmpty();
    }

    private boolean isUserDefinedProducerMissing(IndexView index, DotName annotationName) {
        for (AnnotationInstance annotationInstance : index.getAnnotations(annotationName)) {
            if (annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD) {
                if (!annotationInstance.target().asMethod().hasAnnotation(PRODUCES)) continue;
                return false;
            }
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.FIELD) continue;
            for (AnnotationInstance i : annotationInstance.target().asField().annotations()) {
                if (!i.name().equals((Object)PRODUCES)) continue;
                return false;
            }
        }
        return true;
    }

    private void handleHibernateORMWithNoPersistenceXml(List<ParsedPersistenceXmlDescriptor> descriptors, BuildProducer<NativeImageResourceBuildItem> resourceProducer, BuildProducer<SystemPropertyBuildItem> systemProperty, ArchiveRootBuildItem root, Optional<JdbcDataSourceBuildItem> driverBuildItem, ApplicationArchivesBuildItem applicationArchivesBuildItem, LaunchMode launchMode) {
        if (descriptors.isEmpty()) {
            Optional<String> dialect = this.hibernateConfig.dialect;
            if (!dialect.isPresent()) {
                dialect = this.guessDialect(driverBuildItem.map(JdbcDataSourceBuildItem::getDbKind));
            }
            dialect.ifPresent(s -> {
                Properties p;
                Optional<String> importFile;
                ParsedPersistenceXmlDescriptor desc = new ParsedPersistenceXmlDescriptor(null);
                desc.setName("default");
                desc.setTransactionType(PersistenceUnitTransactionType.JTA);
                desc.getProperties().setProperty("hibernate.dialect", (String)s);
                if (this.hibernateConfig.dialectStorageEngine.isPresent()) {
                    systemProperty.produce((BuildItem)new SystemPropertyBuildItem("hibernate.dialect.storage_engine", this.hibernateConfig.dialectStorageEngine.get()));
                }
                this.hibernateConfig.physicalNamingStrategy.ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.physical_naming_strategy", (String)namingStrategy));
                this.hibernateConfig.implicitNamingStrategy.ifPresent(namingStrategy -> desc.getProperties().setProperty("hibernate.implicit_naming_strategy", (String)namingStrategy));
                desc.getProperties().setProperty("javax.persistence.schema-generation.database.action", this.hibernateConfig.database.generation);
                if (this.hibernateConfig.database.generationHaltOnError) {
                    desc.getProperties().setProperty("hibernate.hbm2ddl.halt_on_error", "true");
                }
                this.hibernateConfig.database.charset.ifPresent(charset -> desc.getProperties().setProperty("hibernate.hbm2ddl.charset_name", (String)charset));
                this.hibernateConfig.database.defaultCatalog.ifPresent(catalog -> desc.getProperties().setProperty("hibernate.default_catalog", (String)catalog));
                this.hibernateConfig.database.defaultSchema.ifPresent(schema -> desc.getProperties().setProperty("hibernate.default_schema", (String)schema));
                if (this.hibernateConfig.database.globallyQuotedIdentifiers) {
                    desc.getProperties().setProperty("hibernate.globally_quoted_identifiers", "true");
                }
                if (this.hibernateConfig.batchFetchSize > 0) {
                    desc.getProperties().setProperty("hibernate.default_batch_fetch_size", Integer.toString(this.hibernateConfig.batchFetchSize));
                    desc.getProperties().setProperty("hibernate.batch_fetch_style", BatchFetchStyle.PADDED.toString());
                }
                this.hibernateConfig.query.queryPlanCacheMaxSize.ifPresent(maxSize -> desc.getProperties().setProperty("hibernate.query.plan_cache_max_size", (String)maxSize));
                this.hibernateConfig.query.defaultNullOrdering.ifPresent(defaultNullOrdering -> desc.getProperties().setProperty("hibernate.order_by.default_null_ordering", (String)defaultNullOrdering));
                this.hibernateConfig.jdbc.timezone.ifPresent(timezone -> desc.getProperties().setProperty("hibernate.jdbc.time_zone", (String)timezone));
                this.hibernateConfig.jdbc.statementFetchSize.ifPresent(fetchSize -> desc.getProperties().setProperty("hibernate.jdbc.fetch_size", fetchSize.toString()));
                this.hibernateConfig.jdbc.statementBatchSize.ifPresent(fetchSize -> desc.getProperties().setProperty("hibernate.jdbc.batch_size", fetchSize.toString()));
                if (this.hibernateConfig.log.sql) {
                    desc.getProperties().setProperty("hibernate.show_sql", "true");
                    desc.getProperties().setProperty("hibernate.format_sql", "true");
                }
                if (this.hibernateConfig.log.jdbcWarnings.isPresent()) {
                    desc.getProperties().setProperty("hibernate.jdbc.log.warnings", this.hibernateConfig.log.jdbcWarnings.get().toString());
                }
                if (this.hibernateConfig.metricsEnabled || this.hibernateConfig.statistics.isPresent() && this.hibernateConfig.statistics.get().booleanValue()) {
                    desc.getProperties().setProperty("hibernate.generate_statistics", "true");
                }
                if (!(importFile = this.getSqlLoadScript(launchMode)).isPresent()) {
                    desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", NO_SQL_LOAD_SCRIPT_FILE);
                } else {
                    Path loadScriptPath = applicationArchivesBuildItem.getRootArchive().getChildPath(importFile.get());
                    if (loadScriptPath != null && !Files.isDirectory(loadScriptPath, new LinkOption[0])) {
                        String resourceAsString = root.getArchiveRoot().relativize(loadScriptPath).toString();
                        resourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{resourceAsString}));
                        desc.getProperties().setProperty("hibernate.hbm2ddl.import_files", importFile.get());
                        desc.getProperties().setProperty("hibernate.hbm2ddl.import_files_sql_extractor", MultipleLinesSqlCommandExtractor.class.getName());
                    } else if (this.hibernateConfig.sqlLoadScript.isPresent()) {
                        throw new ConfigurationError("Unable to find file referenced in 'quarkus.hibernate-orm.sql-load-script=" + this.hibernateConfig.sqlLoadScript.get() + "'. Remove property or add file to your path.");
                    }
                }
                if (this.hibernateConfig.secondLevelCachingEnabled) {
                    p = desc.getProperties();
                    p.putIfAbsent("hibernate.cache.use_reference_entries", Boolean.TRUE);
                    p.putIfAbsent("hibernate.cache.use_second_level_cache", Boolean.TRUE);
                    p.putIfAbsent("hibernate.cache.use_query_cache", Boolean.TRUE);
                    p.putIfAbsent("javax.persistence.sharedCache.mode", SharedCacheMode.ENABLE_SELECTIVE);
                    Map<String, String> cacheConfigEntries = HibernateConfigUtil.getCacheConfigEntries(this.hibernateConfig);
                    for (Map.Entry<String, String> entry : cacheConfigEntries.entrySet()) {
                        desc.getProperties().setProperty(entry.getKey(), entry.getValue());
                    }
                } else {
                    p = desc.getProperties();
                    p.put("hibernate.cache.use_reference_entries", Boolean.FALSE);
                    p.put("hibernate.cache.use_second_level_cache", Boolean.FALSE);
                    p.put("hibernate.cache.use_query_cache", Boolean.FALSE);
                    p.put("javax.persistence.sharedCache.mode", SharedCacheMode.NONE);
                }
                descriptors.add(desc);
            });
        } else if (this.hibernateConfig.isAnyPropertySet()) {
            throw new ConfigurationError("Hibernate ORM configuration present in persistence.xml and Quarkus config file at the same time\nIf you use persistence.xml remove all quarkus.hibernate-orm.* properties from the Quarkus config file.");
        }
    }

    private Optional<String> guessDialect(Optional<String> dbKind) {
        String resolvedDbKind = dbKind.orElse("NO_DATABASE_KIND");
        if (DatabaseKind.isPostgreSQL((String)resolvedDbKind)) {
            return Optional.of(QuarkusPostgreSQL10Dialect.class.getName());
        }
        if (DatabaseKind.isH2((String)resolvedDbKind)) {
            return Optional.of(QuarkusH2Dialect.class.getName());
        }
        if (DatabaseKind.isMariaDB((String)resolvedDbKind)) {
            return Optional.of(MariaDB103Dialect.class.getName());
        }
        if (DatabaseKind.isMySQL((String)resolvedDbKind)) {
            return Optional.of(MySQL8Dialect.class.getName());
        }
        if (DatabaseKind.isDerby((String)resolvedDbKind)) {
            return Optional.of(DerbyTenSevenDialect.class.getName());
        }
        if (DatabaseKind.isMsSQL((String)resolvedDbKind)) {
            return Optional.of(SQLServer2012Dialect.class.getName());
        }
        String error = dbKind.isPresent() ? "Hibernate extension could not guess the dialect from the database kind '" + resolvedDbKind + "'. Add an explicit '" + HIBERNATE_ORM_CONFIG_PREFIX + "dialect' property." : "Hibernate extension cannot guess the dialect as no database kind is specified by 'quarkus.datasource.db-kind'";
        throw new ConfigurationError(error);
    }

    private void enhanceEntities(JpaEntitiesBuildItem domainObjects, BuildProducer<BytecodeTransformerBuildItem> transformers, List<AdditionalJpaModelBuildItem> additionalJpaModelBuildItems, BuildProducer<GeneratedClassBuildItem> additionalClasses) {
        HibernateEntityEnhancer hibernateEntityEnhancer = new HibernateEntityEnhancer();
        for (String i : domainObjects.getAllModelClassNames()) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(i, (BiFunction)hibernateEntityEnhancer));
        }
        for (AdditionalJpaModelBuildItem additionalJpaModel : additionalJpaModelBuildItems) {
            String className = additionalJpaModel.getClassName();
            try {
                byte[] bytes = IoUtil.readClassAsBytes((ClassLoader)HibernateOrmProcessor.class.getClassLoader(), (String)className);
                byte[] enhanced = hibernateEntityEnhancer.enhance(className, bytes);
                additionalClasses.produce((BuildItem)new GeneratedClassBuildItem(false, className, enhanced != null ? enhanced : bytes));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read Model class", e);
            }
        }
    }
}

