/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.hibernate.orm.deployment.JpaEntitiesBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

final class JpaJandexScavenger {
    private static final DotName JPA_ENTITY = DotName.createSimple((String)Entity.class.getName());
    private static final DotName EMBEDDABLE = DotName.createSimple((String)Embeddable.class.getName());
    private static final List<DotName> EMBEDDED_ANNOTATIONS = Arrays.asList(DotName.createSimple((String)Embedded.class.getName()), DotName.createSimple((String)ElementCollection.class.getName()));
    private static final DotName MAPPED_SUPERCLASS = DotName.createSimple((String)MappedSuperclass.class.getName());
    private static final DotName ENUM = DotName.createSimple((String)Enum.class.getName());
    private final List<PersistenceXmlDescriptorBuildItem> explicitDescriptors;
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    private final IndexView indexView;
    private final Set<String> nonJpaModelClasses;
    private final Set<String> ignorableNonIndexedClasses;

    JpaJandexScavenger(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, List<PersistenceXmlDescriptorBuildItem> explicitDescriptors, IndexView indexView, Set<String> nonJpaModelClasses, Set<String> ignorableNonIndexedClasses) {
        this.reflectiveClass = reflectiveClass;
        this.explicitDescriptors = explicitDescriptors;
        this.indexView = indexView;
        this.nonJpaModelClasses = nonJpaModelClasses;
        this.ignorableNonIndexedClasses = ignorableNonIndexedClasses;
    }

    public JpaEntitiesBuildItem discoverModelAndRegisterForReflection() throws IOException {
        JpaEntitiesBuildItem domainObjectCollector = new JpaEntitiesBuildItem();
        HashSet<String> enumTypeCollector = new HashSet<String>();
        HashSet<String> javaTypeCollector = new HashSet<String>();
        TreeSet<DotName> unindexedClasses = new TreeSet<DotName>();
        this.enlistJPAModelClasses(this.indexView, domainObjectCollector, enumTypeCollector, javaTypeCollector, JPA_ENTITY, unindexedClasses);
        this.enlistJPAModelClasses(this.indexView, domainObjectCollector, enumTypeCollector, javaTypeCollector, EMBEDDABLE, unindexedClasses);
        this.enlistJPAModelClasses(this.indexView, domainObjectCollector, enumTypeCollector, javaTypeCollector, MAPPED_SUPERCLASS, unindexedClasses);
        JpaJandexScavenger.enlistEmbeddedsAndElementCollections(this.indexView, domainObjectCollector, enumTypeCollector, javaTypeCollector, unindexedClasses);
        for (PersistenceXmlDescriptorBuildItem pud : this.explicitDescriptors) {
            List managedClassNames = pud.getDescriptor().getManagedClassNames();
            JpaJandexScavenger.enlistExplicitClasses(this.indexView, domainObjectCollector, enumTypeCollector, javaTypeCollector, managedClassNames, unindexedClasses);
        }
        domainObjectCollector.registerAllForReflection(this.reflectiveClass);
        if (!enumTypeCollector.isEmpty()) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{Enum.class.getName()}));
            for (String className : enumTypeCollector) {
                this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{className}));
            }
        }
        for (String javaType : javaTypeCollector) {
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{javaType}));
        }
        if (!unindexedClasses.isEmpty()) {
            Set unIgnorableIndexedClasses = unindexedClasses.stream().map(DotName::toString).collect(Collectors.toSet());
            unIgnorableIndexedClasses.removeAll(this.ignorableNonIndexedClasses);
            if (!unIgnorableIndexedClasses.isEmpty()) {
                String unindexedClassesErrorMessage = unIgnorableIndexedClasses.stream().map(d -> "\t- " + d + "\n").collect(Collectors.joining());
                throw new ConfigurationError("Unable to properly register the hierarchy of the following JPA classes as they are not in the Jandex index:\n" + unindexedClassesErrorMessage + "Consider adding them to the index either by creating a Jandex index for your dependency via the Maven plugin, an empty META-INF/beans.xml or quarkus.index-dependency properties.");
            }
        }
        return domainObjectCollector;
    }

    private static void enlistExplicitClasses(IndexView index, JpaEntitiesBuildItem domainObjectCollector, Set<String> enumTypeCollector, Set<String> javaTypeCollector, List<String> managedClassNames, Set<DotName> unindexedClasses) {
        for (String className : managedClassNames) {
            boolean isInIndex;
            DotName dotName = DotName.createSimple((String)className);
            boolean bl = isInIndex = index.getClassByName(dotName) != null;
            if (!isInIndex) {
                unindexedClasses.add(dotName);
            }
            JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, javaTypeCollector, dotName, unindexedClasses);
        }
    }

    private static void enlistEmbeddedsAndElementCollections(IndexView index, JpaEntitiesBuildItem domainObjectCollector, Set<String> enumTypeCollector, Set<String> javaTypeCollector, Set<DotName> unindexedClasses) {
        HashSet<DotName> embeddedTypes = new HashSet<DotName>();
        for (DotName embeddedAnnotation : EMBEDDED_ANNOTATIONS) {
            Collection annotations = index.getAnnotations(embeddedAnnotation);
            block5: for (AnnotationInstance annotation : annotations) {
                AnnotationTarget target = annotation.target();
                switch (target.kind()) {
                    case FIELD: {
                        JpaJandexScavenger.collectEmbeddedTypes(embeddedTypes, target.asField().type());
                        continue block5;
                    }
                    case METHOD: {
                        JpaJandexScavenger.collectEmbeddedTypes(embeddedTypes, target.asMethod().returnType());
                        continue block5;
                    }
                }
                throw new IllegalStateException("[internal error] " + embeddedAnnotation + " placed on a unknown element: " + target);
            }
        }
        for (DotName embeddedType : embeddedTypes) {
            JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, javaTypeCollector, embeddedType, unindexedClasses);
        }
    }

    private void enlistJPAModelClasses(IndexView index, JpaEntitiesBuildItem domainObjectCollector, Set<String> enumTypeCollector, Set<String> javaTypeCollector, DotName dotName, Set<DotName> unindexedClasses) {
        Collection jpaAnnotations = index.getAnnotations(dotName);
        if (jpaAnnotations == null) {
            return;
        }
        for (AnnotationInstance annotation : jpaAnnotations) {
            ClassInfo klass = annotation.target().asClass();
            DotName targetDotName = klass.name();
            if (this.nonJpaModelClasses.contains(targetDotName.toString())) continue;
            JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, javaTypeCollector, targetDotName, unindexedClasses);
            JpaJandexScavenger.collectDomainObject(domainObjectCollector, klass);
        }
    }

    private static void addClassHierarchyToReflectiveList(IndexView index, JpaEntitiesBuildItem domainObjectCollector, Set<String> enumTypeCollector, Set<String> javaTypeCollector, DotName className, Set<DotName> unindexedClasses) {
        if (className == null || JpaJandexScavenger.isIgnored(className)) {
            return;
        }
        if (JpaJandexScavenger.isInJavaPackage(className)) {
            javaTypeCollector.add(className.toString());
            return;
        }
        ClassInfo classInfo = index.getClassByName(className);
        if (classInfo == null) {
            unindexedClasses.add(className);
            return;
        }
        for (FieldInfo fieldInfo : classInfo.fields()) {
            DotName fieldType = fieldInfo.type().name();
            ClassInfo fieldTypeClassInfo = index.getClassByName(fieldType);
            if (fieldTypeClassInfo == null || !ENUM.equals((Object)fieldTypeClassInfo.superName())) continue;
            enumTypeCollector.add(fieldType.toString());
        }
        JpaJandexScavenger.collectDomainObject(domainObjectCollector, classInfo);
        JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, javaTypeCollector, classInfo.superName(), unindexedClasses);
        for (DotName interfaceDotName : classInfo.interfaceNames()) {
            JpaJandexScavenger.addClassHierarchyToReflectiveList(index, domainObjectCollector, enumTypeCollector, javaTypeCollector, interfaceDotName, unindexedClasses);
        }
    }

    private static void collectDomainObject(JpaEntitiesBuildItem domainObjectCollector, ClassInfo modelClass) {
        if (modelClass.classAnnotation(JPA_ENTITY) != null) {
            domainObjectCollector.addEntityClass(modelClass.name().toString());
        } else {
            domainObjectCollector.addModelClass(modelClass.name().toString());
        }
    }

    private static void collectEmbeddedTypes(Set<DotName> embeddedTypes, Type indexType) {
        switch (indexType.kind()) {
            case CLASS: {
                embeddedTypes.add(indexType.asClassType().name());
                break;
            }
            case PARAMETERIZED_TYPE: {
                embeddedTypes.add(indexType.name());
                for (Type typeArgument : indexType.asParameterizedType().arguments()) {
                    JpaJandexScavenger.collectEmbeddedTypes(embeddedTypes, typeArgument);
                }
                break;
            }
            case ARRAY: {
                JpaJandexScavenger.collectEmbeddedTypes(embeddedTypes, indexType.asArrayType().component());
                break;
            }
        }
    }

    private static boolean isIgnored(DotName classDotName) {
        String className = classDotName.toString();
        return className.startsWith("java.util.") || className.startsWith("java.lang.") || className.startsWith("org.hibernate.engine.spi.");
    }

    private static boolean isInJavaPackage(DotName classDotName) {
        String className = classDotName.toString();
        return className.startsWith("java.");
    }
}

