/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import java.util.Collection;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public final class PersistenceUnitDescriptorBuildItem
extends MultiBuildItem {
    private final ParsedPersistenceXmlDescriptor descriptor;
    private final String dataSource;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final String multiTenancySchemaDataSource;
    private final boolean isReactive;

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, boolean isReactive) {
        this.descriptor = descriptor;
        this.dataSource = "<default>";
        this.multiTenancyStrategy = MultiTenancyStrategy.NONE;
        this.multiTenancySchemaDataSource = null;
        this.isReactive = isReactive;
    }

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, MultiTenancyStrategy multiTenancyStrategy, String multiTenancySchemaDataSource, boolean isReactive) {
        this.descriptor = descriptor;
        this.dataSource = "<default>";
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.multiTenancySchemaDataSource = multiTenancySchemaDataSource;
        this.isReactive = isReactive;
    }

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, String dataSource, boolean isReactive) {
        this.descriptor = descriptor;
        this.dataSource = dataSource;
        this.multiTenancyStrategy = MultiTenancyStrategy.NONE;
        this.multiTenancySchemaDataSource = null;
        this.isReactive = isReactive;
    }

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, String dataSource, MultiTenancyStrategy multiTenancyStrategy, String multiTenancySchemaDataSource, boolean isReactive) {
        this.descriptor = descriptor;
        this.dataSource = dataSource;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.multiTenancySchemaDataSource = multiTenancySchemaDataSource;
        this.isReactive = isReactive;
    }

    public Collection<String> getManagedClassNames() {
        return this.descriptor.getManagedClassNames();
    }

    public String getExplicitSqlImportScriptResourceName() {
        return this.descriptor.getProperties().getProperty("javax.persistence.sql-load-script-source");
    }

    public String getPersistenceUnitName() {
        return this.descriptor.getName();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public MultiTenancyStrategy getMultiTenancyStrategy() {
        return this.multiTenancyStrategy;
    }

    public String getMultiTenancySchemaDataSource() {
        return this.multiTenancySchemaDataSource;
    }

    public QuarkusPersistenceUnitDefinition asOutputPersistenceUnitDefinition() {
        return new QuarkusPersistenceUnitDefinition((PersistenceUnitDescriptor)this.descriptor, this.dataSource, this.multiTenancyStrategy, this.isReactive);
    }
}

