/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;

@ConfigGroup
public class HibernateOrmConfigPersistenceUnit {
    public Optional<String> datasource;
    public Optional<Set<String>> packages;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDialect dialect;
    @ConfigItem(defaultValueDocumentation="import.sql in DEV, TEST ; no-file otherwise")
    public Optional<String> sqlLoadScript;
    @ConfigItem(defaultValue="-1")
    @Deprecated
    public int batchFetchSize;
    @ConfigItem
    @Deprecated
    public OptionalInt maxFetchDepth;
    @ConfigItem
    public Optional<String> physicalNamingStrategy;
    @ConfigItem
    public Optional<String> implicitNamingStrategy;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitQuery query;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDatabase database;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitJdbc jdbc;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitLog log;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitFetch fetch;
    public Map<String, HibernateOrmConfigPersistenceUnitCache> cache;
    @ConfigItem(defaultValue="true")
    public boolean secondLevelCachingEnabled;
    @ConfigItem
    public Optional<String> multitenant;
    @ConfigItem
    public Optional<String> multitenantSchemaDatasource;

    public boolean isAnyPropertySet() {
        return this.datasource.isPresent() || this.packages.isPresent() || this.dialect.isAnyPropertySet() || this.sqlLoadScript.isPresent() || this.batchFetchSize > 0 || this.maxFetchDepth.isPresent() || this.physicalNamingStrategy.isPresent() || this.implicitNamingStrategy.isPresent() || this.query.isAnyPropertySet() || this.database.isAnyPropertySet() || this.jdbc.isAnyPropertySet() || this.log.isAnyPropertySet() || !this.cache.isEmpty() || !this.secondLevelCachingEnabled || this.multitenant.isPresent() || this.multitenantSchemaDatasource.isPresent() || this.fetch.isAnyPropertySet();
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitFetch {
        @ConfigItem(defaultValue="-1")
        public int batchSize;
        @ConfigItem
        public OptionalInt maxDepth;

        public boolean isAnyPropertySet() {
            return this.batchSize > 0 || this.maxDepth.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCacheMemory {
        @ConfigItem
        public OptionalLong objectCount;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCacheExpiration {
        @ConfigItem
        public Optional<Duration> maxIdle;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCache {
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitCacheExpiration expiration;
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitCacheMemory memory;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitLog {
        @ConfigItem
        public boolean sql;
        @ConfigItem(defaultValue="true")
        public boolean formatSql;
        @ConfigItem(defaultValueDocumentation="depends on dialect")
        public Optional<Boolean> jdbcWarnings;

        public boolean isAnyPropertySet() {
            return this.sql || !this.formatSql || this.jdbcWarnings.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitJdbc {
        @ConfigItem
        public Optional<String> timezone;
        @ConfigItem
        public OptionalInt statementFetchSize;
        @ConfigItem
        public OptionalInt statementBatchSize;

        public boolean isAnyPropertySet() {
            return this.timezone.isPresent() || this.statementFetchSize.isPresent() || this.statementBatchSize.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDatabaseGeneration {
        @ConfigItem(name="<<parent>>", defaultValue="none")
        public String generation;
        @ConfigItem
        public boolean createSchemas;
        @ConfigItem
        public boolean haltOnError;

        public boolean isAnyPropertySet() {
            return !"none".equals(this.generation) || this.createSchemas || this.haltOnError;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDatabase {
        private static final String DEFAULT_CHARSET = "UTF-8";
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitDatabaseGeneration generation;
        @ConfigItem
        public Optional<String> defaultCatalog;
        @ConfigItem
        public Optional<String> defaultSchema;
        @ConfigItem(defaultValue="UTF-8")
        public Charset charset;
        @ConfigItem
        public boolean globallyQuotedIdentifiers;

        public boolean isAnyPropertySet() {
            return this.generation.isAnyPropertySet() || this.defaultCatalog.isPresent() || this.defaultSchema.isPresent() || !DEFAULT_CHARSET.equals(this.charset.name()) || this.globallyQuotedIdentifiers;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitQuery {
        @ConfigItem
        public Optional<String> queryPlanCacheMaxSize;
        @ConfigItem
        public Optional<String> defaultNullOrdering;

        public boolean isAnyPropertySet() {
            return this.queryPlanCacheMaxSize.isPresent() || this.defaultNullOrdering.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDialect {
        @ConfigItem(name="<<parent>>")
        public Optional<String> dialect;
        @ConfigItem
        public Optional<String> storageEngine;

        public boolean isAnyPropertySet() {
            return this.dialect.isPresent() || this.storageEngine.isPresent();
        }
    }
}

