/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.datasource.common.runtime.DatabaseKind;
import io.quarkus.deployment.configuration.ConfigurationError;
import java.util.Optional;

public final class Dialects {
    private Dialects() {
    }

    public static Optional<String> guessDialect(String resolvedDbKind) {
        if (DatabaseKind.isDB2((String)resolvedDbKind)) {
            return Optional.of("org.hibernate.dialect.DB297Dialect");
        }
        if (DatabaseKind.isPostgreSQL((String)resolvedDbKind)) {
            return Optional.of("io.quarkus.hibernate.orm.runtime.dialect.QuarkusPostgreSQL10Dialect");
        }
        if (DatabaseKind.isH2((String)resolvedDbKind)) {
            return Optional.of("io.quarkus.hibernate.orm.runtime.dialect.QuarkusH2Dialect");
        }
        if (DatabaseKind.isMariaDB((String)resolvedDbKind)) {
            return Optional.of("org.hibernate.dialect.MariaDB103Dialect");
        }
        if (DatabaseKind.isMySQL((String)resolvedDbKind)) {
            return Optional.of("org.hibernate.dialect.MySQL8Dialect");
        }
        if (DatabaseKind.isOracle((String)resolvedDbKind)) {
            return Optional.of("org.hibernate.dialect.Oracle12cDialect");
        }
        if (DatabaseKind.isDerby((String)resolvedDbKind)) {
            return Optional.of("org.hibernate.dialect.DerbyTenSevenDialect");
        }
        if (DatabaseKind.isMsSQL((String)resolvedDbKind)) {
            return Optional.of("org.hibernate.dialect.SQLServer2012Dialect");
        }
        String error = "Hibernate extension could not guess the dialect from the database kind '" + resolvedDbKind + "'. Add an explicit 'quarkus.hibernate-orm.dialect' property.";
        throw new ConfigurationError(error);
    }
}

