/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.boot.xml.RecordableXmlMapping;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationStaticDescriptor;
import java.util.Collection;
import java.util.List;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public final class PersistenceUnitDescriptorBuildItem
extends MultiBuildItem {
    private final ParsedPersistenceXmlDescriptor descriptor;
    private final String dataSource;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final String multiTenancySchemaDataSource;
    private final List<RecordableXmlMapping> xmlMappings;
    private final boolean isReactive;
    private final boolean fromPersistenceXml;

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, List<RecordableXmlMapping> xmlMappings, boolean isReactive, boolean fromPersistenceXml) {
        this(descriptor, "<default>", MultiTenancyStrategy.NONE, null, xmlMappings, isReactive, fromPersistenceXml);
    }

    public PersistenceUnitDescriptorBuildItem(ParsedPersistenceXmlDescriptor descriptor, String dataSource, MultiTenancyStrategy multiTenancyStrategy, String multiTenancySchemaDataSource, List<RecordableXmlMapping> xmlMappings, boolean isReactive, boolean fromPersistenceXml) {
        this.descriptor = descriptor;
        this.dataSource = dataSource;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.multiTenancySchemaDataSource = multiTenancySchemaDataSource;
        this.xmlMappings = xmlMappings;
        this.isReactive = isReactive;
        this.fromPersistenceXml = fromPersistenceXml;
    }

    public Collection<String> getManagedClassNames() {
        return this.descriptor.getManagedClassNames();
    }

    public String getExplicitSqlImportScriptResourceName() {
        return this.descriptor.getProperties().getProperty("javax.persistence.sql-load-script-source");
    }

    public String getPersistenceUnitName() {
        return this.descriptor.getName();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public MultiTenancyStrategy getMultiTenancyStrategy() {
        return this.multiTenancyStrategy;
    }

    public String getMultiTenancySchemaDataSource() {
        return this.multiTenancySchemaDataSource;
    }

    public boolean hasXmlMappings() {
        return !this.xmlMappings.isEmpty();
    }

    public QuarkusPersistenceUnitDefinition asOutputPersistenceUnitDefinition(List<HibernateOrmIntegrationStaticDescriptor> integrationStaticDescriptors) {
        return new QuarkusPersistenceUnitDefinition((PersistenceUnitDescriptor)this.descriptor, this.dataSource, this.multiTenancyStrategy, this.xmlMappings, this.isReactive, this.fromPersistenceXml, integrationStaticDescriptors);
    }
}

