/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;

@ConfigGroup
public class HibernateOrmConfigPersistenceUnit {
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> datasource;
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<Set<String>> packages;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDialect dialect;
    @ConfigItem(defaultValueDocumentation="import.sql in DEV, TEST ; no-file otherwise")
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<List<String>> sqlLoadScript;
    @ConfigItem(defaultValueDocumentation="16")
    @Deprecated
    public OptionalInt batchFetchSize;
    @ConfigItem
    @Deprecated
    public OptionalInt maxFetchDepth;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> physicalNamingStrategy;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> implicitNamingStrategy;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> metadataBuilderContributor;
    @ConfigItem(defaultValueDocumentation="META-INF/orm.xml if it exists; no-file otherwise")
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<Set<String>> mappingFiles;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitQuery query;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDatabase database;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitJdbc jdbc;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitFetch fetch;
    public Map<String, HibernateOrmConfigPersistenceUnitCache> cache;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDiscriminator discriminator;
    @ConfigItem(defaultValue="true")
    public boolean secondLevelCachingEnabled;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> multitenant;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> multitenantSchemaDatasource;
    @ConfigItem(defaultValue="true")
    public boolean validateInDevMode;

    public boolean isAnyPropertySet() {
        return this.datasource.isPresent() || this.packages.isPresent() || this.dialect.isAnyPropertySet() || this.sqlLoadScript.isPresent() || this.batchFetchSize.isPresent() || this.maxFetchDepth.isPresent() || this.physicalNamingStrategy.isPresent() || this.implicitNamingStrategy.isPresent() || this.metadataBuilderContributor.isPresent() || this.query.isAnyPropertySet() || this.database.isAnyPropertySet() || this.jdbc.isAnyPropertySet() || !this.cache.isEmpty() || !this.secondLevelCachingEnabled || this.multitenant.isPresent() || this.multitenantSchemaDatasource.isPresent() || this.fetch.isAnyPropertySet() || this.discriminator.isAnyPropertySet();
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDiscriminator {
        @ConfigItem
        public boolean ignoreExplicitForJoined;

        public boolean isAnyPropertySet() {
            return this.ignoreExplicitForJoined;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitFetch {
        @ConfigItem(defaultValueDocumentation="16")
        public OptionalInt batchSize;
        @ConfigItem
        public OptionalInt maxDepth;

        public boolean isAnyPropertySet() {
            return this.batchSize.isPresent() || this.maxDepth.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCacheMemory {
        @ConfigItem
        public OptionalLong objectCount;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCacheExpiration {
        @ConfigItem
        public Optional<Duration> maxIdle;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCache {
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitCacheExpiration expiration;
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitCacheMemory memory;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitJdbc {
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> timezone;
        @ConfigItem
        public OptionalInt statementFetchSize;
        @ConfigItem
        public OptionalInt statementBatchSize;

        public boolean isAnyPropertySet() {
            return this.timezone.isPresent() || this.statementFetchSize.isPresent() || this.statementBatchSize.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDatabase {
        private static final String DEFAULT_CHARSET = "UTF-8";
        @ConfigItem(defaultValue="UTF-8")
        public Charset charset;
        @ConfigItem
        public boolean globallyQuotedIdentifiers;

        public boolean isAnyPropertySet() {
            return !DEFAULT_CHARSET.equals(this.charset.name()) || this.globallyQuotedIdentifiers;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitQuery {
        private static final int DEFAULT_QUERY_PLAN_CACHE_MAX_SIZE = 2048;
        @ConfigItem(defaultValue="2048")
        public int queryPlanCacheMaxSize;
        @ConfigItem(defaultValue="none")
        public NullOrdering defaultNullOrdering;

        public boolean isAnyPropertySet() {
            return this.queryPlanCacheMaxSize != 2048 || this.defaultNullOrdering != NullOrdering.NONE;
        }

        public static enum NullOrdering {
            NONE,
            FIRST,
            LAST;

        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDialect {
        @ConfigItem(name="<<parent>>")
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> dialect;
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> storageEngine;

        public boolean isAnyPropertySet() {
            return this.dialect.isPresent() || this.storageEngine.isPresent();
        }
    }
}

