/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;

@ConfigGroup
public class HibernateOrmConfigPersistenceUnit {
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> datasource;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<Set<String>> packages;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDialect dialect;
    @ConfigItem(defaultValueDocumentation="import.sql in DEV, TEST ; no-file otherwise")
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<List<String>> sqlLoadScript;
    @ConfigItem(defaultValueDocumentation="16")
    @Deprecated
    public OptionalInt batchFetchSize;
    @ConfigItem
    @Deprecated
    public OptionalInt maxFetchDepth;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> physicalNamingStrategy;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> implicitNamingStrategy;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> metadataBuilderContributor;
    @ConfigItem(defaultValueDocumentation="META-INF/orm.xml if it exists; no-file otherwise")
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<Set<String>> mappingFiles;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitMapping mapping;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitQuery query;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDatabase database;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitJdbc jdbc;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitFetch fetch;
    @ConfigItem
    public Map<String, HibernateOrmConfigPersistenceUnitCache> cache;
    @ConfigItem
    public HibernateOrmConfigPersistenceUnitDiscriminator discriminator;
    @ConfigItem(defaultValue="none")
    public HibernateOrmConfigPersistenceUnitQuoteIdentifiers quoteIdentifiers;
    @ConfigItem(defaultValue="true")
    public boolean secondLevelCachingEnabled;
    @ConfigItem
    public HibernateOrmConfigPersistenceValidation validation;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> multitenant;
    @ConfigItem
    @ConvertWith(value=TrimmedStringConverter.class)
    public Optional<String> multitenantSchemaDatasource;
    @ConfigItem(defaultValue="true")
    public boolean validateInDevMode;
    @ConfigItem(generateDocumentation=false)
    public Map<String, String> unsupportedProperties = new HashMap<String, String>();

    public boolean isAnyPropertySet() {
        return this.datasource.isPresent() || this.packages.isPresent() || this.dialect.isAnyPropertySet() || this.sqlLoadScript.isPresent() || this.batchFetchSize.isPresent() || this.maxFetchDepth.isPresent() || this.physicalNamingStrategy.isPresent() || this.implicitNamingStrategy.isPresent() || this.metadataBuilderContributor.isPresent() || this.mapping.isAnyPropertySet() || this.query.isAnyPropertySet() || this.database.isAnyPropertySet() || this.jdbc.isAnyPropertySet() || !this.cache.isEmpty() || !this.secondLevelCachingEnabled || this.multitenant.isPresent() || this.multitenantSchemaDatasource.isPresent() || this.fetch.isAnyPropertySet() || this.discriminator.isAnyPropertySet() || this.quoteIdentifiers.isAnyPropertySet() || !this.unsupportedProperties.isEmpty();
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDialect {
        @ConfigItem(name="<<parent>>", defaultValueDocumentation="selected automatically for most popular databases")
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> dialect;
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> storageEngine;

        public boolean isAnyPropertySet() {
            return this.dialect.isPresent() || this.storageEngine.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitMapping {
        @ConfigItem
        public Timezone timezone;
        @ConfigItem
        public Id id;

        public boolean isAnyPropertySet() {
            return this.timezone.timeZoneDefaultStorage.isPresent() || this.id.optimizer.idOptimizerDefault.isPresent();
        }

        @ConfigGroup
        public static class Timezone {
            @ConfigItem(name="default-storage", defaultValueDocumentation="default")
            public Optional<TimeZoneStorageType> timeZoneDefaultStorage;
        }

        @ConfigGroup
        public static class Id {
            @ConfigItem
            public Optimizer optimizer;

            @ConfigGroup
            public static class Optimizer {
                @ConfigItem(name="default", defaultValueDocumentation="pooled-lo")
                public Optional<IdOptimizerType> idOptimizerDefault;
            }
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitQuery {
        private static final int DEFAULT_QUERY_PLAN_CACHE_MAX_SIZE = 2048;
        @ConfigItem(defaultValue="2048")
        public int queryPlanCacheMaxSize;
        @ConfigItem(defaultValue="none")
        public NullOrdering defaultNullOrdering;
        @ConfigItem(defaultValue="true")
        public boolean inClauseParameterPadding;

        public boolean isAnyPropertySet() {
            return this.queryPlanCacheMaxSize != 2048 || this.defaultNullOrdering != NullOrdering.NONE || !this.inClauseParameterPadding;
        }

        public static enum NullOrdering {
            NONE,
            FIRST,
            LAST;

        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDatabase {
        private static final String DEFAULT_CHARSET = "UTF-8";
        @ConfigItem(defaultValue="UTF-8")
        public Charset charset;
        @ConfigItem
        @Deprecated
        public boolean globallyQuotedIdentifiers;

        public boolean isAnyPropertySet() {
            return !DEFAULT_CHARSET.equals(this.charset.name()) || this.globallyQuotedIdentifiers;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitJdbc {
        @ConfigItem
        @ConvertWith(value=TrimmedStringConverter.class)
        public Optional<String> timezone;
        @ConfigItem
        public OptionalInt statementFetchSize;
        @ConfigItem
        public OptionalInt statementBatchSize;

        public boolean isAnyPropertySet() {
            return this.timezone.isPresent() || this.statementFetchSize.isPresent() || this.statementBatchSize.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitFetch {
        @ConfigItem(defaultValueDocumentation="16")
        public OptionalInt batchSize;
        @ConfigItem
        public OptionalInt maxDepth;

        public boolean isAnyPropertySet() {
            return this.batchSize.isPresent() || this.maxDepth.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitDiscriminator {
        @ConfigItem
        public boolean ignoreExplicitForJoined;

        public boolean isAnyPropertySet() {
            return this.ignoreExplicitForJoined;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitQuoteIdentifiers {
        @ConfigItem(defaultValue="none")
        public IdentifierQuotingStrategy strategy;

        public boolean isAnyPropertySet() {
            return this.strategy != IdentifierQuotingStrategy.NONE;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceValidation {
        @ConfigItem(defaultValue="true")
        public boolean enabled;
    }

    public static enum IdentifierQuotingStrategy {
        NONE,
        ALL,
        ALL_EXCEPT_COLUMN_DEFINITIONS,
        ONLY_KEYWORDS;

    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCacheMemory {
        @ConfigItem
        public OptionalLong objectCount;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCacheExpiration {
        @ConfigItem
        public Optional<Duration> maxIdle;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceUnitCache {
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitCacheExpiration expiration;
        @ConfigItem
        public HibernateOrmConfigPersistenceUnitCacheMemory memory;
    }

    public static enum IdOptimizerType {
        POOLED_LO(StandardOptimizerDescriptor.POOLED_LO),
        POOLED(StandardOptimizerDescriptor.POOLED),
        NONE(StandardOptimizerDescriptor.NONE);

        public final String configName;

        private IdOptimizerType(StandardOptimizerDescriptor delegate) {
            this.configName = delegate.getExternalName();
        }
    }
}

