/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.panache.common.runtime.NamedQueryUtil;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.exception.PanacheQueryException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public abstract class AbstractJpaOperations<PanacheQueryType> {
    protected abstract PanacheQueryType createPanacheQuery(EntityManager var1, String var2, String var3, Object var4);

    protected abstract List<?> list(PanacheQueryType var1);

    protected abstract Stream<?> stream(PanacheQueryType var1);

    public void persist(Object entity) {
        EntityManager em = this.getEntityManager();
        this.persist(em, entity);
    }

    public void persist(EntityManager em, Object entity) {
        if (!em.contains(entity)) {
            em.persist(entity);
        }
    }

    public void persist(Iterable<?> entities) {
        EntityManager em = this.getEntityManager();
        for (Object entity : entities) {
            this.persist(em, entity);
        }
    }

    public void persist(Object firstEntity, Object ... entities) {
        EntityManager em = this.getEntityManager();
        this.persist(firstEntity);
        for (Object entity : entities) {
            this.persist(em, entity);
        }
    }

    public void persist(Stream<?> entities) {
        EntityManager em = this.getEntityManager();
        entities.forEach(entity -> this.persist(em, entity));
    }

    public void delete(Object entity) {
        EntityManager em = this.getEntityManager();
        em.remove(entity);
    }

    public boolean isPersistent(Object entity) {
        return this.getEntityManager().contains(entity);
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public EntityManager getEntityManager() {
        EntityManager entityManager = (EntityManager)Arc.container().instance(EntityManager.class, new Annotation[0]).get();
        if (entityManager == null) {
            throw new PersistenceException("No EntityManager found. Do you have any JPA entities defined?");
        }
        return entityManager;
    }

    public TransactionManager getTransactionManager() {
        return (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
    }

    public static Query bindParameters(Query query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static Query bindParameters(Query query, Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return query;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    public int paramCount(Object[] params) {
        return params != null ? params.length : 0;
    }

    public int paramCount(Map<String, Object> params) {
        return params != null ? params.size() : 0;
    }

    private String getEntityName(Class<?> entityClass) {
        return entityClass.getName();
    }

    public String createFindQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "FROM " + this.getEntityName(entityClass);
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            return "FROM " + this.getEntityName(entityClass);
        }
        if (AbstractJpaOperations.isNamedQuery(query)) {
            return query;
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("from ") || trimmedLc.startsWith("select ")) {
            return query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "FROM " + this.getEntityName(entityClass) + " " + query;
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = query + " = ?1";
        }
        return "FROM " + this.getEntityName(entityClass) + " WHERE " + query;
    }

    static boolean isNamedQuery(String query) {
        if (query == null || query.isEmpty()) {
            return false;
        }
        return query.charAt(0) == '#';
    }

    private String createCountQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "SELECT COUNT(*) FROM " + this.getEntityName(entityClass);
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            return "SELECT COUNT(*) FROM " + this.getEntityName(entityClass);
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("from ")) {
            return "SELECT COUNT(*) " + query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "SELECT COUNT(*) FROM " + this.getEntityName(entityClass);
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = query + " = ?1";
        }
        return "SELECT COUNT(*) FROM " + this.getEntityName(entityClass) + " WHERE " + query;
    }

    private String createUpdateQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            throw new PanacheQueryException("Query string cannot be null");
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            throw new PanacheQueryException("Query string cannot be empty");
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("update ")) {
            return query;
        }
        if (trimmedLc.startsWith("from ")) {
            return "UPDATE " + query;
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = query + " = ?1";
        }
        if (trimmedLc.startsWith("set ")) {
            return "UPDATE FROM " + this.getEntityName(entityClass) + " " + query;
        }
        return "UPDATE FROM " + this.getEntityName(entityClass) + " SET " + query;
    }

    private String createDeleteQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "DELETE FROM " + this.getEntityName(entityClass);
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            return "DELETE FROM " + this.getEntityName(entityClass);
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("from ")) {
            return "DELETE " + query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "DELETE FROM " + this.getEntityName(entityClass);
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = query + " = ?1";
        }
        return "DELETE FROM " + this.getEntityName(entityClass) + " WHERE " + query;
    }

    public String toOrderBy(Sort sort) {
        if (sort == null) {
            return null;
        }
        if (sort.getColumns().size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        for (int i = 0; i < sort.getColumns().size(); ++i) {
            Sort.Column column = (Sort.Column)sort.getColumns().get(i);
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append(column.getName());
            if (column.getDirection() == Sort.Direction.Ascending) continue;
            sb.append(" DESC");
        }
        return sb.toString();
    }

    public Object findById(Class<?> entityClass, Object id) {
        return this.getEntityManager().find(entityClass, id);
    }

    public Object findById(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return this.getEntityManager().find(entityClass, id, lockModeType);
    }

    public Optional<?> findByIdOptional(Class<?> entityClass, Object id) {
        return Optional.ofNullable(this.findById(entityClass, id));
    }

    public Optional<?> findByIdOptional(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return Optional.ofNullable(this.findById(entityClass, id, lockModeType));
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String findQuery = this.createFindQuery(entityClass, query, this.paramCount(params));
        EntityManager em = this.getEntityManager();
        if (AbstractJpaOperations.isNamedQuery(query)) {
            String namedQuery = query.substring(1);
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(em, query, this.toOrderBy(sort), params);
        }
        return this.createPanacheQuery(em, findQuery, this.toOrderBy(sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String findQuery = this.createFindQuery(entityClass, query, this.paramCount(params));
        EntityManager em = this.getEntityManager();
        if (AbstractJpaOperations.isNamedQuery(query)) {
            String namedQuery = query.substring(1);
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(em, query, this.toOrderBy(sort), params);
        }
        return this.createPanacheQuery(em, findQuery, this.toOrderBy(sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Parameters params) {
        return this.find(entityClass, query, (Sort)null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.find(entityClass, query, sort, params.map());
    }

    public List<?> list(Class<?> entityClass, String query, Object ... params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public List<?> list(Class<?> entityClass, String query, Parameters params) {
        return this.list(this.find(entityClass, query, params));
    }

    public List<?> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Object ... params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Parameters params) {
        return this.stream(this.find(entityClass, query, params));
    }

    public Stream<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, query, sort, params));
    }

    public PanacheQueryType findAll(Class<?> entityClass) {
        String query = "FROM " + this.getEntityName(entityClass);
        EntityManager em = this.getEntityManager();
        return this.createPanacheQuery(em, query, null, null);
    }

    public PanacheQueryType findAll(Class<?> entityClass, Sort sort) {
        String query = "FROM " + this.getEntityName(entityClass);
        EntityManager em = this.getEntityManager();
        return this.createPanacheQuery(em, query, this.toOrderBy(sort), null);
    }

    public List<?> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public List<?> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Stream<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Stream<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public long count(Class<?> entityClass) {
        return (Long)this.getEntityManager().createQuery("SELECT COUNT(*) FROM " + this.getEntityName(entityClass)).getSingleResult();
    }

    public long count(Class<?> entityClass, String query, Object ... params) {
        return (Long)AbstractJpaOperations.bindParameters(this.getEntityManager().createQuery(this.createCountQuery(entityClass, query, this.paramCount(params))), params).getSingleResult();
    }

    public long count(Class<?> entityClass, String query, Map<String, Object> params) {
        return (Long)AbstractJpaOperations.bindParameters(this.getEntityManager().createQuery(this.createCountQuery(entityClass, query, this.paramCount(params))), params).getSingleResult();
    }

    public long count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    public boolean exists(Class<?> entityClass) {
        return this.count(entityClass) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Object ... params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public long deleteAll(Class<?> entityClass) {
        return this.getEntityManager().createQuery("DELETE FROM " + this.getEntityName(entityClass)).executeUpdate();
    }

    public boolean deleteById(Class<?> entityClass, Object id) {
        Object entity = this.findById(entityClass, id);
        if (entity == null) {
            return false;
        }
        this.getEntityManager().remove(entity);
        return true;
    }

    public long delete(Class<?> entityClass, String query, Object ... params) {
        return AbstractJpaOperations.bindParameters(this.getEntityManager().createQuery(this.createDeleteQuery(entityClass, query, this.paramCount(params))), params).executeUpdate();
    }

    public long delete(Class<?> entityClass, String query, Map<String, Object> params) {
        return AbstractJpaOperations.bindParameters(this.getEntityManager().createQuery(this.createDeleteQuery(entityClass, query, this.paramCount(params))), params).executeUpdate();
    }

    public long delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses: did you forget to annotate your entity with @Entity?");
    }

    public int executeUpdate(String query, Object ... params) {
        Query jpaQuery = this.getEntityManager().createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public int executeUpdate(String query, Map<String, Object> params) {
        Query jpaQuery = this.getEntityManager().createQuery(query);
        AbstractJpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public int executeUpdate(Class<?> entityClass, String query, Object ... params) {
        String updateQuery = this.createUpdateQuery(entityClass, query, this.paramCount(params));
        return this.executeUpdate(updateQuery, params);
    }

    public int executeUpdate(Class<?> entityClass, String query, Map<String, Object> params) {
        String updateQuery = this.createUpdateQuery(entityClass, query, this.paramCount(params));
        return this.executeUpdate(updateQuery, params);
    }

    public int update(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public int update(Class<?> entityClass, String query, Parameters params) {
        return this.update(entityClass, query, params.map());
    }

    public int update(Class<?> entityClass, String query, Object ... params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public void setRollbackOnly() {
        try {
            this.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }
}

