/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.common.runtime;

import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Range;
import io.quarkus.panache.common.exception.PanacheQueryException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.hibernate.engine.spi.RowSelection;

public class CommonPanacheQueryImpl<Entity> {
    static final Pattern SELECT_PATTERN = Pattern.compile("^\\s*SELECT\\s+((?:DISTINCT\\s+)?\\w+(?:\\.\\w+)*)(?:\\s+AS\\s+\\w+)?(\\s*,\\s*\\w+(?:\\.\\w+)*(?:\\s+AS\\s+\\w+)?)*\\s+(.*)", 34);
    static final Pattern FROM_PATTERN = Pattern.compile("^\\s*FROM\\s+.*", 34);
    private static final NonThrowingCloseable NO_FILTERS = new NonThrowingCloseable(){

        @Override
        public void close() {
        }
    };
    private Object paramsArrayOrMap;
    private String query;
    protected String countQuery;
    private String orderBy;
    private EntityManager em;
    private Page page;
    private Long count;
    private Range range;
    private LockModeType lockModeType;
    private Map<String, Object> hints;
    private Map<String, Map<String, Object>> filters;

    public CommonPanacheQueryImpl(EntityManager em, String query, String orderBy, Object paramsArrayOrMap) {
        this.em = em;
        this.query = query;
        this.orderBy = orderBy;
        this.paramsArrayOrMap = paramsArrayOrMap;
    }

    private CommonPanacheQueryImpl(CommonPanacheQueryImpl<?> previousQuery, String newQueryString, String countQuery) {
        this.em = previousQuery.em;
        this.query = newQueryString;
        this.countQuery = countQuery;
        this.orderBy = previousQuery.orderBy;
        this.paramsArrayOrMap = previousQuery.paramsArrayOrMap;
        this.page = previousQuery.page;
        this.count = previousQuery.count;
        this.range = previousQuery.range;
        this.lockModeType = previousQuery.lockModeType;
        this.hints = previousQuery.hints;
        this.filters = previousQuery.filters;
    }

    public <T> CommonPanacheQueryImpl<T> project(Class<T> type) {
        if (AbstractJpaOperations.isNamedQuery(this.query)) {
            throw new PanacheQueryException("Unable to perform a projection on a named query");
        }
        Constructor<?> constructor = type.getDeclaredConstructors()[0];
        StringBuilder select = new StringBuilder("SELECT new ").append(type.getName()).append(" (");
        int selectInitialLength = select.length();
        for (Parameter parameter : constructor.getParameters()) {
            if (!parameter.isNamePresent()) {
                throw new PanacheQueryException("Your application must be built with parameter names, this should be the default if using Quarkus artifacts. Check the maven or gradle compiler configuration to include '-parameters'.");
            }
            if (select.length() > selectInitialLength) {
                select.append(", ");
            }
            select.append(parameter.getName());
        }
        select.append(") ");
        return new CommonPanacheQueryImpl<Entity>(this, select.toString() + this.query, "select count(*) " + this.query);
    }

    public void filter(String filterName, Map<String, Object> parameters) {
        if (this.filters == null) {
            this.filters = new HashMap<String, Map<String, Object>>();
        }
        this.filters.put(filterName, parameters);
    }

    public void page(Page page) {
        this.page = page;
        this.range = null;
    }

    public void page(int pageIndex, int pageSize) {
        this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    public void nextPage() {
        this.checkPagination();
        this.page(this.page.next());
    }

    public void previousPage() {
        this.checkPagination();
        this.page(this.page.previous());
    }

    public void firstPage() {
        this.checkPagination();
        this.page(this.page.first());
    }

    public void lastPage() {
        this.checkPagination();
        this.page(this.page.index(this.pageCount() - 1));
    }

    public boolean hasNextPage() {
        this.checkPagination();
        return this.page.index < this.pageCount() - 1;
    }

    public boolean hasPreviousPage() {
        this.checkPagination();
        return this.page.index > 0;
    }

    public int pageCount() {
        this.checkPagination();
        long count = this.count();
        if (count == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)count / (double)this.page.size);
    }

    public Page page() {
        this.checkPagination();
        return this.page;
    }

    private void checkPagination() {
        if (this.page == null) {
            throw new UnsupportedOperationException("Cannot call a page related method, call page(Page) or page(int, int) to initiate pagination first");
        }
        if (this.range != null) {
            throw new UnsupportedOperationException("Cannot call a page related method in a ranged query, call page(Page) or page(int, int) to initiate pagination first");
        }
    }

    public void range(int startIndex, int lastIndex) {
        this.range = Range.of((int)startIndex, (int)lastIndex);
        this.page = null;
    }

    public void withLock(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public void withHint(String hintName, Object value) {
        if (this.hints == null) {
            this.hints = new HashMap<String, Object>();
        }
        this.hints.put(hintName, value);
    }

    public long count() {
        if (this.count == null) {
            String selectQuery = this.query;
            if (AbstractJpaOperations.isNamedQuery(this.query)) {
                org.hibernate.query.Query q = (org.hibernate.query.Query)this.em.createNamedQuery(this.query.substring(1));
                selectQuery = q.getQueryString();
            }
            Query countQuery = this.em.createQuery(this.countQuery(selectQuery));
            if (this.paramsArrayOrMap instanceof Map) {
                AbstractJpaOperations.bindParameters(countQuery, (Map)this.paramsArrayOrMap);
            } else {
                AbstractJpaOperations.bindParameters(countQuery, (Object[])this.paramsArrayOrMap);
            }
            try (NonThrowingCloseable c = this.applyFilters();){
                this.count = (Long)countQuery.getSingleResult();
            }
        }
        return this.count;
    }

    private String countQuery(String selectQuery) {
        String countQuery;
        if (this.countQuery != null) {
            return this.countQuery;
        }
        Matcher selectMatcher = SELECT_PATTERN.matcher(selectQuery);
        if (selectMatcher.matches()) {
            String firstSelection = selectMatcher.group(1).trim();
            if (firstSelection.toLowerCase().startsWith("distinct ")) {
                String secondSelection = selectMatcher.group(2);
                if (secondSelection != null && !secondSelection.trim().isEmpty()) {
                    throw new PanacheQueryException("Count query not supported for select query: " + selectQuery);
                }
                countQuery = "SELECT COUNT(" + firstSelection + ") " + selectMatcher.group(3);
            } else {
                countQuery = "SELECT COUNT(*) " + selectMatcher.group(3);
            }
        } else if (FROM_PATTERN.matcher(selectQuery).matches()) {
            countQuery = "SELECT COUNT(*) " + selectQuery;
        } else {
            throw new PanacheQueryException("Count query not supported for select query: " + selectQuery);
        }
        String lcQuery = countQuery.toLowerCase();
        int orderByIndex = lcQuery.lastIndexOf(" order by ");
        if (orderByIndex != -1) {
            countQuery = countQuery.substring(0, orderByIndex);
        }
        return countQuery;
    }

    public <T extends Entity> List<T> list() {
        Query jpaQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            List list = jpaQuery.getResultList();
            return list;
        }
    }

    public <T extends Entity> Stream<T> stream() {
        Query jpaQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            Stream stream = jpaQuery.getResultStream();
            return stream;
        }
    }

    public <T extends Entity> T firstResult() {
        Query jpaQuery = this.createQuery(1);
        try (NonThrowingCloseable c = this.applyFilters();){
            List list = jpaQuery.getResultList();
            T t = list.isEmpty() ? null : (T)list.get(0);
            return t;
        }
    }

    public <T extends Entity> Optional<T> firstResultOptional() {
        return Optional.ofNullable(this.firstResult());
    }

    public <T extends Entity> T singleResult() {
        Query jpaQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            Object object = jpaQuery.getSingleResult();
            return (T)object;
        }
    }

    public <T extends Entity> Optional<T> singleResultOptional() {
        Query jpaQuery = this.createQuery(2);
        try (NonThrowingCloseable c = this.applyFilters();){
            List list = jpaQuery.getResultList();
            if (list.size() > 1) {
                throw new NonUniqueResultException();
            }
            Optional optional = list.isEmpty() ? Optional.empty() : Optional.of(list.get(0));
            return optional;
        }
    }

    private Query createQuery() {
        Query jpaQuery = this.createBaseQuery();
        if (this.range != null) {
            jpaQuery.setFirstResult(this.range.getStartIndex());
            jpaQuery.setMaxResults(this.range.getLastIndex() - this.range.getStartIndex() + 1);
        } else if (this.page != null) {
            jpaQuery.setFirstResult(this.page.index * this.page.size);
            jpaQuery.setMaxResults(this.page.size);
        } else {
            RowSelection options = ((org.hibernate.query.Query)jpaQuery.unwrap(org.hibernate.query.Query.class)).getQueryOptions();
            options.setFirstRow(null);
            options.setMaxRows(null);
        }
        return jpaQuery;
    }

    private Query createQuery(int maxResults) {
        Query jpaQuery = this.createBaseQuery();
        if (this.range != null) {
            jpaQuery.setFirstResult(this.range.getStartIndex());
        } else if (this.page != null) {
            jpaQuery.setFirstResult(this.page.index * this.page.size);
        } else {
            RowSelection options = ((org.hibernate.query.Query)jpaQuery.unwrap(org.hibernate.query.Query.class)).getQueryOptions();
            options.setFirstRow(null);
        }
        jpaQuery.setMaxResults(maxResults);
        return jpaQuery;
    }

    private Query createBaseQuery() {
        Query jpaQuery;
        if (AbstractJpaOperations.isNamedQuery(this.query)) {
            String namedQuery = this.query.substring(1);
            jpaQuery = this.em.createNamedQuery(namedQuery);
        } else {
            jpaQuery = this.em.createQuery(this.orderBy != null ? this.query + this.orderBy : this.query);
        }
        if (this.paramsArrayOrMap instanceof Map) {
            AbstractJpaOperations.bindParameters(jpaQuery, (Map)this.paramsArrayOrMap);
        } else {
            AbstractJpaOperations.bindParameters(jpaQuery, (Object[])this.paramsArrayOrMap);
        }
        if (this.lockModeType != null) {
            jpaQuery.setLockMode(this.lockModeType);
        }
        if (this.hints != null) {
            for (Map.Entry<String, Object> hint : this.hints.entrySet()) {
                jpaQuery.setHint(hint.getKey(), hint.getValue());
            }
        }
        return jpaQuery;
    }

    private NonThrowingCloseable applyFilters() {
        if (this.filters == null) {
            return NO_FILTERS;
        }
        final Session session = (Session)this.em.unwrap(Session.class);
        for (Map.Entry<String, Map<String, Object>> entry : this.filters.entrySet()) {
            Filter filter = session.enableFilter(entry.getKey());
            for (Map.Entry<String, Object> paramEntry : entry.getValue().entrySet()) {
                filter.setParameter(paramEntry.getKey(), paramEntry.getValue());
            }
            filter.validate();
        }
        return new NonThrowingCloseable(){

            @Override
            public void close() {
                for (Map.Entry entry : CommonPanacheQueryImpl.this.filters.entrySet()) {
                    session.disableFilter((String)entry.getKey());
                }
            }
        };
    }

    private static interface NonThrowingCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

