/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.common.runtime;

import io.quarkus.hibernate.orm.panache.common.NestedProjectedClass;
import io.quarkus.hibernate.orm.panache.common.ProjectedFieldName;
import io.quarkus.hibernate.orm.panache.common.runtime.AbstractJpaOperations;
import io.quarkus.hibernate.orm.panache.common.runtime.NamedQueryUtil;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Range;
import io.quarkus.panache.common.exception.PanacheQueryException;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import jakarta.persistence.LockModeType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.spi.SqmQuery;

public class CommonPanacheQueryImpl<Entity> {
    private static final NonThrowingCloseable NO_FILTERS = new NonThrowingCloseable(){

        @Override
        public void close() {
        }
    };
    private Object paramsArrayOrMap;
    private String query;
    private String originalQuery;
    protected String customCountQueryForSpring;
    private String orderBy;
    private Session session;
    private Page page;
    private Long count;
    private Range range;
    private LockModeType lockModeType;
    private Map<String, Object> hints;
    private Map<String, Map<String, Object>> filters;
    private Class<?> projectionType;

    public CommonPanacheQueryImpl(Session session, String query, String originalQuery, String orderBy, Object paramsArrayOrMap) {
        this.session = session;
        this.query = query;
        this.originalQuery = originalQuery;
        this.orderBy = orderBy;
        this.paramsArrayOrMap = paramsArrayOrMap;
    }

    private CommonPanacheQueryImpl(CommonPanacheQueryImpl<?> previousQuery, String newQueryString, String customCountQueryForSpring, Class<?> projectionType) {
        this.session = previousQuery.session;
        this.query = newQueryString;
        this.customCountQueryForSpring = customCountQueryForSpring;
        this.orderBy = previousQuery.orderBy;
        this.paramsArrayOrMap = previousQuery.paramsArrayOrMap;
        this.page = previousQuery.page;
        this.count = previousQuery.count;
        this.range = previousQuery.range;
        this.lockModeType = previousQuery.lockModeType;
        this.hints = previousQuery.hints;
        this.filters = previousQuery.filters;
        this.projectionType = projectionType;
    }

    public <T> CommonPanacheQueryImpl<T> project(Class<T> type) {
        String lowerCasedTrimmedQuery;
        String selectQuery = this.query;
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            SelectionQuery q = this.session.createNamedSelectionQuery(this.query.substring(1));
            selectQuery = CommonPanacheQueryImpl.getQueryString(q);
        }
        if ((lowerCasedTrimmedQuery = PanacheJpaUtil.trimForAnalysis((String)selectQuery)).startsWith("select new ") || lowerCasedTrimmedQuery.startsWith("select distinct new ")) {
            throw new PanacheQueryException("Unable to perform a projection on a 'select [distinct]? new' query: " + this.query);
        }
        if (lowerCasedTrimmedQuery.startsWith("select ")) {
            return new CommonPanacheQueryImpl<Entity>(this, this.query, this.customCountQueryForSpring, type);
        }
        String selectClause = "SELECT " + this.getParametersFromClass(type, null);
        return new CommonPanacheQueryImpl<Entity>(this, selectClause + selectQuery, this.customCountQueryForSpring, null);
    }

    private StringBuilder getParametersFromClass(Class<?> type, String parentParameter) {
        StringBuilder selectClause = new StringBuilder();
        Constructor<?> constructor = this.getConstructor(type);
        selectClause.append("new ").append(type.getName()).append(" (");
        String parametersListStr = Stream.of(constructor.getParameters()).map(parameter -> this.getParameterName(type, parentParameter, (Parameter)parameter)).collect(Collectors.joining(","));
        selectClause.append(parametersListStr);
        selectClause.append(") ");
        return selectClause;
    }

    private Constructor<?> getConstructor(Class<?> type) {
        return type.getDeclaredConstructors()[0];
    }

    private String getParameterName(Class<?> parentType, String parentParameter, Parameter parameter) {
        String parameterName;
        if (this.hasProjectedFieldName(parameter)) {
            parameterName = this.getNameFromProjectedFieldName(parameter);
        } else {
            if (!parameter.isNamePresent()) {
                throw new PanacheQueryException("Your application must be built with parameter names, this should be the default if using Quarkus project generation. Check the Maven or Gradle compiler configuration to include '-parameters'.");
            }
            try {
                Field field = parentType.getDeclaredField(parameter.getName());
                parameterName = this.hasProjectedFieldName(field) ? this.getNameFromProjectedFieldName(field) : parameter.getName();
            }
            catch (NoSuchFieldException e) {
                parameterName = parameter.getName();
            }
        }
        String string = parameterName = parentParameter == null ? parameterName : parentParameter.concat(".").concat(parameterName);
        if (parameter.getType().isAnnotationPresent(NestedProjectedClass.class)) {
            Class<?> nestedType = parameter.getType();
            return this.getParametersFromClass(nestedType, parameterName).toString();
        }
        return parameterName;
    }

    private boolean hasProjectedFieldName(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(ProjectedFieldName.class);
    }

    private String getNameFromProjectedFieldName(AnnotatedElement annotatedElement) {
        String name = annotatedElement.getAnnotation(ProjectedFieldName.class).value();
        if (name.isEmpty()) {
            throw new PanacheQueryException("The annotation ProjectedFieldName must have a non-empty value.");
        }
        return name;
    }

    public void filter(String filterName, Map<String, Object> parameters) {
        if (this.filters == null) {
            this.filters = new HashMap<String, Map<String, Object>>();
        }
        this.filters.put(filterName, parameters);
    }

    public void page(Page page) {
        this.page = page;
        this.range = null;
    }

    public void page(int pageIndex, int pageSize) {
        this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    public void nextPage() {
        this.checkPagination();
        this.page(this.page.next());
    }

    public void previousPage() {
        this.checkPagination();
        this.page(this.page.previous());
    }

    public void firstPage() {
        this.checkPagination();
        this.page(this.page.first());
    }

    public void lastPage() {
        this.checkPagination();
        this.page(this.page.index(this.pageCount() - 1));
    }

    public boolean hasNextPage() {
        this.checkPagination();
        return this.page.index < this.pageCount() - 1;
    }

    public boolean hasPreviousPage() {
        this.checkPagination();
        return this.page.index > 0;
    }

    public int pageCount() {
        this.checkPagination();
        long count = this.count();
        if (count == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)count / (double)this.page.size);
    }

    public Page page() {
        this.checkPagination();
        return this.page;
    }

    private void checkPagination() {
        if (this.page == null) {
            throw new UnsupportedOperationException("Cannot call a page related method, call page(Page) or page(int, int) to initiate pagination first");
        }
        if (this.range != null) {
            throw new UnsupportedOperationException("Cannot call a page related method in a ranged query, call page(Page) or page(int, int) to initiate pagination first");
        }
    }

    public void range(int startIndex, int lastIndex) {
        this.range = Range.of((int)startIndex, (int)lastIndex);
        this.page = null;
    }

    public void withLock(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public void withHint(String hintName, Object value) {
        if (this.hints == null) {
            this.hints = new HashMap<String, Object>();
        }
        this.hints.put(hintName, value);
    }

    public long count() {
        if (this.count == null) {
            if (this.customCountQueryForSpring != null) {
                SelectionQuery countQuery = this.session.createSelectionQuery(this.customCountQueryForSpring, Long.class);
                if (this.paramsArrayOrMap instanceof Map) {
                    AbstractJpaOperations.bindParameters(countQuery, (Map)this.paramsArrayOrMap);
                } else {
                    AbstractJpaOperations.bindParameters(countQuery, (Object[])this.paramsArrayOrMap);
                }
                try (NonThrowingCloseable c = this.applyFilters();){
                    this.count = (Long)countQuery.getSingleResult();
                }
            }
            SelectionQuery query = this.createBaseQuery();
            try (NonThrowingCloseable c = this.applyFilters();){
                this.count = query.getResultCount();
            }
        }
        return this.count;
    }

    public <T extends Entity> List<T> list() {
        SelectionQuery hibernateQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            List list = hibernateQuery.getResultList();
            return list;
        }
    }

    public <T extends Entity> Stream<T> stream() {
        SelectionQuery hibernateQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            Stream stream = hibernateQuery.getResultStream();
            return stream;
        }
    }

    public <T extends Entity> T firstResult() {
        SelectionQuery hibernateQuery = this.createQuery(1);
        try (NonThrowingCloseable c = this.applyFilters();){
            List list = hibernateQuery.getResultList();
            T t = list.isEmpty() ? null : (T)list.get(0);
            return t;
        }
    }

    public <T extends Entity> Optional<T> firstResultOptional() {
        return Optional.ofNullable(this.firstResult());
    }

    public <T extends Entity> T singleResult() {
        SelectionQuery hibernateQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            Object object = hibernateQuery.getSingleResult();
            return (T)object;
        }
    }

    public <T extends Entity> Optional<T> singleResultOptional() {
        SelectionQuery hibernateQuery = this.createQuery();
        try (NonThrowingCloseable c = this.applyFilters();){
            Optional<Object> optional = Optional.ofNullable(hibernateQuery.getSingleResultOrNull());
            return optional;
        }
    }

    private SelectionQuery createQuery() {
        SelectionQuery hibernateQuery = this.createBaseQuery();
        if (this.range != null) {
            hibernateQuery.setFirstResult(this.range.getStartIndex());
            hibernateQuery.setMaxResults(this.range.getLastIndex() - this.range.getStartIndex() + 1);
        } else if (this.page != null) {
            hibernateQuery.setFirstResult(this.page.index * this.page.size);
            hibernateQuery.setMaxResults(this.page.size);
        }
        return hibernateQuery;
    }

    private SelectionQuery createQuery(int maxResults) {
        SelectionQuery hibernateQuery = this.createBaseQuery();
        if (this.range != null) {
            hibernateQuery.setFirstResult(this.range.getStartIndex());
        } else if (this.page != null) {
            hibernateQuery.setFirstResult(this.page.index * this.page.size);
        }
        hibernateQuery.setMaxResults(maxResults);
        return hibernateQuery;
    }

    private SelectionQuery createBaseQuery() {
        SelectionQuery hibernateQuery;
        if (PanacheJpaUtil.isNamedQuery((String)this.query)) {
            String namedQuery = this.query.substring(1);
            hibernateQuery = this.session.createNamedSelectionQuery(namedQuery, this.projectionType);
        } else {
            try {
                hibernateQuery = this.session.createSelectionQuery((String)(this.orderBy != null ? this.query + this.orderBy : this.query), this.projectionType);
            }
            catch (RuntimeException x) {
                throw NamedQueryUtil.checkForNamedQueryMistake(x, this.originalQuery);
            }
        }
        if (this.paramsArrayOrMap instanceof Map) {
            AbstractJpaOperations.bindParameters(hibernateQuery, (Map)this.paramsArrayOrMap);
        } else {
            AbstractJpaOperations.bindParameters(hibernateQuery, (Object[])this.paramsArrayOrMap);
        }
        if (this.lockModeType != null) {
            hibernateQuery.setLockMode(this.lockModeType);
        }
        if (this.hints != null) {
            for (Map.Entry<String, Object> hint : this.hints.entrySet()) {
                hibernateQuery.setHint(hint.getKey(), hint.getValue());
            }
        }
        return hibernateQuery;
    }

    private NonThrowingCloseable applyFilters() {
        if (this.filters == null) {
            return NO_FILTERS;
        }
        for (Map.Entry<String, Map<String, Object>> entry : this.filters.entrySet()) {
            Filter filter = this.session.enableFilter(entry.getKey());
            for (Map.Entry<String, Object> paramEntry : entry.getValue().entrySet()) {
                if (paramEntry.getValue() instanceof Collection) {
                    filter.setParameterList(paramEntry.getKey(), (Collection)paramEntry.getValue());
                    continue;
                }
                if (paramEntry.getValue() instanceof Object[]) {
                    filter.setParameterList(paramEntry.getKey(), (Object[])paramEntry.getValue());
                    continue;
                }
                filter.setParameter(paramEntry.getKey(), paramEntry.getValue());
            }
            filter.validate();
        }
        return new NonThrowingCloseable(){

            @Override
            public void close() {
                for (Map.Entry<String, Map<String, Object>> entry : CommonPanacheQueryImpl.this.filters.entrySet()) {
                    CommonPanacheQueryImpl.this.session.disableFilter(entry.getKey());
                }
            }
        };
    }

    public static String getQueryString(SelectionQuery hibernateQuery) {
        if (hibernateQuery instanceof SqmQuery) {
            return ((SqmQuery)hibernateQuery).getQueryString();
        }
        if (hibernateQuery instanceof Query) {
            return ((Query)hibernateQuery).getQueryString();
        }
        throw new IllegalArgumentException("Unexpected Query class: '" + hibernateQuery.getClass().getName() + "', where '" + SqmQuery.class.getName() + "' or '" + Query.class + "' is expected.");
    }

    private static interface NonThrowingCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

