/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.deployment;

import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import io.quarkus.hibernate.orm.panache.deployment.PanacheJpaEntityEnhancer;
import io.quarkus.hibernate.orm.panache.deployment.PanacheResourceProcessor;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheJpaRepositoryEnhancer
extends PanacheRepositoryEnhancer {
    public static final String PANACHE_REPOSITORY_BASE_NAME = PanacheRepositoryBase.class.getName();
    public static final String PANACHE_REPOSITORY_BASE_BINARY_NAME = PANACHE_REPOSITORY_BASE_NAME.replace('.', '/');
    public static final String PANACHE_REPOSITORY_NAME = PanacheRepository.class.getName();
    public static final String PANACHE_REPOSITORY_BINARY_NAME = PANACHE_REPOSITORY_NAME.replace('.', '/');

    public PanacheJpaRepositoryEnhancer(IndexView index) {
        super(index, PanacheResourceProcessor.DOTNAME_PANACHE_REPOSITORY_BASE);
    }

    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new PanacheJpaRepositoryClassVisitor(className, outputClassVisitor, this.panacheRepositoryBaseClassInfo);
    }

    static class PanacheJpaRepositoryClassVisitor
    extends PanacheRepositoryEnhancer.PanacheRepositoryClassVisitor {
        public PanacheJpaRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, ClassInfo panacheRepositoryBaseClassInfo) {
            super(className, outputClassVisitor, panacheRepositoryBaseClassInfo);
        }

        protected String getPanacheRepositoryBinaryName() {
            return PANACHE_REPOSITORY_BINARY_NAME;
        }

        protected String getPanacheRepositoryBaseBinaryName() {
            return PANACHE_REPOSITORY_BASE_BINARY_NAME;
        }

        protected String getPanacheOperationsBinaryName() {
            return PanacheJpaEntityEnhancer.JPA_OPERATIONS_BINARY_NAME;
        }

        public void visitEnd() {
            MethodVisitor mv = super.visitMethod(4161, "findById", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitParameter("id", 0);
            mv.visitCode();
            mv.visitIntInsn(25, 0);
            mv.visitIntInsn(25, 1);
            mv.visitMethodInsn(182, this.daoBinaryName, "findById", "(Ljava/lang/Object;)" + this.entitySignature, false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            super.visitEnd();
        }

        protected void injectModel(MethodVisitor mv) {
            mv.visitLdcInsn((Object)this.entityType);
        }

        protected String getModelDescriptor() {
            return "Ljava/lang/Class;";
        }
    }
}

