/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.deployment;

import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.deployment.PanacheHibernateResourceProcessor;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.visitors.PanacheEntityClassVisitor;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.persistence.Transient;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheJpaEntityEnhancer
extends PanacheEntityEnhancer<MetamodelInfo<EntityModel<EntityField>>> {
    public static final String ENTITY_BASE_NAME = PanacheEntityBase.class.getName();
    public static final String ENTITY_BASE_BINARY_NAME = ENTITY_BASE_NAME.replace('.', '/');
    public static final String ENTITY_BASE_SIGNATURE = "L" + ENTITY_BASE_BINARY_NAME + ";";
    public static final String QUERY_NAME = PanacheQuery.class.getName();
    public static final String QUERY_BINARY_NAME = QUERY_NAME.replace('.', '/');
    public static final String QUERY_SIGNATURE = "L" + QUERY_BINARY_NAME + ";";
    public static final String JPA_OPERATIONS_NAME = JpaOperations.class.getName();
    public static final String JPA_OPERATIONS_BINARY_NAME = JPA_OPERATIONS_NAME.replace('.', '/');
    private static final DotName DOTNAME_TRANSIENT = DotName.createSimple((String)Transient.class.getName());

    public PanacheJpaEntityEnhancer(IndexView index, List<PanacheMethodCustomizer> methodCustomizers) {
        super(index, methodCustomizers);
        this.modelInfo = new MetamodelInfo();
    }

    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new PanacheJpaEntityClassVisitor(className, outputClassVisitor, (MetamodelInfo<EntityModel<EntityField>>)this.modelInfo, this.indexView.getClassByName(PanacheHibernateResourceProcessor.DOTNAME_PANACHE_ENTITY_BASE), this.indexView.getClassByName(DotName.createSimple((String)className)), this.methodCustomizers);
    }

    public void collectFields(ClassInfo classInfo) {
        EntityModel entityModel = new EntityModel(classInfo);
        for (FieldInfo fieldInfo : classInfo.fields()) {
            String name = fieldInfo.name();
            if (!Modifier.isPublic(fieldInfo.flags()) || fieldInfo.hasAnnotation(DOTNAME_TRANSIENT)) continue;
            entityModel.addField(new EntityField(name, DescriptorUtils.typeToString((Type)fieldInfo.type())));
        }
        this.modelInfo.addEntityModel(entityModel);
    }

    static class PanacheJpaEntityClassVisitor
    extends PanacheEntityClassVisitor<EntityField> {
        public PanacheJpaEntityClassVisitor(String className, ClassVisitor outputClassVisitor, MetamodelInfo<EntityModel<EntityField>> modelInfo, ClassInfo panacheEntityBaseClassInfo, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers) {
            super(className, outputClassVisitor, modelInfo, panacheEntityBaseClassInfo, entityInfo, methodCustomizers);
        }

        protected void injectModel(MethodVisitor mv) {
            mv.visitLdcInsn((Object)this.thisClass);
        }

        protected String getModelDescriptor() {
            return "Ljava/lang/Class;";
        }

        protected String getPanacheOperationsInternalName() {
            return JPA_OPERATIONS_BINARY_NAME;
        }

        protected void generateAccessorSetField(MethodVisitor mv, EntityField field) {
            mv.visitMethodInsn(182, this.thisClass.getInternalName(), "$$_hibernate_write_" + field.name, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Void.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType((String)field.descriptor)}), false);
        }

        protected void generateAccessorGetField(MethodVisitor mv, EntityField field) {
            mv.visitMethodInsn(182, this.thisClass.getInternalName(), "$$_hibernate_read_" + field.name, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType((String)field.descriptor), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
        }
    }
}

