/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelPersistenceUnitMappingBuildItem;
import io.quarkus.hibernate.orm.panache.PanacheEntity;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import io.quarkus.hibernate.orm.panache.deployment.JavaJpaTypeBundle;
import io.quarkus.hibernate.orm.panache.deployment.PanacheEntityClassBuildItem;
import io.quarkus.hibernate.orm.panache.runtime.PanacheHibernateOrmRecorder;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheJpaEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheJpaRepositoryEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class PanacheHibernateResourceProcessor {
    static final DotName DOTNAME_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)PanacheRepositoryBase.class.getName());
    private static final DotName DOTNAME_PANACHE_REPOSITORY = DotName.createSimple((String)PanacheRepository.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY = DotName.createSimple((String)PanacheEntity.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY_BASE = DotName.createSimple((String)PanacheEntityBase.class.getName());
    private static final DotName DOTNAME_ENTITY_MANAGER = DotName.createSimple((String)EntityManager.class.getName());
    private static final DotName DOTNAME_ID = DotName.createSimple((String)Id.class.getName());

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.HIBERNATE_ORM_PANACHE);
    }

    @BuildStep
    List<AdditionalJpaModelBuildItem> produceModel() {
        return Collections.singletonList(new AdditionalJpaModelBuildItem(PanacheEntity.class));
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(DOTNAME_ENTITY_MANAGER));
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("META-INF/panache-archive.marker");
    }

    @BuildStep
    void collectEntityClasses(CombinedIndexBuildItem index, BuildProducer<PanacheEntityClassBuildItem> entityClasses) {
        for (ClassInfo panacheEntityBaseSubclass : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY_BASE)) {
            if (panacheEntityBaseSubclass.name().equals((Object)DOTNAME_PANACHE_ENTITY)) continue;
            entityClasses.produce((BuildItem)new PanacheEntityClassBuildItem(panacheEntityBaseSubclass));
        }
    }

    @BuildStep
    PanacheEntityClassesBuildItem findEntityClasses(List<PanacheEntityClassBuildItem> entityClasses) {
        if (!entityClasses.isEmpty()) {
            HashSet<String> ret = new HashSet<String>();
            for (PanacheEntityClassBuildItem entityClass : entityClasses) {
                ret.add(entityClass.get().name().toString());
            }
            return new PanacheEntityClassesBuildItem(ret);
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(PanacheHibernateOrmRecorder recorder, CombinedIndexBuildItem index, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<BytecodeTransformerBuildItem> transformers, HibernateEnhancersRegisteredBuildItem hibernateMarker, List<PanacheEntityClassBuildItem> entityClasses, Optional<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List typeParameters;
        List methodCustomizers = methodCustomizersBuildItems.stream().map(PanacheMethodCustomizerBuildItem::getMethodCustomizer).collect(Collectors.toList());
        PanacheJpaRepositoryEnhancer daoEnhancer = new PanacheJpaRepositoryEnhancer(index.getIndex(), JavaJpaTypeBundle.BUNDLE);
        HashSet<String> panacheEntities = new HashSet<String>();
        HashSet<String> daoClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_REPOSITORY) || daoEnhancer.skipRepository(classInfo)) continue;
            typeParameters = JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex());
            panacheEntities.add(((Type)typeParameters.get(0)).name().toString());
            daoClasses.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY)) {
            if (daoEnhancer.skipRepository(classInfo)) continue;
            typeParameters = JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY, (IndexView)index.getIndex());
            panacheEntities.add(((Type)typeParameters.get(0)).name().toString());
            daoClasses.add(classInfo.name().toString());
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)daoEnhancer));
        }
        PanacheJpaEntityEnhancer modelEnhancer = new PanacheJpaEntityEnhancer(index.getIndex(), methodCustomizers, JavaJpaTypeBundle.BUNDLE);
        HashSet<String> modelClasses = new HashSet<String>();
        HashSet<String> modelClassNamesInternal = new HashSet<String>();
        for (PanacheEntityClassBuildItem entityClass : entityClasses) {
            String entityClassName = entityClass.get().name().toString();
            modelClasses.add(entityClassName);
            modelEnhancer.collectFields(entityClass.get());
            modelClassNamesInternal.add(entityClassName.replace(".", "/"));
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, entityClassName, (BiFunction)modelEnhancer));
        }
        MetamodelInfo modelInfo = modelEnhancer.getModelInfo();
        if (modelInfo.hasEntities()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
            QuarkusClassLoader tccl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            List archives = tccl.getElementsWithResource("META-INF/panache-archive.marker");
            HashSet<String> produced = new HashSet<String>();
            for (ClassInfo i : applicationArchivesBuildItem.getRootArchive().getIndex().getKnownClasses()) {
                String cn = i.name().toString();
                if (modelClasses.contains(cn)) continue;
                produced.add(cn);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, modelClassNamesInternal));
            }
            for (ClassInfo i : archives) {
                for (String res : i.getProvidedResources()) {
                    String cn;
                    if (!res.endsWith(".class") || produced.contains(cn = res.replace("/", ".").substring(0, res.length() - 6)) || modelClasses.contains(cn)) continue;
                    produced.add(cn);
                    transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, modelClassNamesInternal));
                }
            }
        }
        panacheEntities.addAll(modelClasses);
        this.recordPanacheEntityPersistenceUnits(recorder, jpaModelPersistenceUnitMapping, panacheEntities);
    }

    @BuildStep
    ValidationPhaseBuildItem.ValidationErrorBuildItem validate(ValidationPhaseBuildItem validationPhase, CombinedIndexBuildItem index) throws BuildException {
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_ID)) {
            ClassInfo info = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
            if (!JandexUtil.isSubclassOf((IndexView)index.getIndex(), (ClassInfo)info, (DotName)DOTNAME_PANACHE_ENTITY)) continue;
            BuildException be = new BuildException("You provide a JPA identifier via @Id inside '" + info.name() + "' but one is already provided by PanacheEntity, your class should extend PanacheEntityBase instead, or use the id provided by PanacheEntity", Collections.emptyList());
            return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
        }
        return null;
    }

    void recordPanacheEntityPersistenceUnits(PanacheHibernateOrmRecorder recorder, Optional<JpaModelPersistenceUnitMappingBuildItem> jpaModelPersistenceUnitMapping, Set<String> panacheEntityClasses) {
        HashMap panacheEntityToPersistenceUnit = new HashMap();
        if (jpaModelPersistenceUnitMapping.isPresent()) {
            Map collectedEntityToPersistenceUnits = jpaModelPersistenceUnitMapping.get().getEntityToPersistenceUnits();
            TreeMap<String, Set> violatingPanacheEntities = new TreeMap<String, Set>();
            for (Map.Entry entry : collectedEntityToPersistenceUnits.entrySet()) {
                String entityName = (String)entry.getKey();
                Set selectedPersistenceUnits = (Set)entry.getValue();
                boolean isPanacheEntity = panacheEntityClasses.stream().anyMatch(entity -> entity.equals(entityName));
                if (!isPanacheEntity) continue;
                if (selectedPersistenceUnits.size() == 1) {
                    panacheEntityToPersistenceUnit.put(entityName, selectedPersistenceUnits.iterator().next());
                    continue;
                }
                violatingPanacheEntities.put(entityName, selectedPersistenceUnits);
            }
            if (violatingPanacheEntities.size() > 0) {
                StringBuilder message = new StringBuilder("Panache entities do not support being attached to several persistence units:\n");
                Iterator iterator = violatingPanacheEntities.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry violatingEntityEntry = iterator.next();
                    message.append("\t- ").append((String)violatingEntityEntry.getKey()).append(" is attached to: ").append(String.join((CharSequence)",", (Iterable)violatingEntityEntry.getValue()));
                    throw new IllegalStateException(message.toString());
                }
            }
        }
        recorder.setEntityToPersistenceUnit(panacheEntityToPersistenceUnit);
    }
}

