/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.orm.panache.PanacheEntity;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheHibernateRecorder;
import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import io.quarkus.hibernate.orm.panache.deployment.NamedQueryEntityClassBuildStep;
import io.quarkus.hibernate.orm.panache.deployment.PanacheJpaEntityEnhancer;
import io.quarkus.hibernate.orm.panache.deployment.PanacheJpaRepositoryEnhancer;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.persistence.EntityManager;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public final class PanacheResourceProcessor {
    static final DotName DOTNAME_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)PanacheRepositoryBase.class.getName());
    private static final DotName DOTNAME_PANACHE_REPOSITORY = DotName.createSimple((String)PanacheRepository.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY_BASE = DotName.createSimple((String)PanacheEntityBase.class.getName());
    private static final DotName DOTNAME_PANACHE_ENTITY = DotName.createSimple((String)PanacheEntity.class.getName());
    private static final DotName DOTNAME_ENTITY_MANAGER = DotName.createSimple((String)EntityManager.class.getName());
    private static final DotName DOTNAME_NAMED_QUERY = DotName.createSimple((String)NamedQuery.class.getName());
    private static final DotName DOTNAME_NAMED_QUERIES = DotName.createSimple((String)NamedQueries.class.getName());
    private static final DotName DOTNAME_OBJECT = DotName.createSimple((String)Object.class.getName());

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("hibernate-orm-panache");
    }

    @BuildStep
    List<AdditionalJpaModelBuildItem> produceModel() {
        return Collections.singletonList(new AdditionalJpaModelBuildItem(PanacheEntity.class));
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(DOTNAME_ENTITY_MANAGER));
    }

    @BuildStep
    void build(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, HibernateEnhancersRegisteredBuildItem hibernateMarker, BuildProducer<PanacheEntityClassesBuildItem> entityClasses, BuildProducer<NamedQueryEntityClassBuildStep> namedQueries) throws Exception {
        MetamodelInfo modelInfo;
        PanacheJpaRepositoryEnhancer daoEnhancer = new PanacheJpaRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        HashSet daoTypeParameters = new HashSet();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_REPOSITORY) || PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY)) {
            if (PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)DOTNAME_PANACHE_REPOSITORY_BASE, (IndexView)index.getIndex()));
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        for (Type parameterType : daoTypeParameters) {
            Iterator typeNamedQueries = new HashSet<String>();
            this.lookupNamedQueries(index, parameterType.name(), (Set<String>)((Object)typeNamedQueries));
            namedQueries.produce((BuildItem)new NamedQueryEntityClassBuildStep(parameterType.name().toString(), (Set<String>)((Object)typeNamedQueries)));
        }
        PanacheJpaEntityEnhancer modelEnhancer = new PanacheJpaEntityEnhancer(index.getIndex());
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_ENTITY) || !modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields(classInfo);
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY)) {
            if (!modelClasses.add(classInfo.name().toString())) continue;
            modelEnhancer.collectFields(classInfo);
        }
        for (String modelClass : modelClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(modelClass, (BiFunction)((Object)modelEnhancer)));
            HashSet<String> typeNamedQueries = new HashSet<String>();
            this.lookupNamedQueries(index, DotName.createSimple((String)modelClass), typeNamedQueries);
            namedQueries.produce((BuildItem)new NamedQueryEntityClassBuildStep(modelClass, typeNamedQueries));
        }
        if (!modelClasses.isEmpty()) {
            entityClasses.produce((BuildItem)new PanacheEntityClassesBuildItem(modelClasses));
        }
        if ((modelInfo = modelEnhancer.getModelInfo()).hasEntities()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
            for (ClassInfo classInfo : index.getIndex().getKnownClasses()) {
                String className = classInfo.name().toString();
                if (modelClasses.contains(className)) continue;
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(className, (BiFunction)panacheFieldAccessEnhancer));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void buildNamedQueryMap(List<NamedQueryEntityClassBuildStep> namedQueryEntityClasses, PanacheHibernateRecorder panacheHibernateRecorder) {
        HashMap<String, Set<String>> namedQueryMap = new HashMap<String, Set<String>>();
        for (NamedQueryEntityClassBuildStep entityNamedQueries : namedQueryEntityClasses) {
            namedQueryMap.put(entityNamedQueries.getClassName(), entityNamedQueries.getNamedQueries());
        }
        panacheHibernateRecorder.setNamedQueryMap(namedQueryMap);
    }

    private void lookupNamedQueries(CombinedIndexBuildItem index, DotName name, Set<String> namedQueries) {
        List namedQueriesInstances;
        ClassInfo classInfo = index.getIndex().getClassByName(name);
        if (classInfo == null) {
            return;
        }
        List namedQueryInstances = (List)classInfo.annotations().get(DOTNAME_NAMED_QUERY);
        if (namedQueryInstances != null) {
            for (Object namedQueryInstance : namedQueryInstances) {
                namedQueries.add(namedQueryInstance.value("name").asString());
            }
        }
        if ((namedQueriesInstances = (List)classInfo.annotations().get(DOTNAME_NAMED_QUERIES)) != null) {
            for (AnnotationInstance namedQueriesInstance : namedQueriesInstances) {
                AnnotationInstance[] nestedInstances;
                AnnotationValue value = namedQueriesInstance.value();
                for (AnnotationInstance nested : nestedInstances = value.asNestedArray()) {
                    namedQueries.add(nested.value("name").asString());
                }
            }
        }
        if (!classInfo.superClassType().name().equals((Object)DOTNAME_OBJECT)) {
            Type superType = classInfo.superClassType();
            ClassInfo superClass = index.getIndex().getClassByName(superType.name());
            this.lookupNamedQueries(index, superClass.name(), namedQueries);
        }
    }
}

