/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.deployment;

import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import io.quarkus.hibernate.orm.panache.deployment.PanacheHibernateResourceProcessor;
import io.quarkus.hibernate.orm.panache.deployment.PanacheJpaEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class PanacheJpaRepositoryEnhancer
extends PanacheRepositoryEnhancer {
    private static final DotName PANACHE_REPOSITORY_BINARY_NAME = DotName.createSimple((String)PanacheRepository.class.getName());
    private static final DotName PANACHE_REPOSITORY_BASE_BINARY_NAME = DotName.createSimple((String)PanacheRepositoryBase.class.getName());

    public PanacheJpaRepositoryEnhancer(IndexView index) {
        super(index, PanacheHibernateResourceProcessor.DOTNAME_PANACHE_REPOSITORY_BASE);
    }

    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new PanacheJpaRepositoryClassVisitor(className, outputClassVisitor, this.panacheRepositoryBaseClassInfo, this.indexView);
    }

    static class PanacheJpaRepositoryClassVisitor
    extends PanacheRepositoryEnhancer.PanacheRepositoryClassVisitor {
        public PanacheJpaRepositoryClassVisitor(String className, ClassVisitor outputClassVisitor, ClassInfo panacheRepositoryBaseClassInfo, IndexView indexView) {
            super(className, outputClassVisitor, panacheRepositoryBaseClassInfo, indexView);
        }

        protected DotName getPanacheRepositoryDotName() {
            return PANACHE_REPOSITORY_BINARY_NAME;
        }

        protected DotName getPanacheRepositoryBaseDotName() {
            return PANACHE_REPOSITORY_BASE_BINARY_NAME;
        }

        protected String getPanacheOperationsBinaryName() {
            return PanacheJpaEntityEnhancer.JPA_OPERATIONS_BINARY_NAME;
        }

        protected void injectModel(MethodVisitor mv) {
            mv.visitLdcInsn((Object)this.entityType);
        }

        protected String getModelDescriptor() {
            return "Ljava/lang/Class;";
        }
    }
}

