/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.hibernate.orm.deployment.AdditionalJpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateEnhancersRegisteredBuildItem;
import io.quarkus.hibernate.orm.panache.PanacheEntity;
import io.quarkus.hibernate.orm.panache.PanacheEntityBase;
import io.quarkus.hibernate.orm.panache.PanacheRepository;
import io.quarkus.hibernate.orm.panache.PanacheRepositoryBase;
import io.quarkus.hibernate.orm.panache.deployment.PanacheEntityClassBuildItem;
import io.quarkus.hibernate.orm.panache.deployment.PanacheJpaEntityEnhancer;
import io.quarkus.hibernate.orm.panache.deployment.PanacheJpaRepositoryEnhancer;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public final class PanacheHibernateResourceProcessor {
    static final DotName DOTNAME_PANACHE_REPOSITORY_BASE = DotName.createSimple((String)PanacheRepositoryBase.class.getName());
    private static final DotName DOTNAME_PANACHE_REPOSITORY = DotName.createSimple((String)PanacheRepository.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY = DotName.createSimple((String)PanacheEntity.class.getName());
    static final DotName DOTNAME_PANACHE_ENTITY_BASE = DotName.createSimple((String)PanacheEntityBase.class.getName());
    private static final DotName DOTNAME_ENTITY_MANAGER = DotName.createSimple((String)EntityManager.class.getName());
    private static final DotName DOTNAME_ID = DotName.createSimple((String)Id.class.getName());
    protected static final String META_INF_PANACHE_ARCHIVE_MARKER = "META-INF/panache-archive.marker";

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem(Feature.HIBERNATE_ORM_PANACHE);
    }

    @BuildStep
    List<AdditionalJpaModelBuildItem> produceModel() {
        return Collections.singletonList(new AdditionalJpaModelBuildItem(PanacheEntity.class));
    }

    @BuildStep
    UnremovableBeanBuildItem ensureBeanLookupAvailable() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanTypeExclusion(DOTNAME_ENTITY_MANAGER));
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem(META_INF_PANACHE_ARCHIVE_MARKER);
    }

    @BuildStep
    void collectEntityClasses(CombinedIndexBuildItem index, BuildProducer<PanacheEntityClassBuildItem> entityClasses) {
        for (ClassInfo panacheEntityBaseSubclass : index.getIndex().getAllKnownSubclasses(DOTNAME_PANACHE_ENTITY_BASE)) {
            if (panacheEntityBaseSubclass.name().equals((Object)DOTNAME_PANACHE_ENTITY)) continue;
            entityClasses.produce((BuildItem)new PanacheEntityClassBuildItem(panacheEntityBaseSubclass));
        }
    }

    @BuildStep
    PanacheEntityClassesBuildItem findEntityClasses(List<PanacheEntityClassBuildItem> entityClasses) {
        if (!entityClasses.isEmpty()) {
            HashSet<String> ret = new HashSet<String>();
            for (PanacheEntityClassBuildItem entityClass : entityClasses) {
                ret.add(entityClass.get().name().toString());
            }
            return new PanacheEntityClassesBuildItem(ret);
        }
        return null;
    }

    @BuildStep
    void build(CombinedIndexBuildItem index, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<BytecodeTransformerBuildItem> transformers, HibernateEnhancersRegisteredBuildItem hibernateMarker, List<PanacheEntityClassBuildItem> entityClasses, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) throws Exception {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(PanacheMethodCustomizerBuildItem::getMethodCustomizer).collect(Collectors.toList());
        PanacheJpaRepositoryEnhancer daoEnhancer = new PanacheJpaRepositoryEnhancer(index.getIndex());
        HashSet<String> daoClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY_BASE)) {
            if (classInfo.name().equals((Object)DOTNAME_PANACHE_REPOSITORY) || PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
        }
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(DOTNAME_PANACHE_REPOSITORY)) {
            if (PanacheRepositoryEnhancer.skipRepository((ClassInfo)classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)((Object)daoEnhancer)));
        }
        PanacheJpaEntityEnhancer modelEnhancer = new PanacheJpaEntityEnhancer(index.getIndex(), methodCustomizers);
        HashSet<String> modelClasses = new HashSet<String>();
        HashSet<String> modelClassNamesInternal = new HashSet<String>();
        for (PanacheEntityClassBuildItem entityClass : entityClasses) {
            String entityClassName = entityClass.get().name().toString();
            modelClasses.add(entityClassName);
            modelEnhancer.collectFields(entityClass.get());
            modelClassNamesInternal.add(entityClassName.replace(".", "/"));
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(true, entityClassName, (BiFunction)((Object)modelEnhancer)));
        }
        MetamodelInfo modelInfo = modelEnhancer.getModelInfo();
        if (modelInfo.hasEntities()) {
            PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
            QuarkusClassLoader tccl = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            List archives = tccl.getElementsWithResource(META_INF_PANACHE_ARCHIVE_MARKER);
            HashSet<String> produced = new HashSet<String>();
            for (ClassInfo i : applicationArchivesBuildItem.getRootArchive().getIndex().getKnownClasses()) {
                String cn = i.name().toString();
                if (modelClasses.contains(cn)) continue;
                produced.add(cn);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, modelClassNamesInternal));
            }
            for (ClassInfo i : archives) {
                for (String res : i.getProvidedResources()) {
                    String cn;
                    if (!res.endsWith(".class") || produced.contains(cn = res.replace("/", ".").substring(0, res.length() - 6)) || modelClasses.contains(cn)) continue;
                    produced.add(cn);
                    transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, modelClassNamesInternal));
                }
            }
        }
    }

    @BuildStep
    ValidationPhaseBuildItem.ValidationErrorBuildItem validate(ValidationPhaseBuildItem validationPhase, CombinedIndexBuildItem index) throws BuildException {
        for (AnnotationInstance annotationInstance : index.getIndex().getAnnotations(DOTNAME_ID)) {
            ClassInfo info = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
            if (!JandexUtil.isSubclassOf((IndexView)index.getIndex(), (ClassInfo)info, (DotName)DOTNAME_PANACHE_ENTITY)) continue;
            BuildException be = new BuildException("You provide a JPA identifier via @Id inside '" + info.name() + "' but one is already provided by PanacheEntity, your class should extend PanacheEntityBase instead, or use the id provided by PanacheEntity", Collections.emptyList());
            return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
        }
        return null;
    }
}

