/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinJpaTypeBundle;
import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheResourceProcessor;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.visitors.KotlinPanacheClassVisitor;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;

public class KotlinPanacheEntityEnhancer
extends PanacheEntityEnhancer<MetamodelInfo<EntityModel<EntityField>>> {
    public KotlinPanacheEntityEnhancer(IndexView index, List<PanacheMethodCustomizer> methodCustomizers) {
        super(index, methodCustomizers);
        this.modelInfo = new MetamodelInfo();
    }

    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new KotlinPanacheClassVisitor(outputClassVisitor, this.indexView.getClassByName(DotName.createSimple((String)className)), this.indexView, KotlinJpaTypeBundle.BUNDLE, KotlinJpaTypeBundle.BUNDLE.entityBase(), this.methodCustomizers);
    }

    public void collectFields(ClassInfo classInfo) {
        EntityModel entityModel = new EntityModel(classInfo);
        for (FieldInfo fieldInfo : classInfo.fields()) {
            String name = fieldInfo.name();
            if (!Modifier.isPublic(fieldInfo.flags()) || Modifier.isStatic(fieldInfo.flags()) || fieldInfo.hasAnnotation(KotlinPanacheResourceProcessor.TRANSIENT)) continue;
            entityModel.addField(new EntityField(name, DescriptorUtils.typeToString((Type)fieldInfo.type())));
        }
        this.modelInfo.addEntityModel(entityModel);
    }
}

