/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.kotlin.deployment;

import io.quarkus.hibernate.orm.panache.kotlin.deployment.KotlinPanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.visitors.PanacheEntityClassVisitor;
import java.util.List;
import java.util.StringJoiner;
import org.jboss.jandex.ClassInfo;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class KotlinPanacheEntityClassVisitor
extends PanacheEntityClassVisitor<EntityField> {
    private String entityBinaryType;

    public KotlinPanacheEntityClassVisitor(String className, ClassVisitor outputClassVisitor, MetamodelInfo<EntityModel<EntityField>> modelInfo, ClassInfo panacheEntityBaseClassInfo, ClassInfo entityInfo, List<PanacheMethodCustomizer> methodCustomizers) {
        super(className, outputClassVisitor, modelInfo, panacheEntityBaseClassInfo, entityInfo, methodCustomizers);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.entityBinaryType = name;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        int updated = access;
        if (name.startsWith("get") || name.startsWith("set")) {
            updated &= 0xFFFFFFEF;
        }
        return super.visitMethod(updated, name, descriptor, signature, exceptions);
    }

    protected String getPanacheOperationsInternalName() {
        return KotlinPanacheEntityEnhancer.JPA_OPERATIONS_BINARY_NAME;
    }

    protected void generateAccessorSetField(MethodVisitor mv, EntityField field) {
        mv.visitMethodInsn(182, this.thisClass.getInternalName(), "$$_hibernate_write_" + field.name, Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType((String)field.descriptor)}), false);
    }

    protected void generateAccessorGetField(MethodVisitor mv, EntityField field) {
        mv.visitMethodInsn(182, this.thisClass.getInternalName(), "$$_hibernate_read_" + field.name, Type.getMethodDescriptor((Type)Type.getType((String)field.descriptor), (Type[])new Type[0]), false);
    }

    public String toString() {
        return new StringJoiner(", ", KotlinPanacheEntityClassVisitor.class.getSimpleName() + "[", "]").add(this.entityBinaryType).toString();
    }
}

