/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.runtime;

import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Page;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class PanacheQueryImpl<Entity>
implements PanacheQuery<Entity> {
    private Query jpaQuery;
    private Object paramsArrayOrMap;
    private String query;
    private EntityManager em;
    private Page page;
    private Long count;

    PanacheQueryImpl(EntityManager em, Query jpaQuery, String query, Object paramsArrayOrMap) {
        this.em = em;
        this.jpaQuery = jpaQuery;
        this.query = query;
        this.paramsArrayOrMap = paramsArrayOrMap;
        this.page = new Page(0, Integer.MAX_VALUE);
    }

    @Override
    public <T extends Entity> PanacheQuery<T> page(Page page) {
        this.page = page;
        this.jpaQuery.setFirstResult(page.index * page.size);
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> page(int pageIndex, int pageSize) {
        return this.page(Page.of((int)pageIndex, (int)pageSize));
    }

    @Override
    public <T extends Entity> PanacheQuery<T> nextPage() {
        return this.page(this.page.next());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> previousPage() {
        return this.page(this.page.previous());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> firstPage() {
        return this.page(this.page.first());
    }

    @Override
    public <T extends Entity> PanacheQuery<T> lastPage() {
        return this.page(this.page.index(this.pageCount() - 1));
    }

    @Override
    public boolean hasNextPage() {
        return this.page.index < this.pageCount() - 1;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.page.index > 0;
    }

    @Override
    public int pageCount() {
        long count = this.count();
        if (count == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)count / (double)this.page.size);
    }

    @Override
    public Page page() {
        return this.page;
    }

    @Override
    public long count() {
        if (this.count == null) {
            String lcQuery = this.query.toLowerCase();
            int orderByIndex = lcQuery.lastIndexOf(" order by ");
            if (orderByIndex != -1) {
                this.query = this.query.substring(0, orderByIndex);
            }
            Query countQuery = this.em.createQuery("SELECT COUNT(*) " + this.query);
            if (this.paramsArrayOrMap instanceof Map) {
                JpaOperations.bindParameters(countQuery, (Map)this.paramsArrayOrMap);
            } else {
                JpaOperations.bindParameters(countQuery, (Object[])this.paramsArrayOrMap);
            }
            this.count = (Long)countQuery.getSingleResult();
        }
        return this.count;
    }

    @Override
    public <T extends Entity> List<T> list() {
        this.jpaQuery.setMaxResults(this.page.size);
        return this.jpaQuery.getResultList();
    }

    @Override
    public <T extends Entity> Stream<T> stream() {
        this.jpaQuery.setMaxResults(this.page.size);
        return this.jpaQuery.getResultStream();
    }

    @Override
    public <T extends Entity> T firstResult() {
        List<T> list = this.list();
        this.jpaQuery.setMaxResults(1);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    @Override
    public <T extends Entity> T singleResult() {
        this.jpaQuery.setMaxResults(this.page.size);
        return (T)this.jpaQuery.getSingleResult();
    }
}

