/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.PanacheQueryImpl;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.exception.PanacheQueryException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

public class JpaOperations {
    public static void persist(Object entity) {
        EntityManager em = JpaOperations.getEntityManager();
        JpaOperations.persist(em, entity);
    }

    public static void persist(EntityManager em, Object entity) {
        if (!em.contains(entity)) {
            em.persist(entity);
        }
    }

    public static void persist(Iterable<?> entities) {
        EntityManager em = JpaOperations.getEntityManager();
        for (Object entity : entities) {
            JpaOperations.persist(em, entity);
        }
    }

    public static void persist(Object firstEntity, Object ... entities) {
        EntityManager em = JpaOperations.getEntityManager();
        JpaOperations.persist(firstEntity);
        for (Object entity : entities) {
            JpaOperations.persist(em, entity);
        }
    }

    public static void persist(Stream<?> entities) {
        EntityManager em = JpaOperations.getEntityManager();
        entities.forEach(entity -> JpaOperations.persist(em, entity));
    }

    public static void delete(Object entity) {
        EntityManager em = JpaOperations.getEntityManager();
        em.remove(entity);
    }

    public static boolean isPersistent(Object entity) {
        return JpaOperations.getEntityManager().contains(entity);
    }

    public static void flush() {
        JpaOperations.getEntityManager().flush();
    }

    public static EntityManager getEntityManager() {
        EntityManager entityManager = (EntityManager)Arc.container().instance(EntityManager.class, new Annotation[0]).get();
        if (entityManager == null) {
            throw new PersistenceException("No EntityManager found. Do you have any JPA entities defined?");
        }
        return entityManager;
    }

    public static TransactionManager getTransactionManager() {
        return (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
    }

    public static Query bindParameters(Query query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static Query bindParameters(Query query, Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return query;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    static int paramCount(Object[] params) {
        return params != null ? params.length : 0;
    }

    static int paramCount(Map<String, Object> params) {
        return params != null ? params.size() : 0;
    }

    private static String getEntityName(Class<?> entityClass) {
        return entityClass.getName();
    }

    static String createFindQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "FROM " + JpaOperations.getEntityName(entityClass);
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            return "FROM " + JpaOperations.getEntityName(entityClass);
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("from ") || trimmedLc.startsWith("select ")) {
            return query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "FROM " + JpaOperations.getEntityName(entityClass) + " " + query;
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = query + " = ?1";
        }
        return "FROM " + JpaOperations.getEntityName(entityClass) + " WHERE " + query;
    }

    private static String createCountQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "SELECT COUNT(*) FROM " + JpaOperations.getEntityName(entityClass);
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            return "SELECT COUNT(*) FROM " + JpaOperations.getEntityName(entityClass);
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("from ")) {
            return "SELECT COUNT(*) " + query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "SELECT COUNT(*) FROM " + JpaOperations.getEntityName(entityClass);
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = query + " = ?1";
        }
        return "SELECT COUNT(*) FROM " + JpaOperations.getEntityName(entityClass) + " WHERE " + query;
    }

    private static String createUpdateQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            throw new PanacheQueryException("Query string cannot be null");
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            throw new PanacheQueryException("Query string cannot be empty");
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("update ")) {
            return query;
        }
        if (trimmedLc.startsWith("from ")) {
            return "UPDATE " + query;
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = query + " = ?1";
        }
        if (trimmedLc.startsWith("set ")) {
            return "UPDATE FROM " + JpaOperations.getEntityName(entityClass) + " " + query;
        }
        return "UPDATE FROM " + JpaOperations.getEntityName(entityClass) + " SET " + query;
    }

    private static String createDeleteQuery(Class<?> entityClass, String query, int paramCount) {
        if (query == null) {
            return "DELETE FROM " + JpaOperations.getEntityName(entityClass);
        }
        String trimmed = query.trim();
        if (trimmed.isEmpty()) {
            return "DELETE FROM " + JpaOperations.getEntityName(entityClass);
        }
        String trimmedLc = trimmed.toLowerCase();
        if (trimmedLc.startsWith("from ")) {
            return "DELETE " + query;
        }
        if (trimmedLc.startsWith("order by ")) {
            return "DELETE FROM " + JpaOperations.getEntityName(entityClass);
        }
        if (trimmedLc.indexOf(32) == -1 && trimmedLc.indexOf(61) == -1 && paramCount == 1) {
            query = query + " = ?1";
        }
        return "DELETE FROM " + JpaOperations.getEntityName(entityClass) + " WHERE " + query;
    }

    public static String toOrderBy(Sort sort) {
        if (sort.getColumns().size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" ORDER BY ");
        for (int i = 0; i < sort.getColumns().size(); ++i) {
            Sort.Column column = (Sort.Column)sort.getColumns().get(i);
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append(column.getName());
            if (column.getDirection() == Sort.Direction.Ascending) continue;
            sb.append(" DESC");
        }
        return sb.toString();
    }

    public static Object findById(Class<?> entityClass, Object id) {
        return JpaOperations.getEntityManager().find(entityClass, id);
    }

    public static Object findById(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return JpaOperations.getEntityManager().find(entityClass, id, lockModeType);
    }

    public static Optional<?> findByIdOptional(Class<?> entityClass, Object id) {
        return Optional.ofNullable(JpaOperations.findById(entityClass, id));
    }

    public static Optional<?> findByIdOptional(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return Optional.ofNullable(JpaOperations.findById(entityClass, id, lockModeType));
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Object ... params) {
        return JpaOperations.find(entityClass, query, null, params);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Object ... params) {
        String findQuery = JpaOperations.createFindQuery(entityClass, query, JpaOperations.paramCount(params));
        EntityManager em = JpaOperations.getEntityManager();
        Query jpaQuery = em.createQuery(sort != null ? findQuery + JpaOperations.toOrderBy(sort) : findQuery);
        JpaOperations.bindParameters(jpaQuery, params);
        return new PanacheQueryImpl(em, jpaQuery, findQuery, params);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Map<String, Object> params) {
        return JpaOperations.find(entityClass, query, null, params);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        String findQuery = JpaOperations.createFindQuery(entityClass, query, JpaOperations.paramCount(params));
        EntityManager em = JpaOperations.getEntityManager();
        Query jpaQuery = em.createQuery(sort != null ? findQuery + JpaOperations.toOrderBy(sort) : findQuery);
        JpaOperations.bindParameters(jpaQuery, params);
        return new PanacheQueryImpl(em, jpaQuery, findQuery, params);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Parameters params) {
        return JpaOperations.find(entityClass, query, null, params);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return JpaOperations.find(entityClass, query, sort, params.map());
    }

    public static List<?> list(Class<?> entityClass, String query, Object ... params) {
        return JpaOperations.find(entityClass, query, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return JpaOperations.find(entityClass, query, sort, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Map<String, Object> params) {
        return JpaOperations.find(entityClass, query, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return JpaOperations.find(entityClass, query, sort, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Parameters params) {
        return JpaOperations.find(entityClass, query, params).list();
    }

    public static List<?> list(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return JpaOperations.find(entityClass, query, sort, params).list();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Object ... params) {
        return JpaOperations.find(entityClass, query, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Sort sort, Object ... params) {
        return JpaOperations.find(entityClass, query, sort, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Map<String, Object> params) {
        return JpaOperations.find(entityClass, query, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Sort sort, Map<String, Object> params) {
        return JpaOperations.find(entityClass, query, sort, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Parameters params) {
        return JpaOperations.find(entityClass, query, params).stream();
    }

    public static Stream<?> stream(Class<?> entityClass, String query, Sort sort, Parameters params) {
        return JpaOperations.find(entityClass, query, sort, params).stream();
    }

    public static PanacheQuery<?> findAll(Class<?> entityClass) {
        String query = "FROM " + JpaOperations.getEntityName(entityClass);
        EntityManager em = JpaOperations.getEntityManager();
        return new PanacheQueryImpl(em, em.createQuery(query), query, null);
    }

    public static PanacheQuery<?> findAll(Class<?> entityClass, Sort sort) {
        String query = "FROM " + JpaOperations.getEntityName(entityClass);
        String sortedQuery = query + JpaOperations.toOrderBy(sort);
        EntityManager em = JpaOperations.getEntityManager();
        return new PanacheQueryImpl(em, em.createQuery(sortedQuery), query, null);
    }

    public static List<?> listAll(Class<?> entityClass) {
        return JpaOperations.findAll(entityClass).list();
    }

    public static List<?> listAll(Class<?> entityClass, Sort sort) {
        return JpaOperations.findAll(entityClass, sort).list();
    }

    public static Stream<?> streamAll(Class<?> entityClass) {
        return JpaOperations.findAll(entityClass).stream();
    }

    public static Stream<?> streamAll(Class<?> entityClass, Sort sort) {
        return JpaOperations.findAll(entityClass, sort).stream();
    }

    public static long count(Class<?> entityClass) {
        return (Long)JpaOperations.getEntityManager().createQuery("SELECT COUNT(*) FROM " + JpaOperations.getEntityName(entityClass)).getSingleResult();
    }

    public static long count(Class<?> entityClass, String query, Object ... params) {
        return (Long)JpaOperations.bindParameters(JpaOperations.getEntityManager().createQuery(JpaOperations.createCountQuery(entityClass, query, JpaOperations.paramCount(params))), params).getSingleResult();
    }

    public static long count(Class<?> entityClass, String query, Map<String, Object> params) {
        return (Long)JpaOperations.bindParameters(JpaOperations.getEntityManager().createQuery(JpaOperations.createCountQuery(entityClass, query, JpaOperations.paramCount(params))), params).getSingleResult();
    }

    public static long count(Class<?> entityClass, String query, Parameters params) {
        return JpaOperations.count(entityClass, query, params.map());
    }

    public static boolean exists(Class<?> entityClass) {
        return JpaOperations.count(entityClass) > 0L;
    }

    public static boolean exists(Class<?> entityClass, String query, Object ... params) {
        return JpaOperations.count(entityClass, query, params) > 0L;
    }

    public static boolean exists(Class<?> entityClass, String query, Map<String, Object> params) {
        return JpaOperations.count(entityClass, query, params) > 0L;
    }

    public static boolean exists(Class<?> entityClass, String query, Parameters params) {
        return JpaOperations.count(entityClass, query, params) > 0L;
    }

    public static long deleteAll(Class<?> entityClass) {
        return JpaOperations.getEntityManager().createQuery("DELETE FROM " + JpaOperations.getEntityName(entityClass)).executeUpdate();
    }

    public static long delete(Class<?> entityClass, String query, Object ... params) {
        return JpaOperations.bindParameters(JpaOperations.getEntityManager().createQuery(JpaOperations.createDeleteQuery(entityClass, query, JpaOperations.paramCount(params))), params).executeUpdate();
    }

    public static long delete(Class<?> entityClass, String query, Map<String, Object> params) {
        return JpaOperations.bindParameters(JpaOperations.getEntityManager().createQuery(JpaOperations.createDeleteQuery(entityClass, query, JpaOperations.paramCount(params))), params).executeUpdate();
    }

    public static long delete(Class<?> entityClass, String query, Parameters params) {
        return JpaOperations.delete(entityClass, query, params.map());
    }

    public static IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses: did you forget to annotate your entity with @Entity?");
    }

    public static int executeUpdate(String query, Object ... params) {
        Query jpaQuery = JpaOperations.getEntityManager().createQuery(query);
        JpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public static int executeUpdate(String query, Map<String, Object> params) {
        Query jpaQuery = JpaOperations.getEntityManager().createQuery(query);
        JpaOperations.bindParameters(jpaQuery, params);
        return jpaQuery.executeUpdate();
    }

    public static int executeUpdate(Class<?> entityClass, String query, Object ... params) {
        String updateQuery = JpaOperations.createUpdateQuery(entityClass, query, JpaOperations.paramCount(params));
        return JpaOperations.executeUpdate(updateQuery, params);
    }

    public static int executeUpdate(Class<?> entityClass, String query, Map<String, Object> params) {
        String updateQuery = JpaOperations.createUpdateQuery(entityClass, query, JpaOperations.paramCount(params));
        return JpaOperations.executeUpdate(updateQuery, params);
    }

    public static int update(Class<?> entityClass, String query, Map<String, Object> params) {
        return JpaOperations.executeUpdate(entityClass, query, params);
    }

    public static int update(Class<?> entityClass, String query, Parameters params) {
        return JpaOperations.update(entityClass, query, params.map());
    }

    public static int update(Class<?> entityClass, String query, Object ... params) {
        return JpaOperations.executeUpdate(entityClass, query, params);
    }

    public static void setRollbackOnly() {
        try {
            JpaOperations.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }
}

