/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.runtime;

import io.quarkus.hibernate.orm.panache.PanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.CustomCountPanacheQuery;
import io.quarkus.hibernate.orm.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class AdditionalJpaOperations {
    public static PanacheQuery<?> find(Class<?> entityClass, String query, String countQuery, Sort sort, Map<String, Object> params) {
        String findQuery = JpaOperations.createFindQuery(entityClass, query, JpaOperations.paramCount(params));
        EntityManager em = JpaOperations.getEntityManager();
        Query jpaQuery = em.createQuery(sort != null ? findQuery + JpaOperations.toOrderBy(sort) : findQuery);
        JpaOperations.bindParameters(jpaQuery, params);
        return new CustomCountPanacheQuery(em, jpaQuery, findQuery, countQuery, params);
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, String countQuery, Sort sort, Parameters parameters) {
        return AdditionalJpaOperations.find(entityClass, query, countQuery, sort, parameters.map());
    }

    public static PanacheQuery<?> find(Class<?> entityClass, String query, String countQuery, Sort sort, Object ... params) {
        String findQuery = JpaOperations.createFindQuery(entityClass, query, JpaOperations.paramCount(params));
        EntityManager em = JpaOperations.getEntityManager();
        Query jpaQuery = em.createQuery(sort != null ? findQuery + JpaOperations.toOrderBy(sort) : findQuery);
        JpaOperations.bindParameters(jpaQuery, params);
        return new CustomCountPanacheQuery(em, jpaQuery, findQuery, countQuery, params);
    }
}

