/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.hibernate.orm.runtime.Hibernate;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitsHolder;
import io.quarkus.runtime.annotations.Template;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.jboss.logging.Logger;

@Template
public class HibernateOrmTemplate {
    private List<String> entities = new ArrayList<String>();

    public void addEntity(String entityClass) {
        this.entities.add(entityClass);
    }

    public void enlistPersistenceUnit() {
        Logger.getLogger((String)"io.quarkus.hibernate.orm").debugf("List of entities found by Quarkus deployment:%n%s", this.entities);
    }

    public void callHibernateFeatureInit() {
        Hibernate.featureInit();
    }

    public BeanContainerListener initializeJpa(final boolean jtaEnabled) {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                ((JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0])).setJtaEnabled(jtaEnabled);
            }
        };
    }

    public BeanContainerListener registerPersistenceUnit(final String unitName) {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                ((JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0])).registerPersistenceUnit(unitName);
            }
        };
    }

    public BeanContainerListener initDefaultPersistenceUnit() {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                ((JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0])).initDefaultPersistenceUnit();
            }
        };
    }

    public BeanContainerListener initMetadata(final List<ParsedPersistenceXmlDescriptor> parsedPersistenceXmlDescriptors, final Scanner scanner) {
        return new BeanContainerListener(){

            public void created(BeanContainer beanContainer) {
                PersistenceUnitsHolder.initializeJpa(parsedPersistenceXmlDescriptors, scanner);
            }
        };
    }

    public void startAllPersistenceUnits(BeanContainer beanContainer) {
        ((JPAConfig)beanContainer.instance(JPAConfig.class, new Annotation[0])).startAll();
    }
}

