/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.hibernate.orm.runtime.boot.FastBootMetadataBuilder;
import io.quarkus.hibernate.orm.runtime.boot.LightPersistenceXmlDescriptor;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public final class PersistenceUnitsHolder {
    private static final String NO_NAME_TOKEN = "__no_name";
    private static volatile PersistenceUnits persistenceUnits;

    static void initializeJpa(List<ParsedPersistenceXmlDescriptor> parsedPersistenceXmlDescriptors, Scanner scanner) {
        List<PersistenceUnitDescriptor> units = PersistenceUnitsHolder.convertPersistenceUnits(parsedPersistenceXmlDescriptors);
        Map<String, RecordedState> metadata = PersistenceUnitsHolder.constructMetadataAdvance(units, scanner);
        persistenceUnits = new PersistenceUnits(units, metadata);
    }

    static List<PersistenceUnitDescriptor> getPersistenceUnitDescriptors() {
        PersistenceUnitsHolder.checkJPAInitialization();
        return persistenceUnits.units;
    }

    static RecordedState getRecordedState(String persistenceUnitName) {
        PersistenceUnitsHolder.checkJPAInitialization();
        String key = persistenceUnitName;
        if (persistenceUnitName == null) {
            key = NO_NAME_TOKEN;
        }
        return (RecordedState)persistenceUnits.recordedStates.get(key);
    }

    private static List<PersistenceUnitDescriptor> convertPersistenceUnits(List<ParsedPersistenceXmlDescriptor> parsedPersistenceXmlDescriptors) {
        try {
            return parsedPersistenceXmlDescriptors.stream().map(LightPersistenceXmlDescriptor::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new PersistenceException("Unable to locate persistence units", (Throwable)e);
        }
    }

    private static Map<String, RecordedState> constructMetadataAdvance(List<PersistenceUnitDescriptor> parsedPersistenceXmlDescriptors, Scanner scanner) {
        HashMap<String, RecordedState> recordedStates = new HashMap<String, RecordedState>();
        for (PersistenceUnitDescriptor unit : parsedPersistenceXmlDescriptors) {
            RecordedState m = PersistenceUnitsHolder.createMetadata(unit, scanner);
            RecordedState previous = recordedStates.put(PersistenceUnitsHolder.unitName(unit), m);
            if (previous == null) continue;
            throw new IllegalStateException("Duplicate persistence unit name: " + unit.getName());
        }
        return recordedStates;
    }

    private static void checkJPAInitialization() {
        if (persistenceUnits == null) {
            throw new RuntimeException("JPA not initialized yet by Quarkus: this is likely a bug.");
        }
    }

    private static String unitName(PersistenceUnitDescriptor unit) {
        String name = unit.getName();
        if (name == null) {
            return NO_NAME_TOKEN;
        }
        return name;
    }

    private static RecordedState createMetadata(PersistenceUnitDescriptor unit, Scanner scanner) {
        FastBootMetadataBuilder fastBootMetadataBuilder = new FastBootMetadataBuilder(unit, scanner);
        return fastBootMetadataBuilder.build();
    }

    private static class PersistenceUnits {
        private final List<PersistenceUnitDescriptor> units;
        private final Map<String, RecordedState> recordedStates;

        public PersistenceUnits(List<PersistenceUnitDescriptor> units, Map<String, RecordedState> recordedStates) {
            this.units = units;
            this.recordedStates = recordedStates;
        }
    }
}

