/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import io.quarkus.hibernate.orm.runtime.RuntimeSettings;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.spi.DelayedDropRegistry;
import org.hibernate.tool.schema.spi.DelayedDropRegistryNotAvailableImpl;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public final class FastBootEntityManagerFactoryBuilder
implements EntityManagerFactoryBuilder {
    private final MetadataImplementor metadata;
    private final String persistenceUnitName;
    private final StandardServiceRegistry standardServiceRegistry;
    private final RuntimeSettings runtimeSettings;
    private final Object validatorFactory;
    private final Object cdiBeanManager;

    public FastBootEntityManagerFactoryBuilder(MetadataImplementor metadata, String persistenceUnitName, StandardServiceRegistry standardServiceRegistry, RuntimeSettings runtimeSettings, Object validatorFactory, Object cdiBeanManager) {
        this.metadata = metadata;
        this.persistenceUnitName = persistenceUnitName;
        this.standardServiceRegistry = standardServiceRegistry;
        this.runtimeSettings = runtimeSettings;
        this.validatorFactory = validatorFactory;
        this.cdiBeanManager = cdiBeanManager;
    }

    public EntityManagerFactoryBuilder withValidatorFactory(Object validatorFactory) {
        return null;
    }

    public EntityManagerFactoryBuilder withDataSource(DataSource dataSource) {
        return null;
    }

    public EntityManagerFactory build() {
        SessionFactoryBuilder sfBuilder = this.metadata.getSessionFactoryBuilder();
        this.populate(sfBuilder, this.standardServiceRegistry);
        try {
            return sfBuilder.build();
        }
        catch (Exception e) {
            throw this.persistenceException("Unable to build Hibernate SessionFactory", e);
        }
    }

    public void cancel() {
    }

    public void generateSchema() {
        try {
            SessionFactoryBuilder sfBuilder = this.metadata.getSessionFactoryBuilder();
            this.populate(sfBuilder, this.standardServiceRegistry);
            SchemaManagementToolCoordinator.process((Metadata)this.metadata, (ServiceRegistry)this.standardServiceRegistry, this.runtimeSettings.getSettings(), (DelayedDropRegistry)DelayedDropRegistryNotAvailableImpl.INSTANCE);
        }
        catch (Exception e) {
            throw this.persistenceException("Error performing schema management", e);
        }
        this.cancel();
    }

    private PersistenceException persistenceException(String message, Exception cause) {
        for (Throwable t = cause; t != null; t = t.getCause()) {
            if (!(t instanceof NoSuchAlgorithmException)) continue;
            message = message + "Unable to enable SSL support. You might be in the case where you used the `quarkus.ssl.native=false` configuration and SSL was not disabled automatically for your driver.";
            break;
        }
        return new PersistenceException(this.getExceptionHeader() + message, (Throwable)cause);
    }

    private String getExceptionHeader() {
        return "[PersistenceUnit: " + this.persistenceUnitName + "] ";
    }

    protected void populate(SessionFactoryBuilder sfBuilder, StandardServiceRegistry ssr) {
        Object sessionFactoryObserverSetting;
        boolean allowRefreshDetachedEntity;
        boolean jtaTransactionAccessEnabled = this.runtimeSettings.getBoolean("hibernate.jta.allowTransactionAccess");
        if (!jtaTransactionAccessEnabled) {
            ((SessionFactoryBuilderImplementor)sfBuilder).disableJtaTransactionAccess();
        }
        if (!(allowRefreshDetachedEntity = this.runtimeSettings.getBoolean("hibernate.allow_refresh_detached_entity"))) {
            ((SessionFactoryBuilderImplementor)sfBuilder).disableRefreshDetachedEntity();
        }
        if ((sessionFactoryObserverSetting = this.runtimeSettings.get("hibernate.ejb.session_factory_observer")) != null) {
            StrategySelector strategySelector = (StrategySelector)ssr.getService(StrategySelector.class);
            SessionFactoryObserver suppliedSessionFactoryObserver = (SessionFactoryObserver)strategySelector.resolveStrategy(SessionFactoryObserver.class, sessionFactoryObserverSetting);
            sfBuilder.addSessionFactoryObservers(new SessionFactoryObserver[]{suppliedSessionFactoryObserver});
        }
        sfBuilder.addSessionFactoryObservers(new SessionFactoryObserver[]{new ServiceRegistryCloser()});
        sfBuilder.applyEntityNotFoundDelegate((EntityNotFoundDelegate)new JpaEntityNotFoundDelegate());
        if (this.validatorFactory != null) {
            sfBuilder.applyValidatorFactory(this.validatorFactory);
        }
        if (this.cdiBeanManager != null) {
            sfBuilder.applyBeanManager(this.cdiBeanManager);
        }
    }

    private static class JpaEntityNotFoundDelegate
    implements EntityNotFoundDelegate,
    Serializable {
        private JpaEntityNotFoundDelegate() {
        }

        public void handleEntityNotFound(String entityName, Serializable id) {
            throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id);
        }
    }

    private static class ServiceRegistryCloser
    implements SessionFactoryObserver {
        private ServiceRegistryCloser() {
        }

        public void sessionFactoryCreated(SessionFactory sessionFactory) {
        }

        public void sessionFactoryClosed(SessionFactory sessionFactory) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            sfi.getServiceRegistry().destroy();
            ServiceRegistry basicRegistry = sfi.getServiceRegistry().getParentServiceRegistry();
            ((ServiceRegistryImplementor)basicRegistry).destroy();
        }
    }
}

