/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot.registry;

import io.quarkus.hibernate.orm.runtime.boot.registry.MirroringIntegratorService;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import io.quarkus.hibernate.orm.runtime.service.CfgXmlAccessServiceInitiatorQuarkus;
import io.quarkus.hibernate.orm.runtime.service.DisabledJMXInitiator;
import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import io.quarkus.hibernate.orm.runtime.service.QuarkusJdbcEnvironmentInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusJtaPlatformResolver;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRegionFactoryInitiator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.boot.registry.selector.internal.StrategySelectorImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.internal.ConfigurationServiceInitiator;
import org.hibernate.engine.jdbc.batch.internal.BatchBuilderInitiator;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.MultiTenantConnectionProviderInitiator;
import org.hibernate.engine.jdbc.cursor.internal.RefCursorSupportInitiator;
import org.hibernate.engine.jdbc.internal.JdbcServicesInitiator;
import org.hibernate.engine.jndi.internal.JndiServiceInitiator;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JtaPlatformInitiator;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.event.internal.EntityCopyObserverFactoryInitiator;
import org.hibernate.hql.internal.QueryTranslatorFactoryInitiator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.persister.internal.PersisterClassResolverInitiator;
import org.hibernate.persister.internal.PersisterFactoryInitiator;
import org.hibernate.property.access.internal.PropertyAccessStrategyResolverInitiator;
import org.hibernate.resource.beans.spi.ManagedBeanRegistryInitiator;
import org.hibernate.resource.transaction.internal.TransactionCoordinatorBuilderInitiator;
import org.hibernate.service.Service;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.SessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractorInitiator;
import org.hibernate.tool.schema.internal.SchemaManagementToolInitiator;

public class PreconfiguredServiceRegistryBuilder {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(PreconfiguredServiceRegistryBuilder.class);
    private final Map configurationValues = new HashMap();
    private final List<StandardServiceInitiator> initiators;
    private final List<ProvidedService> providedServices = new ArrayList<ProvidedService>();
    private final MirroringIntegratorService integrators = new MirroringIntegratorService();
    private final StandardServiceRegistryImpl destroyedRegistry;

    public PreconfiguredServiceRegistryBuilder(RecordedState rs) {
        this.initiators = PreconfiguredServiceRegistryBuilder.buildQuarkusServiceInitiatorList(rs);
        this.destroyedRegistry = (StandardServiceRegistryImpl)rs.getMetadata().getMetadataBuildingOptions().getServiceRegistry();
    }

    public PreconfiguredServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.configurationValues.put(settingName, value);
        return this;
    }

    public PreconfiguredServiceRegistryBuilder applyIntegrator(Integrator integrator) {
        this.integrators.addIntegrator(integrator);
        return this;
    }

    public PreconfiguredServiceRegistryBuilder addInitiator(StandardServiceInitiator initiator) {
        this.initiators.add(initiator);
        return this;
    }

    public PreconfiguredServiceRegistryBuilder addService(Class serviceRole, Service service) {
        this.providedServices.add(new ProvidedService(serviceRole, (Object)service));
        return this;
    }

    public StandardServiceRegistryImpl buildNewServiceRegistry() {
        BootstrapServiceRegistry bootstrapServiceRegistry = this.buildEmptyBootstrapServiceRegistry();
        HashMap settingsCopy = new HashMap();
        settingsCopy.putAll(this.configurationValues);
        ConfigurationHelper.resolvePlaceHolders(settingsCopy);
        this.destroyedRegistry.resetAndReactivate(bootstrapServiceRegistry, this.initiators, this.providedServices, settingsCopy);
        return this.destroyedRegistry;
    }

    private BootstrapServiceRegistry buildEmptyBootstrapServiceRegistry() {
        StrategySelectorImpl strategySelector = new StrategySelectorImpl(FlatClassLoaderService.INSTANCE);
        return new BootstrapServiceRegistryImpl(true, FlatClassLoaderService.INSTANCE, (StrategySelector)strategySelector, (IntegratorService)this.integrators);
    }

    private static List<StandardServiceInitiator> buildQuarkusServiceInitiatorList(RecordedState rs) {
        ArrayList<StandardServiceInitiator> serviceInitiators = new ArrayList<StandardServiceInitiator>();
        serviceInitiators.add(CfgXmlAccessServiceInitiatorQuarkus.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ConfigurationServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)PropertyAccessStrategyResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ImportSqlCommandExtractorInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)SchemaManagementToolInitiator.INSTANCE);
        serviceInitiators.add(new QuarkusJdbcEnvironmentInitiator(rs.getDialect()));
        serviceInitiators.add((StandardServiceInitiator)JndiServiceInitiator.INSTANCE);
        serviceInitiators.add(DisabledJMXInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)PersisterClassResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)PersisterFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)MultiTenantConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)BatchBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)JdbcServicesInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)RefCursorSupportInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)QueryTranslatorFactoryInitiator.INSTANCE);
        serviceInitiators.add(new QuarkusJtaPlatformResolver(rs.getJtaPlatform()));
        serviceInitiators.add((StandardServiceInitiator)new JtaPlatformInitiator(){

            protected JtaPlatform getFallbackProvider(Map configurationValues, ServiceRegistryImplementor registry) {
                return new JBossStandAloneJtaPlatform();
            }
        });
        serviceInitiators.add((StandardServiceInitiator)SessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceInitiators.add(QuarkusRegionFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)TransactionCoordinatorBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ManagedBeanRegistryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)EntityCopyObserverFactoryInitiator.INSTANCE);
        serviceInitiators.trimToSize();
        return serviceInitiators;
    }
}

