/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.entitymanager;

import io.quarkus.hibernate.orm.runtime.RequestScopedEntityManagerHolder;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionScopedEntityManager
implements EntityManager {
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry tsr;
    private final EntityManagerFactory emf;
    private final String unitName;
    private static final Object transactionKey = new Object();
    private final Instance<RequestScopedEntityManagerHolder> requestScopedEms;

    public TransactionScopedEntityManager(TransactionManager transactionManager, TransactionSynchronizationRegistry tsr, EntityManagerFactory emf, String unitName, Instance<RequestScopedEntityManagerHolder> requestScopedEms) {
        this.transactionManager = transactionManager;
        this.tsr = tsr;
        this.emf = emf;
        this.unitName = unitName;
        this.requestScopedEms = requestScopedEms;
    }

    EntityManagerResult getEntityManager() {
        if (this.isInTransaction()) {
            EntityManager em = (EntityManager)this.tsr.getResource(transactionKey);
            if (em != null) {
                return new EntityManagerResult(em, false);
            }
            final EntityManager newEm = this.emf.createEntityManager();
            newEm.joinTransaction();
            this.tsr.putResource(transactionKey, (Object)newEm);
            this.tsr.registerInterposedSynchronization(new Synchronization(){

                public void beforeCompletion() {
                    newEm.flush();
                    newEm.close();
                }

                public void afterCompletion(int i) {
                    newEm.close();
                }
            });
            return new EntityManagerResult(newEm, false);
        }
        RequestScopedEntityManagerHolder requestScopedEms = (RequestScopedEntityManagerHolder)this.requestScopedEms.get();
        return new EntityManagerResult(requestScopedEms.getOrCreateEntityManager(this.unitName, this.emf), false);
    }

    private boolean isInTransaction() {
        try {
            switch (this.transactionManager.getStatus()) {
                case 0: 
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void persist(Object entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.persist(entity);
        }
    }

    public <T> T merge(T entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.em.merge(entity);
            return (T)object;
        }
    }

    public void remove(Object entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.remove(entity);
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.em.find(entityClass, primaryKey);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.em.find(entityClass, primaryKey, properties);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.em.find(entityClass, primaryKey, lockMode);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.em.find(entityClass, primaryKey, lockMode, properties);
            return (T)object;
        }
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.em.getReference(entityClass, primaryKey);
            return (T)object;
        }
    }

    public void flush() {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.flush();
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.setFlushMode(flushMode);
        }
    }

    public FlushModeType getFlushMode() {
        try (EntityManagerResult emr = this.getEntityManager();){
            FlushModeType flushModeType = emr.em.getFlushMode();
            return flushModeType;
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.lock(entity, lockMode);
        }
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.lock(entity, lockMode, properties);
        }
    }

    public void refresh(Object entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.refresh(entity);
        }
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.refresh(entity, properties);
        }
    }

    public void refresh(Object entity, LockModeType lockMode) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.refresh(entity, lockMode);
        }
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.refresh(entity, lockMode, properties);
        }
    }

    public void clear() {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.clear();
        }
    }

    public void detach(Object entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.detach(entity);
        }
    }

    public boolean contains(Object entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            boolean bl = emr.em.contains(entity);
            return bl;
        }
    }

    public LockModeType getLockMode(Object entity) {
        try (EntityManagerResult emr = this.getEntityManager();){
            LockModeType lockModeType = emr.em.getLockMode(entity);
            return lockModeType;
        }
    }

    public void setProperty(String propertyName, Object value) {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.setProperty(propertyName, value);
        }
    }

    public Map<String, Object> getProperties() {
        try (EntityManagerResult emr = this.getEntityManager();){
            Map map = emr.em.getProperties();
            return map;
        }
    }

    public Query createQuery(String qlString) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.em.createQuery(qlString);
            return query;
        }
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        try (EntityManagerResult emr = this.getEntityManager();){
            TypedQuery typedQuery = emr.em.createQuery(criteriaQuery);
            return typedQuery;
        }
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.em.createQuery(updateQuery);
            return query;
        }
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.em.createQuery(deleteQuery);
            return query;
        }
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        try (EntityManagerResult emr = this.getEntityManager();){
            TypedQuery typedQuery = emr.em.createQuery(qlString, resultClass);
            return typedQuery;
        }
    }

    public Query createNamedQuery(String name) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.em.createNamedQuery(name);
            return query;
        }
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        try (EntityManagerResult emr = this.getEntityManager();){
            TypedQuery typedQuery = emr.em.createNamedQuery(name, resultClass);
            return typedQuery;
        }
    }

    public Query createNativeQuery(String sqlString) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.em.createNativeQuery(sqlString);
            return query;
        }
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.em.createNativeQuery(sqlString, resultClass);
            return query;
        }
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Query query = emr.em.createNativeQuery(sqlString, resultSetMapping);
            return query;
        }
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        try (EntityManagerResult emr = this.getEntityManager();){
            StoredProcedureQuery storedProcedureQuery = emr.em.createNamedStoredProcedureQuery(name);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        try (EntityManagerResult emr = this.getEntityManager();){
            StoredProcedureQuery storedProcedureQuery = emr.em.createStoredProcedureQuery(procedureName);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        try (EntityManagerResult emr = this.getEntityManager();){
            StoredProcedureQuery storedProcedureQuery = emr.em.createStoredProcedureQuery(procedureName, resultClasses);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        try (EntityManagerResult emr = this.getEntityManager();){
            StoredProcedureQuery storedProcedureQuery = emr.em.createStoredProcedureQuery(procedureName, resultSetMappings);
            return storedProcedureQuery;
        }
    }

    public void joinTransaction() {
        try (EntityManagerResult emr = this.getEntityManager();){
            emr.em.joinTransaction();
        }
    }

    public boolean isJoinedToTransaction() {
        try (EntityManagerResult emr = this.getEntityManager();){
            boolean bl = emr.em.isJoinedToTransaction();
            return bl;
        }
    }

    public <T> T unwrap(Class<T> cls) {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.em.unwrap(cls);
            return (T)object;
        }
    }

    public Object getDelegate() {
        try (EntityManagerResult emr = this.getEntityManager();){
            Object object = emr.em.getDelegate();
            return object;
        }
    }

    public void close() {
        throw new IllegalStateException("Not supported for transaction scoped entity managers");
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("Not supported for JTA entity managers");
    }

    public EntityManagerFactory getEntityManagerFactory() {
        try (EntityManagerResult emr = this.getEntityManager();){
            EntityManagerFactory entityManagerFactory = emr.em.getEntityManagerFactory();
            return entityManagerFactory;
        }
    }

    public CriteriaBuilder getCriteriaBuilder() {
        try (EntityManagerResult emr = this.getEntityManager();){
            CriteriaBuilder criteriaBuilder = emr.em.getCriteriaBuilder();
            return criteriaBuilder;
        }
    }

    public Metamodel getMetamodel() {
        try (EntityManagerResult emr = this.getEntityManager();){
            Metamodel metamodel = emr.em.getMetamodel();
            return metamodel;
        }
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        try (EntityManagerResult emr = this.getEntityManager();){
            EntityGraph entityGraph = emr.em.createEntityGraph(rootType);
            return entityGraph;
        }
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        try (EntityManagerResult emr = this.getEntityManager();){
            EntityGraph entityGraph = emr.em.createEntityGraph(graphName);
            return entityGraph;
        }
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        try (EntityManagerResult emr = this.getEntityManager();){
            EntityGraph entityGraph = emr.em.getEntityGraph(graphName);
            return entityGraph;
        }
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        try (EntityManagerResult emr = this.getEntityManager();){
            List list = emr.em.getEntityGraphs(entityClass);
            return list;
        }
    }

    static class EntityManagerResult
    implements AutoCloseable {
        private final EntityManager em;
        private final boolean closeOnEnd;

        EntityManagerResult(EntityManager em, boolean closeOnEnd) {
            this.em = em;
            this.closeOnEnd = closeOnEnd;
        }

        @Override
        public void close() {
            if (this.closeOnEnd) {
                this.em.close();
            }
        }
    }
}

