/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import io.quarkus.hibernate.orm.runtime.BuildTimeSettings;
import io.quarkus.hibernate.orm.runtime.IntegrationSettings;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrations;
import io.quarkus.hibernate.orm.runtime.recording.RecordableBootstrap;
import io.quarkus.hibernate.orm.runtime.recording.RecordedState;
import io.quarkus.hibernate.orm.runtime.recording.RecordingDialectFactory;
import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.boot.CacheRegionDefinition;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.archive.scan.internal.StandardScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.Scanner;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.model.process.spi.MetadataBuildingProcess;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuilderContributor;
import org.hibernate.boot.spi.MetadataBuilderImplementor;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.internal.CollectionCacheInvalidator;
import org.hibernate.cfg.beanvalidation.BeanValidationIntegrator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.boot.internal.StandardJpaScanEnvironmentImpl;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.TypeContributorList;
import org.hibernate.jpa.internal.util.LogHelper;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;
import org.hibernate.resource.transaction.backend.jdbc.internal.JdbcResourceLocalTransactionCoordinatorBuilderImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionCoordinatorBuilderImpl;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.AbstractServiceRegistryImpl;
import org.hibernate.service.internal.ProvidedService;
import org.infinispan.quarkus.hibernate.cache.QuarkusInfinispanRegionFactory;

public class FastBootMetadataBuilder {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(FastBootMetadataBuilder.class);
    private final PersistenceUnitDescriptor persistenceUnit;
    private final BuildTimeSettings buildTimeSettings;
    private final StandardServiceRegistry standardServiceRegistry;
    private final ManagedResources managedResources;
    private final MetadataBuilderImplementor metamodelBuilder;
    private final Object validatorFactory;
    private final Collection<Class<? extends Integrator>> additionalIntegrators;
    private final Collection<ProvidedService> providedServices;

    public FastBootMetadataBuilder(PersistenceUnitDescriptor persistenceUnit, Scanner scanner, Collection<Class<? extends Integrator>> additionalIntegrators) {
        this.persistenceUnit = persistenceUnit;
        this.additionalIntegrators = additionalIntegrators;
        ClassLoaderService providedClassLoaderService = FlatClassLoaderService.INSTANCE;
        Object providedClassLoader = null;
        LogHelper.logPersistenceUnitInformation((PersistenceUnitDescriptor)persistenceUnit);
        BootstrapServiceRegistry bsr = this.buildBootstrapServiceRegistry(providedClassLoaderService);
        RecordableBootstrap ssrBuilder = new RecordableBootstrap(bsr);
        this.insertStateRecorders(ssrBuilder);
        MergedSettings mergedSettings = this.mergeSettings(persistenceUnit);
        this.buildTimeSettings = new BuildTimeSettings(mergedSettings.getConfigurationValues());
        ssrBuilder.applySettings(this.buildTimeSettings.getSettings());
        this.standardServiceRegistry = ssrBuilder.build();
        this.registerIdentifierGenerators(this.standardServiceRegistry);
        this.providedServices = ssrBuilder.getProvidedServices();
        for (Class<? extends Service> postBuildProvidedService : ssrBuilder.getPostBuildProvidedServices()) {
            this.providedServices.add(new ProvidedService(postBuildProvidedService, (Object)this.standardServiceRegistry.getService(postBuildProvidedService)));
        }
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)bsr);
        this.addPUManagedClassNamesToMetadataSources(persistenceUnit, metadataSources);
        this.metamodelBuilder = (MetadataBuilderImplementor)metadataSources.getMetadataBuilder(this.standardServiceRegistry);
        if (scanner != null) {
            this.metamodelBuilder.applyScanner(scanner);
        }
        this.populate((MetadataBuilder)this.metamodelBuilder, mergedSettings.cacheRegionDefinitions, this.standardServiceRegistry);
        this.managedResources = MetadataBuildingProcess.prepare((MetadataSources)metadataSources, (BootstrapContext)this.metamodelBuilder.getBootstrapContext());
        this.applyMetadataBuilderContributor();
        this.validatorFactory = this.withValidatorFactory(this.buildTimeSettings.get("javax.persistence.validation.factory"));
        this.metamodelBuilder.applyTempClassLoader(null);
    }

    private void addPUManagedClassNamesToMetadataSources(PersistenceUnitDescriptor persistenceUnit, MetadataSources metadataSources) {
        for (String className : persistenceUnit.getManagedClassNames()) {
            metadataSources.addAnnotatedClassName(className);
        }
    }

    private void insertStateRecorders(StandardServiceRegistryBuilder ssrBuilder) {
    }

    private BootstrapServiceRegistry buildBootstrapServiceRegistry(ClassLoaderService providedClassLoaderService) {
        BootstrapServiceRegistryBuilder bsrBuilder = new BootstrapServiceRegistryBuilder();
        bsrBuilder.applyClassLoaderService(providedClassLoaderService);
        return bsrBuilder.build();
    }

    private MergedSettings mergeSettings(PersistenceUnitDescriptor persistenceUnit) {
        MergedSettings mergedSettings = new MergedSettings();
        Map cfg = mergedSettings.configurationValues;
        if (persistenceUnit.getProperties() != null) {
            cfg.putAll(persistenceUnit.getProperties());
        }
        cfg.put("hibernate.ejb.persistenceUnitName", persistenceUnit.getName());
        FastBootMetadataBuilder.applyTransactionProperties(persistenceUnit, cfg);
        FastBootMetadataBuilder.applyJdbcConnectionProperties(cfg);
        if (this.readBooleanConfigurationValue(cfg, "hibernate.transaction.flush_before_completion")) {
            cfg.put("hibernate.transaction.flush_before_completion", "false");
            LOG.definingFlushBeforeCompletionIgnoredInHem("hibernate.transaction.flush_before_completion");
        }
        cfg.put("hibernate.temp.use_jdbc_metadata_defaults", "false");
        if (!cfg.containsKey("hibernate.bytecode.allow_enhancement_as_proxy")) {
            cfg.put("hibernate.bytecode.allow_enhancement_as_proxy", Boolean.TRUE.toString());
        }
        if (!cfg.containsKey("hibernate.order_updates")) {
            cfg.put("hibernate.order_updates", Boolean.TRUE.toString());
        }
        cfg.put("hibernate.connection.provider_disables_autocommit", Boolean.TRUE.toString());
        if (this.readBooleanConfigurationValue(cfg, "hibernate.jdbc.wrap_result_sets")) {
            LOG.warn((Object)"Wrapping result sets is not supported. Setting hibernate.jdbc.wrap_result_sets to false.");
        }
        cfg.put("hibernate.jdbc.wrap_result_sets", "false");
        if (this.readBooleanConfigurationValue(cfg, "hibernate.xml_mapping_enabled")) {
            LOG.warn((Object)"XML mapping is not supported. Setting hibernate.xml_mapping_enabled to false.");
        }
        cfg.put("hibernate.xml_mapping_enabled", "false");
        if (cfg.containsKey("hibernate.jacc.enabled")) {
            LOG.warn((Object)"JACC is not supported. Disabling it.");
        }
        cfg.remove("hibernate.jacc.enabled");
        this.enableCachingByDefault(cfg);
        Iterator itr = cfg.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (entry.getValue() == null) {
                itr.remove();
                break;
            }
            if (!String.class.isInstance(entry.getKey()) || !String.class.isInstance(entry.getValue())) continue;
            String keyString = (String)entry.getKey();
            String valueString = (String)entry.getValue();
            if (keyString.startsWith("hibernate.jacc")) {
                LOG.warn((Object)"Found JACC permission grant [%s] in properties, but JACC is not compatible with the FastBootMetadataBuilder; ignoring!");
                continue;
            }
            if (keyString.startsWith("hibernate.ejb.classcache")) {
                mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.ejb.classcache".length() + 1), valueString, CacheRegionDefinition.CacheRegionType.ENTITY));
                continue;
            }
            if (!keyString.startsWith("hibernate.ejb.collectioncache")) continue;
            mergedSettings.addCacheRegionDefinition(this.parseCacheRegionDefinitionEntry(keyString.substring("hibernate.ejb.collectioncache".length() + 1), (String)entry.getValue(), CacheRegionDefinition.CacheRegionType.COLLECTION));
        }
        cfg.put("hibernate.cache.region.factory_class", QuarkusInfinispanRegionFactory.class.getName());
        HibernateOrmIntegrations.contributeBootProperties((k, v) -> cfg.put(k, v));
        return mergedSettings;
    }

    private void enableCachingByDefault(Map<String, Object> configurationValues) {
        configurationValues.putIfAbsent("hibernate.cache.use_reference_entries", Boolean.TRUE);
        configurationValues.putIfAbsent("hibernate.cache.use_second_level_cache", Boolean.TRUE);
        configurationValues.putIfAbsent("hibernate.cache.use_query_cache", Boolean.TRUE);
        configurationValues.putIfAbsent("javax.persistence.sharedCache.mode", SharedCacheMode.ENABLE_SELECTIVE);
    }

    public RecordedState build() {
        MetadataImpl fullMeta = (MetadataImpl)MetadataBuildingProcess.complete((ManagedResources)this.managedResources, (BootstrapContext)this.metamodelBuilder.getBootstrapContext(), (MetadataBuildingOptions)this.metamodelBuilder.getMetadataBuildingOptions());
        IntegrationSettings.Builder integrationSettingsBuilder = new IntegrationSettings.Builder();
        HibernateOrmIntegrations.onMetadataInitialized((Metadata)fullMeta, this.metamodelBuilder.getBootstrapContext(), (k, v) -> integrationSettingsBuilder.put((String)k, v));
        Dialect dialect = this.extractDialect();
        JtaPlatform jtaPlatform = this.extractJtaPlatform();
        this.destroyServiceRegistry((MetadataImplementor)fullMeta);
        MetadataImplementor storeableMetadata = this.trimBootstrapMetadata(fullMeta);
        return new RecordedState(dialect, jtaPlatform, storeableMetadata, this.buildTimeSettings, this.getIntegrators(), this.providedServices, integrationSettingsBuilder.build());
    }

    private void destroyServiceRegistry(MetadataImplementor fullMeta) {
        AbstractServiceRegistryImpl serviceRegistry = (AbstractServiceRegistryImpl)this.metamodelBuilder.getBootstrapContext().getServiceRegistry();
        serviceRegistry.close();
        serviceRegistry.resetParent(null);
    }

    private MetadataImplementor trimBootstrapMetadata(MetadataImpl fullMeta) {
        MetadataImpl replacement = new MetadataImpl(fullMeta.getUUID(), fullMeta.getMetadataBuildingOptions(), fullMeta.getIdentifierGeneratorFactory(), fullMeta.getEntityBindingMap(), fullMeta.getMappedSuperclassMap(), fullMeta.getCollectionBindingMap(), fullMeta.getTypeDefinitionMap(), fullMeta.getFilterDefinitions(), fullMeta.getFetchProfileMap(), fullMeta.getImports(), fullMeta.getIdGeneratorDefinitionMap(), fullMeta.getNamedQueryMap(), fullMeta.getNamedNativeQueryMap(), fullMeta.getNamedProcedureCallMap(), fullMeta.getSqlResultSetMappingMap(), fullMeta.getNamedEntityGraphs(), fullMeta.getSqlFunctionMap(), fullMeta.getDatabase(), fullMeta.getBootstrapContext());
        return replacement;
    }

    private JtaPlatform extractJtaPlatform() {
        return new JBossStandAloneJtaPlatform();
    }

    private Dialect extractDialect() {
        DialectFactory service = (DialectFactory)this.standardServiceRegistry.getService(DialectFactory.class);
        RecordingDialectFactory casted = (RecordingDialectFactory)service;
        return casted.getDialect();
    }

    private Collection<Integrator> getIntegrators() {
        LinkedHashSet<Integrator> integrators = new LinkedHashSet<Integrator>();
        integrators.add((Integrator)new BeanValidationIntegrator());
        integrators.add((Integrator)new CollectionCacheInvalidator());
        for (Class<? extends Integrator> integratorClass : this.additionalIntegrators) {
            try {
                integrators.add(integratorClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate integrator " + integratorClass, e);
            }
        }
        return integrators;
    }

    private boolean readBooleanConfigurationValue(Map configurationValues, String propertyName) {
        Object propertyValue = configurationValues.get(propertyName);
        return propertyValue != null && Boolean.parseBoolean(propertyValue.toString());
    }

    private CacheRegionDefinition parseCacheRegionDefinitionEntry(String role, String value, CacheRegionDefinition.CacheRegionType cacheType) {
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuilder error = new StringBuilder("Illegal usage of ");
            if (cacheType == CacheRegionDefinition.CacheRegionType.ENTITY) {
                error.append("hibernate.ejb.classcache").append(": ").append("hibernate.ejb.classcache");
            } else {
                error.append("hibernate.ejb.collectioncache").append(": ").append("hibernate.ejb.collectioncache");
            }
            error.append('.').append(role).append(' ').append(value).append(".  Was expecting configuration (usage[,region[,lazy]]), but found none");
            throw this.persistenceException(error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        boolean lazyProperty = true;
        if (cacheType == CacheRegionDefinition.CacheRegionType.ENTITY) {
            if (params.hasMoreTokens()) {
                lazyProperty = "all".equalsIgnoreCase(params.nextToken());
            }
        } else {
            lazyProperty = false;
        }
        return new CacheRegionDefinition(cacheType, role, usage, region, lazyProperty);
    }

    private PersistenceException persistenceException(String message) {
        return this.persistenceException(message, null);
    }

    private PersistenceException persistenceException(String message, Exception cause) {
        return new PersistenceException(this.getExceptionHeader() + message, (Throwable)cause);
    }

    private String getExceptionHeader() {
        return "[PersistenceUnit: " + this.persistenceUnit.getName() + "] ";
    }

    private static void applyJdbcConnectionProperties(Map<String, Object> configurationValues) {
        String pass;
        String user;
        String url;
        String driver = (String)configurationValues.get("javax.persistence.jdbc.driver");
        if (StringHelper.isNotEmpty((String)driver)) {
            configurationValues.put("hibernate.connection.driver_class", driver);
        }
        if (StringHelper.isNotEmpty((String)(url = (String)configurationValues.get("javax.persistence.jdbc.url")))) {
            configurationValues.put("hibernate.connection.url", url);
        }
        if (StringHelper.isNotEmpty((String)(user = (String)configurationValues.get("javax.persistence.jdbc.user")))) {
            configurationValues.put("hibernate.connection.username", user);
        }
        if (StringHelper.isNotEmpty((String)(pass = (String)configurationValues.get("javax.persistence.jdbc.password")))) {
            configurationValues.put("hibernate.connection.password", pass);
        }
    }

    private static void applyTransactionProperties(PersistenceUnitDescriptor persistenceUnit, Map<String, Object> configurationValues) {
        boolean hasTransactionStrategy;
        PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionTypeHelper.interpretTransactionType((Object)configurationValues.get("javax.persistence.transactionType"));
        if (transactionType == null) {
            transactionType = persistenceUnit.getTransactionType();
        }
        if (transactionType == null) {
            transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        if (hasTransactionStrategy = configurationValues.containsKey("hibernate.transaction.coordinator_class")) {
            LOG.overridingTransactionStrategyDangerous("hibernate.transaction.coordinator_class");
        } else if (transactionType == PersistenceUnitTransactionType.JTA) {
            configurationValues.put("hibernate.transaction.coordinator_class", JtaTransactionCoordinatorBuilderImpl.class);
        } else if (transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            configurationValues.put("hibernate.transaction.coordinator_class", JdbcResourceLocalTransactionCoordinatorBuilderImpl.class);
        }
    }

    private void registerIdentifierGenerators(StandardServiceRegistry ssr) {
        StrategySelector strategySelector = (StrategySelector)ssr.getService(StrategySelector.class);
        Object idGeneratorStrategyProviderSetting = this.buildTimeSettings.get("hibernate.ejb.identifier_generator_strategy_provider");
        if (idGeneratorStrategyProviderSetting != null) {
            IdentifierGeneratorStrategyProvider idGeneratorStrategyProvider = (IdentifierGeneratorStrategyProvider)strategySelector.resolveStrategy(IdentifierGeneratorStrategyProvider.class, idGeneratorStrategyProviderSetting);
            MutableIdentifierGeneratorFactory identifierGeneratorFactory = (MutableIdentifierGeneratorFactory)ssr.getService(MutableIdentifierGeneratorFactory.class);
            if (identifierGeneratorFactory == null) {
                throw this.persistenceException("Application requested custom identifier generator strategies, but the MutableIdentifierGeneratorFactory could not be found");
            }
            for (Map.Entry entry : idGeneratorStrategyProvider.getStrategies().entrySet()) {
                identifierGeneratorFactory.register((String)entry.getKey(), (Class)entry.getValue());
            }
        }
    }

    protected void populate(MetadataBuilder metamodelBuilder, List<CacheRegionDefinition> cacheRegionDefinitions, StandardServiceRegistry ssr) {
        TypeContributorList typeContributorList;
        ((MetadataBuilderImplementor)metamodelBuilder).getBootstrapContext().markAsJpaBootstrap();
        metamodelBuilder.applyScanEnvironment((ScanEnvironment)new StandardJpaScanEnvironmentImpl(this.persistenceUnit));
        metamodelBuilder.applyScanOptions((ScanOptions)new StandardScanOptions((String)this.buildTimeSettings.get("hibernate.archive.autodetection"), this.persistenceUnit.isExcludeUnlistedClasses()));
        if (cacheRegionDefinitions != null) {
            cacheRegionDefinitions.forEach(arg_0 -> ((MetadataBuilder)metamodelBuilder).applyCacheRegionDefinition(arg_0));
        }
        if ((typeContributorList = (TypeContributorList)this.buildTimeSettings.get("hibernate.type_contributors")) != null) {
            typeContributorList.getTypeContributors().forEach(arg_0 -> ((MetadataBuilder)metamodelBuilder).applyTypes(arg_0));
        }
    }

    private void applyMetadataBuilderContributor() {
        Object metadataBuilderContributorSetting = this.buildTimeSettings.get("hibernate.metadata_builder_contributor");
        if (metadataBuilderContributorSetting == null) {
            return;
        }
        MetadataBuilderContributor metadataBuilderContributor = null;
        Class metadataBuilderContributorImplClass = null;
        if (metadataBuilderContributorSetting instanceof MetadataBuilderContributor) {
            metadataBuilderContributor = (MetadataBuilderContributor)metadataBuilderContributorSetting;
        } else if (metadataBuilderContributorSetting instanceof Class) {
            metadataBuilderContributorImplClass = (Class)metadataBuilderContributorSetting;
        } else if (metadataBuilderContributorSetting instanceof String) {
            ClassLoaderService classLoaderService = (ClassLoaderService)this.standardServiceRegistry.getService(ClassLoaderService.class);
            metadataBuilderContributorImplClass = classLoaderService.classForName((String)metadataBuilderContributorSetting);
        } else {
            throw new IllegalArgumentException("The provided hibernate.metadata_builder_contributor setting value [" + metadataBuilderContributorSetting + "] is not supported!");
        }
        if (metadataBuilderContributorImplClass != null) {
            try {
                metadataBuilderContributor = (MetadataBuilderContributor)metadataBuilderContributorImplClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("The MetadataBuilderContributor class [" + metadataBuilderContributorImplClass + "] could not be instantiated!", e);
            }
        }
        if (metadataBuilderContributor != null) {
            metadataBuilderContributor.contribute((MetadataBuilder)this.metamodelBuilder);
        }
    }

    public Object withValidatorFactory(Object validatorFactory) {
        if (validatorFactory != null) {
            BeanValidationIntegrator.validateFactory((Object)validatorFactory);
        }
        return validatorFactory;
    }

    private static class MergedSettings {
        private final Map configurationValues = new ConcurrentHashMap(16, 0.75f, 1);
        private List<CacheRegionDefinition> cacheRegionDefinitions;

        private MergedSettings() {
        }

        public Map getConfigurationValues() {
            return this.configurationValues;
        }

        private void addCacheRegionDefinition(CacheRegionDefinition cacheRegionDefinition) {
            if (this.cacheRegionDefinitions == null) {
                this.cacheRegionDefinitions = new ArrayList<CacheRegionDefinition>();
            }
            this.cacheRegionDefinitions.add(cacheRegionDefinition);
        }
    }
}

