/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class QuarkusEnvironment {
    private static final Map GLOBAL_INITIAL_PROPERTIES;

    public static Map getInitialProperties() {
        return GLOBAL_INITIAL_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            InputStream stream = classLoader.getResourceAsStream("/hibernate.properties");
            if (stream != null) {
                CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Environment.class.getName());
                LOG.warnf("The resource hibernate.properties was found in the root of your application. This configuration source is deprecated and will be removed in a future version of Quarkus, as it's not compatible with Live Coding, multiple Persistence Units and many more cool features we have planned. Please refrain from using it to configure your ORM and use the available configurations in application.properties (check the guide in https://quarkus.io/guides/hibernate-orm#quarkus-hibernate-orm_configuration). Should no configuration exist for your use case please report in: https://github.com/quarkusio/quarkus/issues/. Thank you! ", new Object[0]);
                Properties p = new Properties();
                try {
                    p.load(stream);
                }
                catch (Exception e) {
                    LOG.unableToLoadProperties();
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException ioe) {
                        LOG.unableToCloseStreamError(ioe);
                    }
                }
                GLOBAL_INITIAL_PROPERTIES = Collections.unmodifiableMap(p);
            } else {
                GLOBAL_INITIAL_PROPERTIES = Collections.EMPTY_MAP;
            }
        } else {
            GLOBAL_INITIAL_PROPERTIES = Collections.EMPTY_MAP;
        }
    }
}

