/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import io.quarkus.hibernate.orm.runtime.boot.QuarkusPersistenceUnitDefinition;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusIntegratorServiceImpl;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusStrategySelectorBuilder;
import io.quarkus.hibernate.orm.runtime.recording.RecordableBootstrap;
import io.quarkus.hibernate.orm.runtime.service.FlatClassLoaderService;
import io.quarkus.hibernate.orm.runtime.service.InitialInitiatorListProvider;
import io.quarkus.hibernate.orm.runtime.service.StandardHibernateORMInitiatorListProvider;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.BootstrapServiceRegistryImpl;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.integrator.spi.IntegratorService;

final class RecordableBootstrapFactory {
    private static final InitialInitiatorListProvider reactiveInitiatorListProvider = RecordableBootstrapFactory.initReactiveListProviderMaybe();
    private static final InitialInitiatorListProvider classicInitiatorListProvider = new StandardHibernateORMInitiatorListProvider();

    RecordableBootstrapFactory() {
    }

    public static RecordableBootstrap createRecordableBootstrapBuilder(QuarkusPersistenceUnitDefinition puDefinition) {
        BootstrapServiceRegistry bsr = RecordableBootstrapFactory.buildBootstrapServiceRegistry();
        RecordableBootstrap ssrBuilder = new RecordableBootstrap(bsr, RecordableBootstrapFactory.getInitiatorListProvider(puDefinition));
        return ssrBuilder;
    }

    private static InitialInitiatorListProvider getInitiatorListProvider(QuarkusPersistenceUnitDefinition puDefinition) {
        if (puDefinition.isReactive()) {
            if (reactiveInitiatorListProvider == null) {
                throw new IllegalStateException("InitiatorList requires for Hibernate Reactive but Hibernate Reactive extension is not around?");
            }
            return reactiveInitiatorListProvider;
        }
        return classicInitiatorListProvider;
    }

    private static BootstrapServiceRegistry buildBootstrapServiceRegistry() {
        ClassLoaderService providedClassLoaderService = FlatClassLoaderService.INSTANCE;
        QuarkusIntegratorServiceImpl integratorService = new QuarkusIntegratorServiceImpl(providedClassLoaderService);
        QuarkusStrategySelectorBuilder strategySelectorBuilder = new QuarkusStrategySelectorBuilder();
        StrategySelector strategySelector = QuarkusStrategySelectorBuilder.buildSelector(providedClassLoaderService);
        return new BootstrapServiceRegistryImpl(true, providedClassLoaderService, strategySelector, (IntegratorService)integratorService);
    }

    private static InitialInitiatorListProvider initReactiveListProviderMaybe() {
        try {
            Class<?> forName = Class.forName("io.quarkus.hibernate.reactive.runtime.boot.registry.ReactiveHibernateInitiatorListProvider");
            Object o = forName.newInstance();
            return (InitialInitiatorListProvider)o;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }
}

