/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.recording;

import io.quarkus.hibernate.orm.runtime.boot.QuarkusEnvironment;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusJtaPlatformInitiator;
import io.quarkus.hibernate.orm.runtime.service.DialectFactoryInitiator;
import io.quarkus.hibernate.orm.runtime.service.DisabledJMXInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusMutableIdentifierGeneratorFactoryInitiator;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRegionFactoryInitiator;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.cfgxml.internal.CfgXmlAccessServiceInitiator;
import org.hibernate.boot.cfgxml.internal.ConfigLoader;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.engine.config.internal.ConfigurationServiceInitiator;
import org.hibernate.engine.jdbc.batch.internal.BatchBuilderInitiator;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.MultiTenantConnectionProviderInitiator;
import org.hibernate.engine.jdbc.cursor.internal.RefCursorSupportInitiator;
import org.hibernate.engine.jdbc.dialect.internal.DialectResolverInitiator;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentInitiator;
import org.hibernate.engine.jdbc.internal.JdbcServicesInitiator;
import org.hibernate.engine.jndi.internal.JndiServiceInitiator;
import org.hibernate.event.internal.EntityCopyObserverFactoryInitiator;
import org.hibernate.hql.internal.QueryTranslatorFactoryInitiator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.persister.internal.PersisterClassResolverInitiator;
import org.hibernate.persister.internal.PersisterFactoryInitiator;
import org.hibernate.property.access.internal.PropertyAccessStrategyResolverInitiator;
import org.hibernate.resource.beans.spi.ManagedBeanRegistryInitiator;
import org.hibernate.resource.transaction.internal.TransactionCoordinatorBuilderInitiator;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.SessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.service.spi.ServiceContributor;
import org.hibernate.tool.hbm2ddl.ImportSqlCommandExtractorInitiator;
import org.hibernate.tool.schema.internal.SchemaManagementToolInitiator;

public final class RecordableBootstrap
extends StandardServiceRegistryBuilder {
    private final Map settings;
    private final List<StandardServiceInitiator> initiators = RecordableBootstrap.standardInitiatorList();
    private final List<ProvidedService> providedServices = new ArrayList<ProvidedService>();
    private final List<Class<? extends Service>> postBuildProvidedServices = new ArrayList<Class<? extends Service>>();
    private boolean autoCloseRegistry = true;
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private final ConfigLoader configLoader;
    private final LoadedConfig aggregatedCfgXml;

    public RecordableBootstrap(BootstrapServiceRegistry bootstrapServiceRegistry) {
        this(bootstrapServiceRegistry, LoadedConfig.baseline());
    }

    public RecordableBootstrap(BootstrapServiceRegistry bootstrapServiceRegistry, LoadedConfig loadedConfigBaseline) {
        this.settings = new HashMap();
        this.settings.putAll(QuarkusEnvironment.getInitialProperties());
        this.bootstrapServiceRegistry = bootstrapServiceRegistry;
        this.configLoader = new ConfigLoader(bootstrapServiceRegistry);
        this.aggregatedCfgXml = loadedConfigBaseline;
    }

    public LoadedConfig getAggregatedCfgXml() {
        return this.aggregatedCfgXml;
    }

    private static List<StandardServiceInitiator> standardInitiatorList() {
        ArrayList<StandardServiceInitiator> serviceInitiators = new ArrayList<StandardServiceInitiator>();
        serviceInitiators.add((StandardServiceInitiator)CfgXmlAccessServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ConfigurationServiceInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)PropertyAccessStrategyResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ImportSqlCommandExtractorInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)SchemaManagementToolInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)JdbcEnvironmentInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)JndiServiceInitiator.INSTANCE);
        serviceInitiators.add(DisabledJMXInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)PersisterClassResolverInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)PersisterFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)MultiTenantConnectionProviderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)DialectResolverInitiator.INSTANCE);
        serviceInitiators.add(DialectFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)BatchBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)JdbcServicesInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)RefCursorSupportInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)QueryTranslatorFactoryInitiator.INSTANCE);
        serviceInitiators.add(new QuarkusMutableIdentifierGeneratorFactoryInitiator());
        serviceInitiators.add(QuarkusJtaPlatformInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)SessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceInitiators.add(QuarkusRegionFactoryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)TransactionCoordinatorBuilderInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)ManagedBeanRegistryInitiator.INSTANCE);
        serviceInitiators.add((StandardServiceInitiator)EntityCopyObserverFactoryInitiator.INSTANCE);
        serviceInitiators.trimToSize();
        return serviceInitiators;
    }

    public BootstrapServiceRegistry getBootstrapServiceRegistry() {
        return this.bootstrapServiceRegistry;
    }

    public StandardServiceRegistryBuilder loadProperties(String resourceName) {
        this.settings.putAll(this.configLoader.loadProperties(resourceName));
        return this;
    }

    public StandardServiceRegistryBuilder loadProperties(File file) {
        this.settings.putAll(this.configLoader.loadProperties(file));
        return this;
    }

    public StandardServiceRegistryBuilder configure() {
        return this.configure("hibernate.cfg.xml");
    }

    public StandardServiceRegistryBuilder configure(String resourceName) {
        return this.configure(this.configLoader.loadConfigXmlResource(resourceName));
    }

    public StandardServiceRegistryBuilder configure(File configurationFile) {
        return this.configure(this.configLoader.loadConfigXmlFile(configurationFile));
    }

    public StandardServiceRegistryBuilder configure(URL url) {
        return this.configure(this.configLoader.loadConfigXmlUrl(url));
    }

    public StandardServiceRegistryBuilder configure(LoadedConfig loadedConfig) {
        this.aggregatedCfgXml.merge(loadedConfig);
        this.settings.putAll(loadedConfig.getConfigurationValues());
        return this;
    }

    public StandardServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.settings.put(settingName, value);
        return this;
    }

    public StandardServiceRegistryBuilder applySettings(Map settings) {
        this.settings.putAll(settings);
        return this;
    }

    public void clearSettings() {
        this.settings.clear();
    }

    public StandardServiceRegistryBuilder addInitiator(StandardServiceInitiator initiator) {
        this.initiators.add(initiator);
        this.postBuildProvidedServices.add(initiator.getServiceInitiated());
        return this;
    }

    public StandardServiceRegistryBuilder addService(Class serviceRole, Service service) {
        this.providedServices.add(new ProvidedService(serviceRole, (Object)service));
        return this;
    }

    public StandardServiceRegistryBuilder disableAutoClose() {
        this.autoCloseRegistry = false;
        return this;
    }

    public StandardServiceRegistryBuilder enableAutoClose() {
        this.autoCloseRegistry = true;
        return this;
    }

    public StandardServiceRegistry build() {
        this.applyServiceContributingIntegrators();
        this.applyServiceContributors();
        HashMap<String, LoadedConfig> settingsCopy = new HashMap<String, LoadedConfig>();
        settingsCopy.putAll(this.settings);
        settingsCopy.put("hibernate.boot.CfgXmlAccessService.key", this.aggregatedCfgXml);
        ConfigurationHelper.resolvePlaceHolders(settingsCopy);
        return new StandardServiceRegistryImpl(this.autoCloseRegistry, this.bootstrapServiceRegistry, this.initiators, this.providedServices, settingsCopy);
    }

    private void applyServiceContributingIntegrators() {
        for (Integrator integrator : ((IntegratorService)this.bootstrapServiceRegistry.getService(IntegratorService.class)).getIntegrators()) {
            if (!ServiceContributingIntegrator.class.isInstance(integrator)) continue;
            ((ServiceContributingIntegrator)ServiceContributingIntegrator.class.cast(integrator)).prepareServices((StandardServiceRegistryBuilder)this);
        }
    }

    private void applyServiceContributors() {
        Collection serviceContributors = ((ClassLoaderService)this.bootstrapServiceRegistry.getService(ClassLoaderService.class)).loadJavaServices(ServiceContributor.class);
        for (ServiceContributor serviceContributor : serviceContributors) {
            serviceContributor.contribute((StandardServiceRegistryBuilder)this);
        }
    }

    public List<ProvidedService> getProvidedServices() {
        return this.providedServices;
    }

    @Deprecated
    public Map getSettings() {
        return this.settings;
    }

    public static void destroy(ServiceRegistry serviceRegistry) {
        if (serviceRegistry == null) {
            return;
        }
        ((StandardServiceRegistryImpl)serviceRegistry).destroy();
    }

    public List<Class<? extends Service>> getPostBuildProvidedServices() {
        return this.postBuildProvidedServices;
    }
}

